#!/bin/bash
# Refer to unknown.sh for documentation on the layout of this file

is_distro_valid() {
	(cat /etc/debian_version > /dev/null 2>&1) && return 0
}

initialize_startup_directory_information() {
	initd_directory="/etc/init.d"
	rcd_directory="/etc"
}

get_oldest_file_epoch_time() {
	base_linux_get_oldest_file_epoch_time "$1"
}

update_mtime_to_5min_future() {
	base_linux_update_mtime_to_5min_future "$1"
}

build_start_service_action() {
	base_linux_build_start_service_action
}

build_stop_and_remove_service_action() {
	base_linux_build_stop_and_remove_service_action "$1"
}

get_existing_service_names() {
	base_linux_get_existing_service_names
}

build_startup_actions() {
	base_linux_build_startup_actions
}

dependency_check() {
	base_linux_dependency_check
}

build_dependency_action() {
	case $1 in
		"libz1"|"libavformat53"|"libavutil51"|"libswscale2"|"libavcodec53")
			local packageName=$1

			if [ "$packageName" == "libavcodec53" ]; then packageName="libavcodec-extra-53"; fi

			if ! apt-cache show $packageName &>/dev/null; then return 0; fi

			installer_actions[${#installer_actions[*]}]="apt-get install $packageName --assume-yes"
			installer_action_descriptions[${#installer_action_descriptions[*]}]="Install $packageName with Advanced Package Tool (apt)"
			return 1
			;;
		*)
			return 0
			;;
	esac
}

launch_web_page() {
	base_linux_launch_web_page "$1"
}
