#!/bin/bash
# Refer to unknown.sh for documentation on the layout of this file

is_distro_valid() {
	(uname -a | grep Darwin > /dev/null) && return 0
}

initialize_startup_directory_information() {
	launchd_directory="/Library/LaunchDaemons"
}

get_oldest_file_epoch_time() {
	local directory=$1
	local oldest_file=$(ls -t "$directory" | tail -1)
	oldest_file_mtime=$(stat -t "%s" "$directory/$oldest_file" | awk '{print $9}' | sed -e s/\"//g)
}

update_mtime_to_5min_future() {
	touch -t `date -v +5M "+%Y%m%d%H%M.%S"` "$1"
}

build_start_service_action() {
	installer_actions[${#installer_actions[*]}]="launchctl load \"${launchd_directory}/${service_name}.plist\"; sleep 20"
	installer_action_descriptions[${#installer_action_descriptions[*]}]="Load and start the launch daemon"
}

build_stop_and_remove_service_action() {
	local servicename=$1
	local filepath="${launchd_directory}/${1}.plist"

	installer_actions[${#installer_actions[*]}]="launchctl unload \"$filepath\""
	installer_action_descriptions[${#installer_action_descriptions[*]}]="Stop the existing launch daemon at $filepath"

	installer_actions[${#installer_actions[*]}]="rm -f \"$filepath\""
	installer_action_descriptions[${#installer_action_descriptions[*]}]="Remove launch daemon configuration at $filepath"
}

get_existing_service_names() {
	service_names=($(grep -l "$installation_directory" "$launchd_directory/"* 2>/dev/null | xargs -I{} basename {} | sed -e s/\.plist//g | tr "\n" " "))
}

build_startup_actions() {
	local filepath="${launchd_directory}/${service_name}.plist"

	installer_actions[${#installer_actions[*]}]="sed 's|INSTALL_DIRECTORY|$installation_directory|g' \"$INSTALL_DIRECTORY/screenconnect.plist\" | sed 's|SERVICE_NAME|$service_name|g' > \"$filepath\""
	installer_action_descriptions[${#installer_action_descriptions[*]}]="Create launch daemon configuration file at $filepath"
}

dependency_check() {
	:
	# TODO so for now we don't have a recommended way to map the required libav libraries from linux filenames (so) to mac filenames (dylib)
	# this will only disable the function of transcoding an audit video that was recorded to the server
	# the dllmap section of the web.config can eventually be used for this, but as this functionality isn't crucial, and there is no fix, we'll keep our mouth shut during the install
}

build_dependency_action() {
	:
}

launch_web_page() {
	echo "Opening a browser to your new ScreenConnect installation..."
	open "$1"
}
