#!/bin/bash
# Script to perform distribution-specific operations for generic distro

is_distro_valid() {
	return 0
}

# Find the equivalent of init.d and rc.d for a distribution / OS
# It is allowable to prompt the user for input here, as well
# Many distributions will simply define a couple of variables in this function
# initd_directory and rcd_directory should be defined if the base_linux* functions are to be used for startup actions
initialize_startup_directory_information() {
	# is_upgrade is set by this point
	if [ $is_upgrade -eq 1 ]; then
		# If upgrading on unknown distro, we can search for startup scripts in /etc
		echo ""
		echo "Searching for service script locations, this may take a moment..."
		# If these aren't populated, we'll prompt the user below
		initd_directory=$(dirname `grep -rl "\"$installation_directory\"" /etc/init.d/* 2>/dev/null | head -1` 2>/dev/null)
		if [ "$initd_directory" == "" ]; then
			initd_directory=$(dirname `grep -rl "\"$installation_directory\"" /etc/* 2>/dev/null | head -1` 2>/dev/null)
		fi
		rcd_directory=$(dirname `find /etc -name "rc0.d" 2>/dev/null | head -n1` 2>/dev/null)
		
		if [[ "$initd_directory" != "" && "$rcd_directory" != "" ]]; then
			echo "Found init.d directory: $initd_directory and rcX.d: $rcd_directory/rcX.d"
			return
		else
			echo "Could not find your init.d and rcX.d directories..."
		fi
	fi

	# Still executing at this point means we don't know where the directories are, prompt with defaults
	initd_directory="/etc/init.d"
	echo ""
	echo "Where are init.d scripts on your system? (Most users should leave this default)"
	echo -n "[$initd_directory] "
	read input

	if [ "$input" != "" ]; then
		initd_directory=$input
	fi

	rcd_directory="/etc"
	echo ""
	echo "Where are rcX.d folders on your system? (Most users should leave this default)"
	echo -n "[$rcd_directory] "
	read input

	if [ "$input" != "" ]; then
		rcd_directory=$input
	fi
}

# Get the oldest file in the argument directory
# and set oldest_file_mtime to its epoch time
get_oldest_file_epoch_time() {
	base_linux_get_oldest_file_epoch_time "$1"
}

# Update the argument's file's mtime to 5 minutes from now
# in the future.  Can use a combination of date and touch
update_mtime_to_5min_future() {
	base_linux_update_mtime_to_5min_future "$1"
}

# This should place action and description to start the service in installer_actions
build_start_service_action() {
	base_linux_build_start_service_action
}

# This takes a single service name as a parameter (run in a loop from caller)
# It should build 3 actions:
# - Stop that associated service (if possible, suppressing errors is a good idea)
# - Remove that service name's startup script
# - Remove any other references (rc.d links) to that startup script
build_stop_and_remove_service_action() {
	base_linux_build_stop_and_remove_service_action "$1"
}

# Fill an array "service_names" with the names of any services (in init.d or wherever)
# that point to the installation at $installation_directory
get_existing_service_names() {
	base_linux_get_existing_service_names
}

# This should do whatever is necessary to make the service startup script and any links to it
# On linux, this means:
# - Copy the script to init.d
# - Create links to the init.d script in the rc.d folders
build_startup_actions() {
	base_linux_build_startup_actions
}

# Check dependencies, most linuxes can simply call base_linux_dependency_check
dependency_check() {
	base_linux_dependency_check
}

# Take a dependency string and add the appropriate action/description to a global list
# This function is called from a loop
# If an action is successfully built as the result of a dependency resolution, it should return 1
# If the dependency cannot be resolved, it should return 0
# If the dependency could be installed but the version is too old, it should return -1
# No-op means dependency was not resolved
build_dependency_action() {
	:
}

launch_web_page() {
	base_linux_launch_web_page "$1"
}
