<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:param name="oldVersion" />
	<xsl:param name="defaultResxPath" />

	<!-- basic identity transform -->
	<xsl:template match="node()|@*">
		<xsl:copy>
			<xsl:apply-templates select="node()|@*" />
		</xsl:copy>
	</xsl:template>

	<!-- identity transform for self-closing tags -->
	<xsl:template match="*[not(text()) and not(*)]">
		<xsl:copy>
			<xsl:apply-templates select="@*" />
		</xsl:copy>
	</xsl:template>

	<!-- grab the application title from web resources -->
	<xsl:template match="/root/data[@name='ApplicationTitle']/value">
		<xsl:copy>
			<xsl:choose>
				<xsl:when test="number($oldVersion) &lt; 3.1">
					<xsl:value-of select="document($defaultResxPath)/root/data[@name='Client.ApplicationTitle']/value" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:apply-templates select="node()|@*" />
				</xsl:otherwise>
			</xsl:choose>
		</xsl:copy>
	</xsl:template>

	<!-- additions -->
	<xsl:template match="/root">
		<xsl:copy>
			<xsl:apply-templates select="node()|@*" />

			<xsl:if test="count(data[@name='ThemeCloseButtonBackColor']) = 0" xml:space="preserve">
  <data name="ThemeCloseButtonBackColor" xml:space="preserve">
    <value>#C85050</value>
  </data>
			</xsl:if>

			<xsl:if test="count(data[@name='ApplicationIcon48']) = 0" xml:space="preserve">
  <data name="ApplicationIcon48" type="System.Byte[], mscorlib">
    <value>
        iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAYAAABXAvmHAAABGklEQVR42u3YUQ7CIAwG4J1pbzuGbofc
        AfRoLuoecCT6ZJXR/qWCJenjgG+UJrTrfDQwDuM4H6cplIq4XrWbhyMsNv8KB1AAaH4mUlUDcNMsFtv8
        F/UTUAYEM8B56ENOnIZ+rhpAIaoDxHBAyYsVU6ZqAHVS/wWgjjAnR3NznSqVbABn81IAhWADEFWCO48D
        qA+p/ERc4lSphAE0q1ALgGuzAPZaDnCAIuDbh80B9nQlOIBkVwIFeMZ9i+VTEH92ScSa7AuBAVkNKUhj
        iwvg9EYRgLdUlTwkchFSAHnPSj7luFXoZ96i5gBpA9ccIG19OyAXgCiVpgBEqTQHIIfKWs0B9nYl0A1c
        GKBkOEDSG5UGNFVLI7TuWVXjAXmK07KP9yf+AAAAAElFTkSuQmCC
</value>
  </data>
  <data name="ApplicationIcon256" type="System.Byte[], mscorlib">
    <value>
        iVBORw0KGgoAAAANSUhEUgAAAQAAAAEACAYAAABccqhmAAAKtklEQVR42u3dMUhdWRoHcAsLCwuLFBYp
        LFJYWIRZCweEESawsuuCLBYWKVKkkCUDU1ikSGFhIWwWLALTBFbYwAwkkAxhcWACCVikmMJiCgsLCwuL
        FBYWKSzcc5aTIEyIJrn3vXve9/vg38rz3O/7vXffve/coSGllFJKKaWUUkop1Wj9fWlpPGUmZU6kgcym
        TJis7g78SMpyypOU45QzkRZykrKdcjtlzOT1f/CHU1ZSjjSn9Dj5jWYtv/mYxP4M/0TKa40ofc5ByrSJ
        7O3wz3jXl46dGiyZzN4M/2TKG00nHctpyrwJbXf4R1P2NZt0+HsBVwtaBGBTk0nH86tJbWf4r5WPWZpM
        up45E9s8APc1llSSbRPbPACHGksq+kLwiqltbvivayqpLMsmtzkAbmooqSz3TW5zAKxpKKksWyYXABI3
        L0wuACRuXplcAAgAFAAEAAoAAgAFAAGAAoAAQFUCQP6Z506+titV5EUHbh0HQOUA5B2HNvJtyI5AtX2T
        f0G62qc9JABQKQB5e6e7NnscqP7Jm8fe6vFOUgCoEIDd/K5hxQe2j66Ubb0BAIA/JJ/jj1rtEJ8GfgAA
        AM7nN8MfrqceAwAANnKM21N5g9k9AABgxQqH7as5AMQGIF8eGrbCoXvrOQDiArBqdcP31jwA4gJw1eqG
        763hlp4oDYCOA7BnZVXpr2cAiAfAEyurSn+tAyAeAJtWVpX+ugWAeACsWVkFAAAo/QUAACgAAAAACgAA
        AIACAAAA0LP679dfjaRMBM4wAFRkAOZSzgLnNGU3ZT1lCgAKALHzvFcQAAAAAOjup4K1tk8PAAAAAHQ7
        T1NGAQAAAMRGYBgAAABA3GwAAAAAiP2dwAwAAACAuHkJAAAAIHZmAAAAAMTNJgAAAIC42QMAAAAQO6MA
        AAAA4mYSAAAAQNzMAQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA3QdgMmWrgrzKd+IB
        AAAACFxpAMdSbpa9+wAAAAAExmAqZRsAAABAbAhup7wFAAAAEBeB2ZQTAAAAALEROAWAAkBcBO4AQAEg
        NgI7AFAAiAvAHAAUAGIj8BoACgBxAVgFgAJAXACuA0ABIC4AwwBQAIiNwAEAFAAAAIDPWLzxcmfVXNT8
        429/fZAW9KDJ5L8ZeE2vN7mvPgAaBiD9cwspj1KObPzw/2y10JRb1vWr3ZT1lAkAdACA9E8tpuxrTAD0
        IT+2BQEALl6g0ZTHmhAAfU7+Fd8tAPQQgHKOv6f5ANCh/BMAPQCgvPMbfgB0MWsAaB+ApxoNAB3OIgBa
        AqBsqKjJANDl5KtQYwBoGIBye+SBBgNAhFMBAPxxQZY1FgAqyZuUEQA0C4BzfwDUlAUANAvAiaYCQEXZ
        BEBDAJRHQGkqANSUHQA0B4CHQAKgthwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAOgvAcXlo41Yt+de332yVnYEbS/6blfz/T8refacAAMCXDH3eBXd2qMKyLfj7zWPyT8hfAgAAl01+
        19hs4jfdAOgUBnmb+N8AAICLNnOYHRqAAsAH+yjvKbEBAAB8KHmfwatDA1IA+Ohw3ezB9wMAqAiAo7Yf
        9ACAziGwCgAAvMuNoQErAFxqyH4EAAAeDg1gAeBSQ3alXO0BQFAA8nngOADiPh04b+AJgLgA/DQ0oAWA
        T/oU8BYAMQFYAkBsAEp/bQMgJgBjAABAS1cEANBxAA6HBrgA8EnDNg+AeADsAAAApb+mABAPgFcAAEDp
        rwkAAAAAAAAAAAAAAAAAAAAAAAAAAACAPgEwU/q+yYwBAAAAqACACvoLAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
        AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAD6CkB6wfdTDhrO9wAAAADqAGCrq0MGAAAAAABNv7aHAABA
        6a87AIgHwC8AAEDpr00AxAPgGAAAKP21A4B4AOTMAiA2AKkHrqScAiAmAA8AEB6AOy31FgAqAOBtyjgA
        YgKQjv1wyj4A4gKQ828AhAXgbot9BYBKAMhZBEAsANIxv14+AQIAAEsnKdMAiAFAPu0rd6qeAQAA7y8L
        DsJVAQBc2EvXUvZ60E8AqAyAs3I5aDV/OQSAwQMgHdelAv0ZAADwsezW+r0AAD7YP9Mp2z3uIQBUDMC7
        5EtEGynztVwuBMD7m3tmU+4VzPvROwAYAACqTEGgsXy38Jdl6woAAFSSFt5R56wrAAAAAAEAAAAgAAAA
        AAQAAACAAAAAABAAAAAAUvICAAAAQNxsAaA5ANyIAoDasgGA5gCY1FAAqCxLAGjw4Rvpbx1qKgBUkvyr
        0jEANAvAhsYCQCV5+rFfawHg817feMtbOAEAAE1lDgAtPH8v/b11zQWAat/9AfDFr3Gkj7/vBoBclKML
        940AwBe/zomy0BoOAF3KyaX2lARAY5cFXRUAQF3DD4BGmzJ/Kfhc8wGgz8mnpJOXXkwANN6cyy0+3gkA
        APjY+f6dT95BGgCtQXAj5SEMANBi8mnnT+VNZ+SzFhMAPcFgpHxZGC5rf/52tun++vnrPx1GXc9zGWuk
        OQGg2izbgnf/AAFAAQAAAFAAAAAAFAAAMKAAbDjiAFBxAXjmiANAxQXgjSMOABUXgLNL3yOtAACAgQTg
        kaMOABUXgLw/2jVHHgAqJgA5Lx15AKi4AOTcc/QB4ADFBSBnWQcAAABxAci5qwsAAIC4AJyVnXwmdAMA
        ABATgLOyx//mJ22npAAAgIEB4Hx+T3mQspKyWHag6XJmAKAAEDcHAFAAAAAAFAAAAAAFAAAAQAEAAABQ
        AAAAABQAAAAABQAAAEB1HIANgw0AAMQF4LbBBgAA4gIwZbABAICgABQEPGYbAAAIDMA9ww0AAMQFYCzl
        2IADAAABASgIrBhwAAAgKAAFgceGHAAAiAvAaMqOQQcAAAICcA6BbcMOAAAEBOAcBKtl/z6DDwAVDYCC
        wHjZwPPE8ANABQPgHAQjKQsFg19SdvMwBMwOAFQ4AFQV/QUAACgAAAAACgAACAHArpVVpb9mABAPgGMr
        q0p/LQEgHgA5nrGncn9tAiAmAN9bXZX6YB8AMQH43eqG763plnoLABUAkLNohUP31lMAxAZgL2XYKofs
        qxst9hUAKgEgZ9Mqh+upK3lIAQCAd1mx0mH6aTRlp+V+AkBlALgqEKOXxnow/ACoFICc/+QmseoD2Ucz
        LX/sB8AAAJBzlD8NpIxY/YHon8mUrR73EAAqBuBdTkrjLKdMAaGqL/hmU1Z79HEfAAMKgAgAACACAACI
        AAAAIgAAgAgAACACAACIAAAAIgAAgAgAGgTgmoaSyvLC5DaLwLGmkoqyYWqbBeCRppKKcsPUNgvAgqaS
        SnJom7l2ENjVXFJBbCzTEgDzmks6nn0/G28XgR80mXQ0p3nXIVPaLgDDfdzkQeRjuW1Ce4NA3tX1Vw0n
        HXrnt6t0Hz4JbJTF14TSz2/8XfLrIwTTPg1IH5JvTFu3g3R3IJgqB+R1ylsNKi3kTcqzfK6fT0NNXbdB
        uJoyIdJQDLxSSimllFJKtVf/AyRc6gtEAjmCAAAAAElFTkSuQmCC
</value>
  </data>
			</xsl:if>

			<xsl:if test="count(data[@name='ApplicationTitleClientFormat']) = 0" xml:space="preserve">
  <data name="ApplicationTitleClientFormat" xml:space="preserve">
    <value>{0} Client</value>
  </data>
			</xsl:if>

			<xsl:if test="count(data[@name='GuestAnonymousName']) = 0" xml:space="preserve">
  <data name="GuestAnonymousName" xml:space="preserve">
    <value>Guest</value>
  </data>
			</xsl:if>

			<!-- 4.0 -->
			<xsl:if test="count(data[@name='InfoPanelGalleryCaptureModeDescription']) = 0" xml:space="preserve">
  <data name="InfoPanelGalleryCaptureModeDescription" xml:space="preserve">
    <value>Currently in Gallery Capture Mode. Your device or this app distribution does not support Live Capture Mode.

Any image added to the Gallery while running will be sent to your session. Take a screenshot using key combinations specific to your phone and manufacturer. Key combinations ordered from most common to least common:

POWER+HOME
POWER+VOLDOWN
POWER+BACK
POWER+VOLUP

Switch away from this app to conduct your session. Click the Back button from this screen to disconnect your session.</value>
  </data>
  <data name="InfoPanelGalleryCaptureModeTitle" xml:space="preserve">
    <value>Gallery Capture Mode</value>
  </data>
  <data name="InfoPanelLiveCaptureModeDescription" xml:space="preserve">
    <value>Currently in Live Capture Mode. Your device can be viewed and controlled.

Switch away from this app to conduct your session. Click the Back button from this screen to disconnect your session.</value>
  </data>
  <data name="InfoPanelLiveCaptureModeTitle" xml:space="preserve">
    <value>Live Capture Mode</value>
  </data>
			</xsl:if>

			<!-- 4.1 -->
			<xsl:if test="count(data[@name='CommandMuteMicrophoneFalse']) = 0" xml:space="preserve">
  <data name="CommandMuteMicrophoneFalse" xml:space="preserve">
    <value>Unmute</value>
  </data>
  <data name="CommandMuteMicrophoneTrue" xml:space="preserve">
    <value>Mute</value>
  </data>
  <data name="CommandSelectSoundCaptureModeAllMicrophones" xml:space="preserve">
    <value>All Mics</value>
  </data>
  <data name="CommandSelectSoundCaptureModeHostMicrophone" xml:space="preserve">
    <value>Host Mic</value>
  </data>
  <data name="CommandSelectSoundCaptureModeSilent" xml:space="preserve">
    <value>Silent</value>
  </data>
  <data name="CommandSelectSoundCaptureModeSpeakers" xml:space="preserve">
    <value>Speakers</value>
  </data>
  <data name="ControlPanelMuteMicrophoneDescription" xml:space="preserve">
    <value>Turn off your microphone to talk without transmitting sound to other participants.</value>
  </data>
  <data name="ControlPanelMuteMicrophoneTitle" xml:space="preserve">
    <value>Mute Microphone</value>
  </data>
  <data name="ControlPanelSelectMicrophoneDescription" xml:space="preserve">
    <value>Choose the microphone to use for voice.</value>
  </data>
  <data name="ControlPanelSelectMicrophoneTitle" xml:space="preserve">
    <value>Select Microphone</value>
  </data>
  <data name="ControlPanelSelectSoundCaptureModeDescription" xml:space="preserve">
    <value>Choose the sound capture mode for the session.</value>
  </data>
  <data name="ControlPanelSelectSoundCaptureModeTitle" xml:space="preserve">
    <value>Select Mode</value>
  </data>
  <data name="ControlPanelSelectSpeakersDescription" xml:space="preserve">
    <value>Choose the speakers to use for participant voices and remote speakers.</value>
  </data>
  <data name="ControlPanelSelectSpeakersTitle" xml:space="preserve">
    <value>Select Speakers</value>
  </data>
  <data name="ControlPanelSetSpeakersVolumeDescription" xml:space="preserve">
    <value>Set the level of sound for participant voices and remote speakers.</value>
  </data>
  <data name="ControlPanelSetSpeakersVolumeTitle" xml:space="preserve">
    <value>Set Speakers Volume</value>
  </data>
  <data name="ControlPanelSoundTitle" xml:space="preserve">
    <value>Sound</value>
  </data>
  <data name="ControlPanelViewMicrophoneLevelDescription" xml:space="preserve">
    <value>View the level currently captured from the microphone. Adjust the microphone volume in your operating system.</value>
  </data>
  <data name="ControlPanelViewMicrophoneLevelTitle" xml:space="preserve">
    <value>Microphone Level</value>
  </data>
			</xsl:if>

			<!-- 4.1 -->
			<xsl:if test="count(data[@name='TrayLink1Text']) = 0" xml:space="preserve">
  <data name="TrayLink1Text" xml:space="preserve">
    <value></value>
  </data>
  <data name="TrayLink1Url" xml:space="preserve">
    <value></value>
  </data>
  <data name="TrayLink2Text" xml:space="preserve">
    <value></value>
  </data>
  <data name="TrayLink2Url" xml:space="preserve">
    <value></value>
  </data>
  <data name="TrayLink3Text" xml:space="preserve">
    <value></value>
  </data>
  <data name="TrayLink3Url" xml:space="preserve">
    <value></value>
  </data>
  <data name="TrayLink4Text" xml:space="preserve">
    <value></value>
  </data>
  <data name="TrayLink4Url" xml:space="preserve">
    <value></value>
  </data>
			</xsl:if>
		</xsl:copy>
	</xsl:template>

	<!-- removals -->
	<xsl:template match="*[@name = 'EndPointStatusSleepingForInvalidKeyTitle']" />
	<xsl:template match="*[@name = 'EndPointStatusSleepingForInvalidKeyDescription']" />
	<xsl:template match="*[@name = 'NotifyIconBalloonBody']" />
	<xsl:template match="*[@name = 'TitleFormat']" />
	<xsl:template match="*[@name = 'TitleTextFormat']" />
	<xsl:template match="*[@name = 'InfoPanelCaptureModeTitle']" />
	<xsl:template match="*[@name = 'InfoPanelCaptureModeDescription']" />
	<xsl:template match="*[@name = 'ShareSoundLabelText']" />

	<!-- value changes -->
	<xsl:template match="text()[.='Suspend My Control']">Suspend My Input</xsl:template>
	<xsl:template match="text()[.='Block Guest Control']">Block Guest Input</xsl:template>

	<!-- name changes -->
	<xsl:template match="@name[.='CommandBlockGuestControlFalse']">
		<xsl:attribute name="name">CommandBlockGuestInputFalse</xsl:attribute>
	</xsl:template>
	<xsl:template match="@name[.='CommandBlockGuestControlTrue']">
		<xsl:attribute name="name">CommandBlockGuestInputTrue</xsl:attribute>
	</xsl:template>
	<xsl:template match="@name[.='CommandSuspendMyControlFalse']">
		<xsl:attribute name="name">CommandSuspendMyInputFalse</xsl:attribute>
	</xsl:template>
	<xsl:template match="@name[.='CommandSuspendMyControlTrue']">
		<xsl:attribute name="name">CommandSuspendMyInputTrue</xsl:attribute>
	</xsl:template>
	<xsl:template match="@name[.='CommandToggleBlockGuestControl']">
		<xsl:attribute name="name">CommandToggleBlockGuestInput</xsl:attribute>
	</xsl:template>
	<xsl:template match="@name[.='CommandToggleSuspendMyControl']">
		<xsl:attribute name="name">CommandToggleSuspendMyInput</xsl:attribute>
	</xsl:template>
	<xsl:template match="@name[.='ControlPanelBlockGuestControlDescription']">
		<xsl:attribute name="name">ControlPanelBlockGuestInputDescription</xsl:attribute>
	</xsl:template>
	<xsl:template match="@name[.='ControlPanelBlockGuestControlTitle']">
		<xsl:attribute name="name">ControlPanelBlockGuestInputTitle</xsl:attribute>
	</xsl:template>
	<xsl:template match="@name[.='ControlPanelSuspendMyControlDescription']">
		<xsl:attribute name="name">ControlPanelSuspendMyInputDescription</xsl:attribute>
	</xsl:template>
	<xsl:template match="@name[.='ControlPanelSuspendMyControlTitle']">
		<xsl:attribute name="name">ControlPanelSuspendMyInputTitle</xsl:attribute>
	</xsl:template>
	<xsl:template match="@name[.='ShareAllowControlLabelText']">
		<xsl:attribute name="name">ShareAllowInputLabelText</xsl:attribute>
	</xsl:template>
</xsl:stylesheet>
