<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:asmv1="urn:schemas-microsoft-com:asm.v1">
	<!-- basic identity transform -->
	<xsl:template match="node()|@*">
		<xsl:copy>
			<xsl:apply-templates select="node()|@*" />
		</xsl:copy>
	</xsl:template>

	<!-- identity transform for self-closing tags -->
	<xsl:template match="*[not(text()) and not(*)]">
		<xsl:copy>
			<xsl:apply-templates select="@*" />
		</xsl:copy>
	</xsl:template>

	<!-- add compatible frameworks -->
	<xsl:template match="//asmv1:assembly">
		<xsl:copy>
			<xsl:apply-templates select="node()|@*" />
			<compatibleFrameworks xmlns="urn:schemas-microsoft-com:clickonce.v2">
				<framework targetVersion="4.0" profile="Client" supportedRuntime="4.0.30319" />
			</compatibleFrameworks>
		</xsl:copy>
	</xsl:template>
</xsl:stylesheet>
