﻿<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:param name="oldVersion" />

	<!-- basic identity transform -->
	<xsl:template match="node()|@*">
		<xsl:copy>
			<xsl:apply-templates select="node()|@*" />
		</xsl:copy>
	</xsl:template>

	<!-- identity transform for self-closing tags -->
	<xsl:template match="*[not(text()) and not(*)]">
		<xsl:copy>
			<xsl:apply-templates select="@*" />
		</xsl:copy>
	</xsl:template>

	<xsl:template match="/Roles/Role/PermissionEntries">
		<xsl:copy>
			<xsl:apply-templates select="node()|@*" />

			<!-- add create meeting permission for anyone having CreateAttendedSession permission, which was the name pre-3.0 -->
			<xsl:if test="count(PermissionEntry[@Name='CreateAttendedSession']) &gt; 0">
				<PermissionEntry Name="CreateMeetingSession" AccessControlType="Allow" />
			</xsl:if>
		</xsl:copy>
	</xsl:template>

	<xsl:template match="//@Name[.='CreateAttendedSession']">
		<xsl:attribute name="Name">CreateSupportSession</xsl:attribute>
	</xsl:template>

	<xsl:template match="//@Name[.='BuildUnattendedInstaller']">
		<xsl:attribute name="Name">BuildAccessInstaller</xsl:attribute>
	</xsl:template>

	<xsl:template match="//@SessionGroupFilter[.='AttendedSessionGroups']">
		<xsl:attribute name="SessionGroupFilter">SupportSessionGroups</xsl:attribute>
	</xsl:template>

	<xsl:template match="//@SessionGroupFilter[.='UnattendedSessionGroups']">
		<xsl:attribute name="SessionGroupFilter">AccessSessionGroups</xsl:attribute>
	</xsl:template>

	<xsl:template match="//PermissionEntry[@Name='Administer']">
		<xsl:copy>
			<xsl:apply-templates select="node()|@*" />
		</xsl:copy>
		<xsl:text>&#xD;&#xA;      </xsl:text>
		<xsl:if test="number($oldVersion) &lt; 3.1">
			<PermissionEntry Name="ManageSharedToolbox" AccessControlType="Allow" />
		</xsl:if>
	</xsl:template>

	<xsl:template match="//PermissionEntry[@Name='JoinSession']">
		<xsl:copy>
			<xsl:apply-templates select="node()|@*" />
		</xsl:copy>
		<xsl:if test="number($oldVersion) &lt; 4.0">
			<xsl:text>&#xD;&#xA;      </xsl:text>
			<xsl:element name="PermissionEntry">
				<xsl:attribute name="xsi:type" namespace="http://www.w3.org/2001/XMLSchema-instance">SessionOwnershipPermissionEntry</xsl:attribute>
				<xsl:attribute name="Name">EditSession</xsl:attribute>
				<xsl:attribute name="AccessControlType">Allow</xsl:attribute>
				<xsl:attribute name="SessionGroupFilter">
					<xsl:value-of select="@SessionGroupFilter"/>
				</xsl:attribute>
				<xsl:if test="@SessionGroupName">
					<xsl:attribute name="SessionGroupName">
						<xsl:value-of select="@SessionGroupName"/>
					</xsl:attribute>
				</xsl:if>
				<xsl:attribute name="OwnershipFilter">
					<xsl:value-of select="@OwnershipFilter"/>
				</xsl:attribute>
			</xsl:element>
			<xsl:text>&#xD;&#xA;      </xsl:text>
			<xsl:element name="PermissionEntry">
				<xsl:attribute name="xsi:type" namespace="http://www.w3.org/2001/XMLSchema-instance">SessionOwnershipPermissionEntry</xsl:attribute>
				<xsl:attribute name="Name">RunCommandOutsideSession</xsl:attribute>
				<xsl:attribute name="AccessControlType">Allow</xsl:attribute>
				<xsl:attribute name="SessionGroupFilter">
					<xsl:value-of select="@SessionGroupFilter"/>
				</xsl:attribute>
				<xsl:if test="@SessionGroupName">
					<xsl:attribute name="SessionGroupName">
						<xsl:value-of select="@SessionGroupName"/>
					</xsl:attribute>
				</xsl:if>
				<xsl:attribute name="OwnershipFilter">
					<xsl:value-of select="@OwnershipFilter"/>
				</xsl:attribute>
			</xsl:element>
		</xsl:if>
		<xsl:if test="number($oldVersion) &lt; 3.1">
			<xsl:text>&#xD;&#xA;      </xsl:text>
			<xsl:element name="PermissionEntry">
				<xsl:attribute name="xsi:type" namespace="http://www.w3.org/2001/XMLSchema-instance">SessionOwnershipPermissionEntry</xsl:attribute>
				<xsl:attribute name="Name">TransferFilesInSession</xsl:attribute>
				<xsl:attribute name="AccessControlType">Allow</xsl:attribute>
				<xsl:attribute name="SessionGroupFilter">
					<xsl:value-of select="@SessionGroupFilter"/>
				</xsl:attribute>
				<xsl:if test="@SessionGroupName">
					<xsl:attribute name="SessionGroupName">
						<xsl:value-of select="@SessionGroupName"/>
					</xsl:attribute>
				</xsl:if>
				<xsl:attribute name="OwnershipFilter">
					<xsl:value-of select="@OwnershipFilter"/>
				</xsl:attribute>
			</xsl:element>
			<xsl:text>&#xD;&#xA;      </xsl:text>
			<xsl:element name="PermissionEntry">
				<xsl:attribute name="xsi:type" namespace="http://www.w3.org/2001/XMLSchema-instance">SessionOwnershipPermissionEntry</xsl:attribute>
				<xsl:attribute name="Name">RunSharedToolInSession</xsl:attribute>
				<xsl:attribute name="AccessControlType">Allow</xsl:attribute>
				<xsl:attribute name="SessionGroupFilter">
					<xsl:value-of select="@SessionGroupFilter"/>
				</xsl:attribute>
				<xsl:if test="@SessionGroupName">
					<xsl:attribute name="SessionGroupName">
						<xsl:value-of select="@SessionGroupName"/>
					</xsl:attribute>
				</xsl:if>
				<xsl:attribute name="OwnershipFilter">
					<xsl:value-of select="@OwnershipFilter"/>
				</xsl:attribute>
			</xsl:element>
			<xsl:text>&#xD;&#xA;      </xsl:text>
			<xsl:element name="PermissionEntry">
				<xsl:attribute name="xsi:type" namespace="http://www.w3.org/2001/XMLSchema-instance">SessionOwnershipPermissionEntry</xsl:attribute>
				<xsl:attribute name="Name">HostSessionWithoutConsent</xsl:attribute>
				<xsl:attribute name="AccessControlType">Allow</xsl:attribute>
				<xsl:attribute name="SessionGroupFilter">
					<xsl:value-of select="@SessionGroupFilter"/>
				</xsl:attribute>
				<xsl:if test="@SessionGroupName">
					<xsl:attribute name="SessionGroupName">
						<xsl:value-of select="@SessionGroupName"/>
					</xsl:attribute>
				</xsl:if>
				<xsl:attribute name="OwnershipFilter">
					<xsl:value-of select="@OwnershipFilter"/>
				</xsl:attribute>
			</xsl:element>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>
