﻿<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<!-- basic identity transform -->
	<xsl:template match="node()|@*">
		<xsl:copy>
			<xsl:apply-templates select="node()|@*" />
		</xsl:copy>
	</xsl:template>

	<!-- identity transform for self-closing tags -->
	<xsl:template match="*[not(text()) and not(*)]">
		<xsl:copy>
			<xsl:apply-templates select="@*" />
		</xsl:copy>
	</xsl:template>

	<!-- add meeting groups between support and access groups -->
	<xsl:template match="/SessionGroups[count(SessionGroup[@SessionType='Meeting']) = 0]">
		<xsl:copy>
			<xsl:apply-templates select="text()|*[@IncludeSelfInvitations='false']" />
			<SessionGroup Name="All Meetings" SessionType="Meeting" IsSystem="true" SessionFilter="" />
			<SessionGroup Name="My Meetings" SessionType="Meeting" IsSystem="false" SessionFilter="Host = $USERNAME" />
			<xsl:apply-templates select="text()|*[@IncludeSelfInvitations='true']" />
		</xsl:copy>
	</xsl:template>
</xsl:stylesheet>
