<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:user="urn:Elsinore.ScreenConnect" exclude-result-prefixes="msxsl user">
	<xsl:output omit-xml-declaration="yes" encoding="ASCII" />
	<xsl:param name="configuration" />
	<xsl:param name="platform" />

	<msxsl:script language="C#" implements-prefix="user" xml:space="preserve">

		public string GenerateKey(int byteLength)
		{
			byte[] key = new byte[byteLength];
			System.Security.Cryptography.RandomNumberGenerator rng = System.Security.Cryptography.RandomNumberGenerator.Create();
			System.Text.StringBuilder builder = new System.Text.StringBuilder();

			rng.GetBytes(key);

			foreach (byte b in key)
				builder.Append(b.ToString("X2"));

			return builder.ToString();
		}

		public string GenerateAsymmetricKey()
		{
			System.Security.Cryptography.RSACryptoServiceProvider asymmetricAlgorithm = new System.Security.Cryptography.RSACryptoServiceProvider(2048);
			byte[] asymmetricKey = asymmetricAlgorithm.ExportCspBlob(true);
			return Convert.ToBase64String(asymmetricKey);
		}

	</msxsl:script>

	<!-- basic identity transform -->
	<xsl:template match="node()|@*">
		<xsl:copy>
			<xsl:apply-templates select="node()|@*" />
		</xsl:copy>
	</xsl:template>

	<!-- identity transform for self-closing tags -->
	<xsl:template match="*[not(text()) and not(*)]">
		<xsl:copy>
			<xsl:apply-templates select="@*" />
		</xsl:copy>
	</xsl:template>

	<!-- set debug based on parameter -->
	<xsl:template match="/configuration/system.web/compilation/@debug">
		<xsl:attribute name="debug">
			<xsl:choose>
				<xsl:when test="$configuration = 'Debug'">true</xsl:when>
				<xsl:otherwise>false</xsl:otherwise>
			</xsl:choose>
		</xsl:attribute>
	</xsl:template>

	<!-- generating keys for new installations -->
	<xsl:template match="/configuration/system.web/machineKey/@decryptionKey[.='656E74657220796F757220706872617365206865726547A5']">
		<xsl:attribute name="decryptionKey">
			<xsl:value-of select="user:GenerateKey(24)"/>
		</xsl:attribute>
	</xsl:template>

	<xsl:template match="/configuration/system.web/machineKey/@validationKey[.='07C1493415E4405F085CB3010D2CD0E986EF8B1F']">
		<xsl:attribute name="validationKey">
			<xsl:value-of select="user:GenerateKey(20)"/>
		</xsl:attribute>
	</xsl:template>

	<xsl:template match="/configuration/appSettings/add[@key='AsymmetricKey']/@value[.='BwIAAACkAABSU0EyAAgAAAEAAQDTXYXqX9WrPrKoePAY3GIg6/TtNsauC2+wB32SzzGEK3JZ3J7ByLqaTfm3ST/E0PNnsq1LgppeSQL3JrO6X2zkmA558vBNwCF8LnaiZuNGoUoTwzWtMUCiiATkvhp71bNEFqOhgNa1u8StAcm8xyT5/9z8J0REzZYUP1h78zbjtdbUNI/Gg5fUlxDmB3lw5p9cJ98PD9PoJVlfmxw093aXTgO9kFYMDRwlsI42dL7oC8r8bl0o2Y/V/yCjbgBrm7J/NboawzzfZtemMg4l6f1G+TJ2gvhnImnDvmuhJZ2yd98/4eRPGuinXWbuFkjtqTEll/YBlyGLLb1vVKsxWhSiFVoqJ4ftEEK7LXz8O4Jfdc1zdi7/8wrrM5IvXUq42wVbmc7O3nOUp6fihV3WCU7c6NpV/BIkNGWtW3kM5epGWZ6aqBLKxuYla7vCxsygR9tLxkM91bLFZPr8rtRRt3R0/vImeqfRpmnIAjlKMDzomdikptQTGO6VaGN3FJzMoNxHWm9vp0GXbTo1Y14iioHqlZS2i/jAAZxKCLiWRvB5baJxW99eWzJm6C1tubiT4XYrcTtisl96BJT0KpQqCP8WbKC8G3ZuBVi/UIuI4hmZNWKjsweHgNF8UBHQ6F6ajKSVKqkMwmEbb14fd0xE+vgbyynMv2bSqp9jeVi3bI0QvCkW58NRsRzXuFOycFq5aBKuzwqq/CQrf73UjBAiPAp93g0ELV3GmbgsBmAocfVWD7pkhs6vvATE5Bt6ckytPfihGhshsn/Kyg/wydB91rnofa0pYE1tDOrp5Jed4hDev/52QiEa9i09+ahNtuqCEdz1O/tHAkW4xPX3UGpXx0oaAdxyXsyQE7TAiE7xE9g3gel1wOfmZ9H9hulZyMs1pGopYpVVBSmuP3ln7VQVhWKWjEIXNSo1hIR/BOq2p+4x2QOkVBj0qRKR3shsx4KLWiTKGzqXhACadq3FPl6AInm4zi7XJAfSHmINAw76RH9u6ecakCbkIMeSZf8aDG+Vmyre9ORPkuSt6mOnMto+n7I6XyNuWIC5FRDBXY4A6SiE3X0JgJYtDyKYLSuT2ENf9i7ppT6gsvD5AoAaMqbgWpKZ4NED3zaF6Wg0g/O9h9zyTvOxq53pOGuP09bRWprronhXFqLQOQorPZBGPZl+Uht4N6i3Lu7fito112qrJSF70bFXXsSURomHYcB9Z2Divxwggx2Mxo3B6ytasNL9VtGN6bnQ+Q5YQKNlNFOAr1muYV7Y8hX4cfRx6vmbdFFwx6Ss+RmPTNKm42cK2tsk6XRXAfziRG1aFSE9K3uvNaBW5WMkSLIijpPXLNL8rbNK6rnHBJqTy3RDQFXdYV0+aVO2H1+MqJ4IB7P/DsJeYHZnHnSv+BbZa1YDxfugxlHnZ2TQc9ek1AAiFMkXGSc+Nh5pW+JC0euyaYw7hbKky2hKfEs+bGIobYzrAm5wb4fOhuTQ3UvLQvh7wBcQMO9EK54b6bho8yaqAi9bzO8fCeGcbbXw43xCVhKk0mIVYAdlA10=']">
		<xsl:attribute name="value">
			<xsl:value-of select="user:GenerateAsymmetricKey()"/>
		</xsl:attribute>
	</xsl:template>

	<!-- upgrading and transforming -->
	<xsl:template match="/configuration/appSettings">
		<xsl:copy>
			<xsl:apply-templates select="node()|@*" />
			<xsl:if test="count(add[@key='ClientConfigDirectoryPath']) = 0" xml:space="preserve"> <add key="ClientConfigDirectoryPath" value="App_ClientConfig" />&#xD;&#xA; </xsl:if>
			<xsl:if test="count(add[@key='GuestInfoRefreshSeconds']) = 0" xml:space="preserve"> <add key="GuestInfoRefreshSeconds" value="1200" />&#xD;&#xA; </xsl:if>
			<xsl:if test="count(add[@key='GuestScreenshotMaxScale']) = 0 and count(add[@key='GuestScreenshotMaxScalePercent']) = 0" xml:space="preserve"> <add key="GuestScreenshotMaxScalePercent" value="20" />&#xD;&#xA; </xsl:if>
			<xsl:if test="count(add[@key='GuestScreenshotMaxPixelCount']) = 0" xml:space="preserve"> <add key="GuestScreenshotMaxPixelCount" value="30000" />&#xD;&#xA; </xsl:if>
			<xsl:if test="count(add[@key='MaxCommandResultCharacterCount']) = 0" xml:space="preserve"> <add key="MaxCommandResultCharacterCount" value="5000" />&#xD;&#xA; </xsl:if>
			<xsl:if test="count(add[@key='RunCommandKillAfterMilliseconds']) = 0" xml:space="preserve"> <add key="RunCommandKillAfterMilliseconds" value="10000" />&#xD;&#xA; </xsl:if>
			<xsl:if test="count(add[@key='CycleCapturesAfterSeconds']) = 0" xml:space="preserve"> <add key="CycleCapturesAfterSeconds" value="1800" />&#xD;&#xA; </xsl:if>
			<xsl:if test="count(add[@key='DefaultSupportSoundCaptureMode']) = 0" xml:space="preserve"> <add key="DefaultSupportSoundCaptureMode" value="Silent" />&#xD;&#xA; </xsl:if>
			<xsl:if test="count(add[@key='DefaultAccessSoundCaptureMode']) = 0" xml:space="preserve"> <add key="DefaultAccessSoundCaptureMode" value="Silent" />&#xD;&#xA; </xsl:if>
			<xsl:if test="count(add[@key='DefaultMeetingSoundCaptureMode']) = 0" xml:space="preserve"> <add key="DefaultMeetingSoundCaptureMode" value="AllMicrophones" />&#xD;&#xA; </xsl:if>
			<xsl:if test="count(add[@key='DefaultScreenQualityLevel']) = 0" xml:space="preserve"> <add key="DefaultScreenQualityLevel" value="High" />&#xD;&#xA; </xsl:if>
			<xsl:if test="count(add[@key='DisabledAutoPortForwarding']) = 0" xml:space="preserve"> <add key="DisabledAutoPortForwarding" value="false" />&#xD;&#xA; </xsl:if>
			<xsl:if test="count(add[@key='ShouldRevalidateAccessToken']) = 0" xml:space="preserve"> <add key="ShouldRevalidateAccessToken" value="false" />&#xD;&#xA; </xsl:if>
		</xsl:copy>
	</xsl:template>

	<xsl:template match="/configuration/appSettings/add[@key='SmtpUseClient']" />

	<xsl:template match="/configuration/appSettings/add/@key[.='SelfInvitationExpireSeconds']">
		<xsl:attribute name="key">AccessSessionExpireSeconds</xsl:attribute>
	</xsl:template>

	<xsl:template match="/configuration/appSettings/add[@key='GuestScreenshotMaxScale']">
		<xsl:element name="add">
			<xsl:attribute name="key">GuestScreenshotMaxScalePercent</xsl:attribute>
			<xsl:attribute name="value">
				<xsl:value-of select="@value * 100" />
			</xsl:attribute>
		</xsl:element>
	</xsl:template>

	<xsl:template match="/configuration/system.web/pages/namespaces">
		<xsl:copy>
			<xsl:apply-templates select="node()|@*" />
			<xsl:if test="count(add[@namespace='Elsinore.ScreenConnect']) = 0" xml:space="preserve"> <add namespace="Elsinore.ScreenConnect" />&#xD;&#xA;   </xsl:if>
		</xsl:copy>
	</xsl:template>

	<xsl:template match="/configuration/system.web/pages/@theme[.='HotDogStand' or .='PlainWithRed' or .='Plain']">
		<xsl:attribute name="theme">LightWithRed</xsl:attribute>
	</xsl:template>

	<xsl:template match="/configuration/system.web/pages/@theme[.='PlainWithBlue']">
		<xsl:attribute name="theme">LightWithBlue</xsl:attribute>
	</xsl:template>

	<xsl:template match="/configuration/system.web/pages/@theme[.='PlainWithGreen']">
		<xsl:attribute name="theme">LightWithGreen</xsl:attribute>
	</xsl:template>

	<xsl:template match="/configuration/system.web/authentication/forms">
		<xsl:copy>
			<xsl:attribute name="cookieless">UseCookies</xsl:attribute>
			<xsl:apply-templates select="node()|@*" />
		</xsl:copy>
	</xsl:template>

	<xsl:template match="/configuration/system.codedom/compilers/compiler">
		<xsl:copy>
			<xsl:attribute name="compilerOptions">/nowarn:1685</xsl:attribute>
			<xsl:apply-templates select="node()|@*" />
		</xsl:copy>
	</xsl:template>

	<xsl:template match="/configuration/system.web/compilation">
		<xsl:copy>
			<xsl:attribute name="defaultLanguage">c#</xsl:attribute>
			<xsl:apply-templates select="node()|@*" />
		</xsl:copy>
	</xsl:template>

	<xsl:template match="/configuration/system.web/urlMappings">
		<xsl:copy>
			<xsl:apply-templates select="node()|@*" />
			<xsl:if test="count(add[@url='~/Bin/Elsinore.ScreenConnect.WindowsClient.application']) = 0" xml:space="preserve"> <add url="~/Bin/Elsinore.ScreenConnect.WindowsClient.application" mappedUrl="~/Bin/Elsinore.ScreenConnect.Client.application" />&#xD;&#xA;   </xsl:if>
			<xsl:if test="count(add[@url='~/ChangePassword']) = 0" xml:space="preserve"> <add url="~/ChangePassword" mappedUrl="~/ChangePassword.aspx" />&#xD;&#xA;  </xsl:if>
		</xsl:copy>
	</xsl:template>

	<xsl:template match="/configuration/system.web/compilation/assemblies">
		<xsl:copy>
			<xsl:choose>
				<xsl:when test="$platform = 'Mono'">
					<xsl:apply-templates select="node()[not(contains(@assembly, 'System.Xml.Linq') or contains(@assembly, 'System.Data.Linq') or contains(@assembly, 'System.Core') or contains(@assembly, 'System.ServiceModel'))]" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:apply-templates select="node()|@*" />
				</xsl:otherwise>
			</xsl:choose>

			<xsl:if test="count(add[@assembly='Elsinore.ScreenConnect.Web']) = 0" xml:space="preserve"> <add assembly="Elsinore.ScreenConnect.Web" />&#xD;&#xA;   </xsl:if>
		</xsl:copy>
	</xsl:template>

	<xsl:template match="/configuration/system.web/httpRuntime">
		<xsl:copy>
			<xsl:attribute name="executionTimeout">600</xsl:attribute>
			<xsl:apply-templates select="node()|@*" />
		</xsl:copy>
	</xsl:template>

	<xsl:template match="/configuration/system.web/httpModules">
		<xsl:copy>
			<xsl:apply-templates select="node()|@*" />
			<xsl:if test="$platform = 'Mono' and count(add[@name='MonoRewriteModule']) = 0" xml:space="preserve"> <add name="MonoRewriteModule" type="Elsinore.ScreenConnect.MonoRewriteModule, Elsinore.ScreenConnect.MonoServer" />&#xD;&#xA;  </xsl:if>
		</xsl:copy>
	</xsl:template>

	<xsl:template match="/configuration/system.web/httpHandlers">
		<xsl:copy>
			<xsl:apply-templates select="node()|@*" />
			<xsl:if test="count(add[@path='App_Data/*']) = 0" xml:space = "preserve"> <add verb="GET" path="App_Data/*" type="System.Web.HttpForbiddenHandler" />&#xD;&#xA;  </xsl:if>
			<xsl:if test="count(add[@path='App_ClientConfig/*']) = 0" xml:space = "preserve"> <add verb="GET" path="App_ClientConfig/*" type="System.Web.HttpForbiddenHandler" />&#xD;&#xA;  </xsl:if>
			<xsl:if test="count(add[@path='*.xml']) = 0" xml:space = "preserve"> <add verb="GET" path="*.xml" type="System.Web.HttpForbiddenHandler" />&#xD;&#xA;  </xsl:if>
			<xsl:if test="count(add[@path='*.db']) = 0" xml:space = "preserve"> <add verb="GET" path="*.db" type="System.Web.HttpForbiddenHandler" />&#xD;&#xA;  </xsl:if>
			<xsl:if test="count(add[@path='ClientIcon.axd']) = 0" xml:space = "preserve">
   <add verb="GET" path="ClientIcon.axd" type="Elsinore.ScreenConnect.ClientIconHandler, Elsinore.ScreenConnect.Web" />
   <add verb="GET" path="Elsinore.ScreenConnect.Client.application" type="Elsinore.ScreenConnect.ClickOnceHandler, Elsinore.ScreenConnect.Web" />
   <add verb="GET" path="Elsinore.ScreenConnect.Client.jnlp" type="Elsinore.ScreenConnect.JavaWebStartDirectHandler, Elsinore.ScreenConnect.Web" />
   <add verb="GET" path="Elsinore.ScreenConnect.Client.zip" type="Elsinore.ScreenConnect.MacBundleHandler, Elsinore.ScreenConnect.Web" />
   <add verb="GET" path="Elsinore.ScreenConnect.Client.exe" type="Elsinore.ScreenConnect.ClickOnceExecutableHandler, Elsinore.ScreenConnect.Web" />
   <add verb="GET" path="Elsinore.ScreenConnect.ClientBootstrap.jnlp" type="Elsinore.ScreenConnect.JavaWebStartBootstrapHandler, Elsinore.ScreenConnect.Web" />
   <add verb="GET" path="Elsinore.ScreenConnect.ClientBootstrap.exe" type="Elsinore.ScreenConnect.ClickOnceExecutableHandler, Elsinore.ScreenConnect.Web" />
   <add verb="GET" path="Elsinore.ScreenConnect.ClientSetup.exe" type="Elsinore.ScreenConnect.WindowsBootstrapInstallerHandler, Elsinore.ScreenConnect.Web" />
   <add verb="GET" path="Elsinore.ScreenConnect.ClientSetup.msi" type="Elsinore.ScreenConnect.WindowsInstallerHandler, Elsinore.ScreenConnect.Web" />
   <add verb="GET" path="Elsinore.ScreenConnect.ClientSetup.pkg" type="Elsinore.ScreenConnect.MacInstallerHandler, Elsinore.ScreenConnect.Web" />
			</xsl:if>
			<xsl:if test="count(add[@path='*.jar']) = 0" xml:space = "preserve"> <add verb="GET" path="*.jar" type="Elsinore.ScreenConnect.JarHandler, Elsinore.ScreenConnect.Web" />&#xD;&#xA;  </xsl:if>
			<xsl:if test="count(add[@path='Elsinore.ScreenConnect.ClientSetup.deb']) = 0" xml:space = "preserve"> <add verb="GET" path="Elsinore.ScreenConnect.ClientSetup.deb" type="Elsinore.ScreenConnect.LinuxDebianPackageInstallerHandler, Elsinore.ScreenConnect.Web" />&#xD;&#xA;  </xsl:if>
			<xsl:if test="count(add[@path='Elsinore.ScreenConnect.ClientSetup.rpm']) = 0" xml:space = "preserve"> <add verb="GET" path="Elsinore.ScreenConnect.ClientSetup.rpm" type="Elsinore.ScreenConnect.LinuxRedHatPackageInstallerHandler, Elsinore.ScreenConnect.Web" />&#xD;&#xA;  </xsl:if>
		</xsl:copy>
	</xsl:template>

	<xsl:template match="/configuration/system.web">
		<xsl:copy>
			<xsl:apply-templates select="node()|@*" />
			<xsl:if test="count(hostingEnvironment) = 0" xml:space="preserve"> <hostingEnvironment shadowCopyBinAssemblies="false" />&#xD;&#xA; </xsl:if>
			<xsl:if test="count(healthMonitoring) = 0" xml:space="preserve"> <healthMonitoring enabled="false" />&#xD;&#xA; </xsl:if>
		</xsl:copy>
	</xsl:template>

	<!-- this is necessary because default is Predictable, which is incompatible with file upload stuff because the client script translates the wrong IDs -->
	<xsl:template match="/configuration/system.web/pages">
		<xsl:copy>
			<xsl:apply-templates select="@*" />
			<xsl:if test="$platform = 'Mono'">
				<xsl:attribute name="clientIDMode">AutoID</xsl:attribute>
			</xsl:if>
			<xsl:apply-templates select="node()" />
		</xsl:copy>
	</xsl:template>

	<xsl:template match="/configuration/system.web/httpHandlers/add[@path='JavaWebStart.axd']" />
	<xsl:template match="/configuration/system.web/httpHandlers/add[@path='Gradient.axd']" />
	<xsl:template match="/configuration/system.web/httpHandlers/add[@path='MacInstaller.axd']" />
	<xsl:template match="/configuration/system.web/httpHandlers/add[@path='WindowsInstaller.axd']" />
	<xsl:template match="/configuration/system.web/httpHandlers/add[@path='ClickOnceBootstrapper.axd']" />
	<xsl:template match="/configuration/system.web/httpHandlers/add[@path='Elsinore.ScreenConnect.WindowsClient.application']" />
	<xsl:template match="/configuration/system.web/httpHandlers/add[@path='Elsinore.ScreenConnect.Client.jnlp' and @type='Elsinore.ScreenConnect.JavaWebStartHandler, Elsinore.ScreenConnect.Web']" />

	<xsl:template match="/configuration/system.web/httpHandlers/add/@type[.='Elsinore.ScreenConnect.ClickOnceRunHandler, Elsinore.ScreenConnect.Web']">
		<xsl:attribute name="type">Elsinore.ScreenConnect.ClickOnceExecutableHandler, Elsinore.ScreenConnect.Web</xsl:attribute>
	</xsl:template>

	<xsl:template match="/configuration/system.web/httpHandlers/add/@type[.='Elsinore.ScreenConnect.ClickOnceBootstrapHandler, Elsinore.ScreenConnect.Web']">
		<xsl:attribute name="type">Elsinore.ScreenConnect.ClickOnceExecutableHandler, Elsinore.ScreenConnect.Web</xsl:attribute>
	</xsl:template>

	<xsl:template match="/configuration/system.web/httpHandlers/add/@type[.='Elsinore.ScreenConnect.LinuxRedhatPackageInstallerHandler, Elsinore.ScreenConnect.Web']">
		<xsl:attribute name="type">Elsinore.ScreenConnect.LinuxRedHatPackageInstallerHandler, Elsinore.ScreenConnect.Web</xsl:attribute>
	</xsl:template>

	<xsl:template match="/configuration/system.web/httpHandlers/add[@type='ScriptResource.axd']/@type">
	</xsl:template>

	<xsl:template match="/configuration/system.serviceModel//endpoint/@address[contains(., 'net.pipe') or contains(., 'http')]">
		<xsl:choose>
			<xsl:when test="$platform = 'Mono'">
				<xsl:attribute name="address">net.tcp://127.0.0.1:8042/scsm</xsl:attribute>
			</xsl:when>
			<xsl:otherwise>
				<xsl:copy />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="/configuration">
		<xsl:copy>
			<xsl:apply-templates select="node()|@*" />
			<xsl:if test="count(system.data) = 0" xml:space="preserve"> <system.data>
  <DbProviderFactories>
   <add name="SQLite" invariant="SQLite" description="SQLite" type="Elsinore.ScreenConnect.SQLite.SQLiteFactory, Elsinore.ScreenConnect.Server" />
  </DbProviderFactories>
 </system.data>
 <connectionStrings>
  <add name="SessionDatabase" providerName="SQLite" connectionString="Data Source=|DataDirectory|/Session.db; DateTimeKind=Utc; Foreign Keys=true; Page Size=4096; Cache Size=10000" />
 </connectionStrings>
</xsl:if>
		</xsl:copy>
	</xsl:template>
</xsl:stylesheet>