﻿<%@ Page Language="C#" MasterPageFile="~/Default.master" %>

<script runat="server">

	protected override void OnInit(EventArgs e)
	{
		base.OnInit(e);

		Permissions.AssertPermission(PermissionInfo.AdministerPermission, false);

		var tabIndexString = this.Context.Request.QueryString["Tab"];
		var tabIndex = string.IsNullOrEmpty(tabIndexString) ? 0 : int.Parse(tabIndexString);

		var tabs = new[]
		{
			new { ControlPath = "~/Status.ascx", Text = Resources.Default.AdministrationPanel_StatusTabName },
			new { ControlPath = "~/Security.ascx", Text = Resources.Default.AdministrationPanel_SecurityTabName },
			new { ControlPath = "~/Mail.ascx", Text = Resources.Default.AdministrationPanel_MailTabName },
			new { ControlPath = "~/License.ascx", Text = Resources.Default.AdministrationPanel_LicenseTabName },
			new { ControlPath = "~/Appearance.ascx", Text = Resources.Default.AdministrationPanel_AppearanceTabName },
			new { ControlPath = "~/Audit.ascx", Text = Resources.Default.AdministrationPanel_AuditTabName },
		};

		for (var i = 0; i < tabs.Length; i++)
		{
			var link = new HyperLink { NavigateUrl = "?Tab=" + i, Text = tabs[i].Text };

			if (i == tabIndex)
				link.CssClass = "Selected";

			this.tabPanel.Controls.Add(link);
		}

		var userControl = (UserControl)this.LoadControl(tabs[tabIndex].ControlPath);
		var dataControl = userControl as IDataControl;
		this.updatePanel.ContentTemplateContainer.Controls.Add(userControl);

		if (dataControl != null)
		{
			var buttonPanel = new HtmlGenericControl("div");
			updatePanel.ContentTemplateContainer.Controls.Add(buttonPanel);

			var button = new Button();
			button.Text = string.Format(Resources.Default.AdministrationPanel_SaveButtonTextFormat, tabs[tabIndex].Text);
			buttonPanel.Controls.Add(button);

			ScriptManager.GetCurrent(this).RegisterPostBackControl(button);

			buttonPanel.Controls.Add(new LiteralControl(" "));

			var loadingImage = new LoadingImage { CssClass = "SmallLoadingImage", ImageUrl = "Images/ActivityIndicator.gif", PostBackControl = button.ID };
			buttonPanel.Controls.Add(loadingImage);

			var label = new Label();
			label.EnableViewState = false;
			buttonPanel.Controls.Add(label);

			userControl.Load += delegate
			{
				if (!this.IsPostBack)
					dataControl.Refresh();
			};

			userControl.PreRender += delegate
			{
				buttonPanel.Visible = dataControl.IsSaveAllowed;
			};

			button.Click += delegate
			{
				if (this.IsValid)
				{
					Proc proc = delegate { dataControl.Save(); dataControl.Refresh(); };
					var successMessage = string.Format(Resources.Default.AdministrationPanel_SaveMessageFormat, tabs[tabIndex].Text);
					WebExtensions.ExecuteWithResult(label, successMessage, proc);
				}
			};
		}
	}

</script>
<asp:Content runat="server" ContentPlaceHolderID="Main">
	<form runat="server" id="form">
	<asp:ScriptManager runat="server" EnablePartialRendering="true" />
	<div id="masterPanel">
		<div id="masterSelectionPanel">
			<div>
				<h2>Administration</h2>
				<div runat="server" id="tabPanel" />
			</div>
		</div>
	</div>
	<div id="detailPanel">
		<div id="detailPanelContent">
			<asp:UpdatePanel runat="server" ID="updatePanel" UpdateMode="Conditional" />
		</div>
	</div>
	</form>
</asp:Content>
<asp:Content runat="server" ContentPlaceHolderID="RunScriptBeforeRender">
	<script type="text/javascript">
		Sys.WebForms.PageRequestManager.getInstance().add_endRequest(function (sender, eventArgs) {
			var error = eventArgs.get_error();

			if (error != null) {
				eventArgs.set_errorHandled(true);

				if (error.httpStatusCode != 0) {
					// ASP.NET prepends the name, which is very unfriendly, to the description, with a colon and space after
					var message = error.message.substring(error.name.length + 2);
					SC.ui.showModalErrorBox(message);
				}
			}
		});
	</script>
</asp:Content>