﻿<%@ Control Language="C#" EnableViewState="false" %>
<%@ Implements Interface="Elsinore.ScreenConnect.IDataControl" %>
<script runat="server">

	public void Refresh()
	{
		var configuration = Elsinore.ScreenConnect.WebConfigurationManager.OpenWebConfiguration();
		var pagesSection = Elsinore.ScreenConnect.WebConfigurationManager.GetSection<PagesSection>(configuration);
		this.themeList.SelectedValue = (pagesSection == null ? null : pagesSection.Theme);
		this.BindResources();
	}

	public void Save()
	{
		var configuration = Elsinore.ScreenConnect.WebConfigurationManager.OpenWebConfiguration();
		var pagesSection = Elsinore.ScreenConnect.WebConfigurationManager.GetSection<PagesSection>(configuration);
		pagesSection.Theme = this.themeList.SelectedValue;
		ServerToolkit.Instance.SaveConfiguration(configuration);

		for (var i = 0; i < this.repeater.Items.Count; i++)
		{
			var resourceFileRecord = ((ResourceFileRecord[])this.repeater.DataSource)[i];
			var gridView = this.repeater.Items[i].FindControl<GridView>();

			ServerExtensions.SafeSave(resourceFileRecord.FilePath, delegate(Stream stream)
			{
				using (var writer = new System.Resources.ResXResourceWriter(stream))
				{
					foreach (GridViewRow row in gridView.Rows)
					{
						var name = row.Cells[0].Text;
						var value = row.Cells[1].FindControl<ResourceEditControl>().Value;
						writer.AddResource(name, value);
					}

					writer.Generate();
				}
			});
		}
	}

	public bool IsSaveAllowed { get { return true; } }

	DictionaryEntry[] LoadResXResources(string resXFilePath)
	{
		using (var reader = new System.Resources.ResXResourceReader(resXFilePath))
			return reader.Cast<DictionaryEntry>().OrderBy(e => e.Key).ToArray();
	}

	protected override void OnInit(EventArgs e)
	{
		base.OnInit(e);
		this.BindThemes();
		this.BindResources();
	}

	void BindThemes()
	{
		this.themeList.Items.Clear();

		foreach (string themeName in Elsinore.ScreenConnect.WebConfigurationManager.GetThemeNames())
			this.themeList.Items.Add(themeName);
	}

	void BindResources()
	{
		this.repeater.DataSource = new[]
		{
			new ResourceFileRecord { ResourceKey = "AppearancePanel.WebResourcesLabelText", FilePath = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "App_GlobalResources/Default.resx") },
			new ResourceFileRecord { ResourceKey = "AppearancePanel.ClientResourcesLabelText", FilePath = Path.Combine(Path.Combine(AppDomain.CurrentDomain.BaseDirectory, AppSettingsCache.ClientConfigDirectoryPath), "Elsinore.ScreenConnect.Client.resx") },
		};

		this.repeater.DataBind();
	}

	protected override void OnPreRender(EventArgs e)
	{
		base.OnPreRender(e);

		var clickScript = string.Format(JavaScriptFormatter.Default, "SC.ui.showModalPage({0:js}, '/?{1}=' + {2}.value, {3:js}); return false;", Resources.Default.AppearancePanel_PreviewHeading, ServerConstants.ThemeParameterName, this.themeList.GetClientReference(), "ThemePreview");
		this.previewLink.Attributes.Add("onclick", clickScript);
	}

	class ResourceFileRecord
	{
		public string ResourceKey { get; set; }
		public string FilePath { get; set; }
	}

</script>
<dl>
	<dt runat="server" innerhtml="<%$ Resources:Default, AppearancePanel.VisualThemeLabelText %>" />
	<dd>
		<asp:DropDownList runat="server" ID="themeList" />
		<a runat="server" id="previewLink" href="#" enableviewstate="false" innerhtml="<%$ Resources:Default, AppearancePanel.PreviewLinkText %>" />
	</dd>
	<asp:Repeater runat="server" ID="repeater">
		<ItemTemplate>
			<dt runat="server" innerhtml='<%# Resources.Default.ResourceManager.GetString((string)Eval("ResourceKey")) %>' />
			<dd>
				<div class="ResourceStringPanel">
					<asp:GridView runat="server" DataSource='<%# this.LoadResXResources((string)Eval("FilePath")) %>' AutoGenerateColumns="false" CssClass="DataTable">
						<Columns>
							<asp:BoundField DataField="Key" HeaderText="<%$ Resources:Default, AppearancePanel.KeyHeaderText %>" />
							<asp:TemplateField HeaderText="<%$ Resources:Default, AppearancePanel.ValueHeaderText %>">
								<ItemTemplate>
									<asp:ResourceEditControl runat="server" ImageContentType="image/png" ImageWidthSourceString='<%# Eval("Key") %>' ImageHeightSourceString='<%# Eval("Key") %>' ImageWidthExpression="^[A-Za-z]+(\d+)$" ImageHeightExpression="^[A-Za-z]+(\d+)$" ImageMaxContentSizeFixedCount="4000" ImageMaxContentSizeWidthHeightMultiple="1.5" Value='<%# Eval("Value") %>' />
								</ItemTemplate>
							</asp:TemplateField>
						</Columns>
					</asp:GridView>
				</div>
			</dd>
		</ItemTemplate>
	</asp:Repeater>
</dl>
