﻿<%@ Control Language="C#" EnableViewState="false" %>
<script runat="server">

	AuditLevel auditLevel;

	protected override void OnLoad(EventArgs e)
	{
		base.OnLoad(e);

		if (string.IsNullOrEmpty(this.minTimeBox.Text))
			this.minTimeBox.Text = DateTime.Today.AddDays(1).AddMonths(-1).ToString();

		if (string.IsNullOrEmpty(this.maxTimeBox.Text))
			this.maxTimeBox.Text = DateTime.Today.AddDays(1).ToString();

		this.auditLevel = AppSettingsCache.AuditLevel;
	}

	protected override void OnPreRender(EventArgs e)
	{
		base.OnPreRender(e);

		var otherAuditLevel = (AuditLevel)(1 - this.auditLevel);
		this.auditTitleLabel.InnerHtml = this.currentLevelTitlePanel.InnerHtml = Resources.Default.ResourceManager.GetString(string.Format("AuditPanel.{0}LevelTitle", this.auditLevel));
		this.currentLevelDescriptionPanel.InnerHtml = Resources.Default.ResourceManager.GetString(string.Format("AuditPanel.{0}LevelDescription", this.auditLevel));
		this.otherLevelTitlePanel.InnerHtml = Resources.Default.ResourceManager.GetString(string.Format("AuditPanel.{0}LevelTitle", otherAuditLevel));
		this.otherLevelDescriptionPanel.InnerHtml = Resources.Default.ResourceManager.GetString(string.Format("AuditPanel.{0}LevelDescription", otherAuditLevel));
	}

	void OnChangeButtonClick(object sender, EventArgs e)
	{
		this.multiView.ActiveViewIndex = 1;
	}

	void OnStayButtonClick(object sender, EventArgs e)
	{
		this.multiView.ActiveViewIndex = 0;
	}

	void OnSwitchButtonClick(object sender, EventArgs e)
	{
		this.auditLevel = (AuditLevel)(1 - this.auditLevel);

		var configuration = Elsinore.ScreenConnect.WebConfigurationManager.OpenWebConfiguration();
		configuration.AppSettings.Settings.Remove(ServerConstants.AuditLevelSettingsKey);
		configuration.AppSettings.Settings.Add(ServerConstants.AuditLevelSettingsKey, this.auditLevel.ToString());
		ServerToolkit.Instance.SaveConfiguration(configuration);

		this.multiView.ActiveViewIndex = 0;
	}

	void OnQueryAuditLogButtonClick(object sender, EventArgs e)
	{
		var minTime = default(DateTime);
		var maxTime = default(DateTime);
		DateTime.TryParse(this.minTimeBox.Text, out minTime);
		DateTime.TryParse(this.maxTimeBox.Text, out maxTime);

		using (var sessionManager = ServiceChannelPool<ISessionManagerChannel>.Instance.Borrow())
		{
			this.list.DataSource = sessionManager.GetSessionAuditEntries(minTime, maxTime);
			this.list.DataBind();
		}
	}

	string GetAuditEntryDetailHtml(SessionAuditEntry auditEntry)
	{
		var sessionEvent = auditEntry.Detail as SessionEvent;
		var sessionCapture = auditEntry.Detail as SessionCapture;

		if (sessionEvent != null)
		{
			var encodedData = this.Server.HtmlEncode(sessionEvent.Data);
			return string.Format(Resources.Default.AuditPanel_AuditEntryEventFormat, sessionEvent.EventType, sessionEvent.Host, encodedData);
		}
		else if (sessionCapture != null)
		{
			var duration = sessionCapture.EndTime - sessionCapture.StartTime;
			var durationString = duration.ToDurationString();
			var captureSizeString = ServerExtensions.FormatFileSize(sessionCapture.ContentLength, false);
			var outputBaseFileName = Elsinore.ScreenConnect.Extensions.MakeValidFileName(string.Format(Resources.Default.AuditPanel_AuditEntryDownloadFileNameFormat, auditEntry.SessionName, sessionCapture.StartTime.Date));
			var downloadUrl = CaptureTranscoderHandler.GetUrl(auditEntry.SessionID, sessionCapture.CaptureID, outputBaseFileName);
			var estimatedFileSize = CaptureTranscoderHandler.EstimateFileSize(sessionCapture.DesktopSize.Width, sessionCapture.DesktopSize.Height, duration);
			var estimatedFileSizeString = ServerExtensions.FormatFileSize(estimatedFileSize, true);
			return string.Format(Resources.Default.AuditPanel_AuditEntryCaptureFormat, sessionCapture.DesktopSize.Width, sessionCapture.DesktopSize.Height, durationString, captureSizeString, downloadUrl, estimatedFileSizeString);
		}

		return null;
	}

</script>
<asp:MultiView runat="server" ID="multiView" ActiveViewIndex="0">
	<asp:View runat="server">
		<div style="float: right;">
			<span runat="server" id="auditTitleLabel" />
			<asp:LinkButton runat="server" Text="<%$ Resources:Default, AuditPanel.ChangeButtonText %>" OnClick="OnChangeButtonClick" />
		</div>
		<dl>
			<dt>Time Range:</dt>
			<dd>From:
				<asp:TextBox runat="server" ID="minTimeBox" />
				To:
				<asp:TextBox runat="server" ID="maxTimeBox" />
			</dd>
		</dl>
		<p>
			<asp:Button runat="server" ID="queryAuditLogButton" Text="<%$ Resources:Default, AuditPanel.QueryButtonText %>" OnClick="OnQueryAuditLogButtonClick" />
			<asp:LoadingImage runat="server" CssClass="SmallLoadingImage" PostBackControl="queryAuditLogButton" ImageUrl="Images/ActivityIndicator.gif" />
		</p>
		<asp:GridView runat="server" ID="list" CssClass="DataTable AuditTable" AutoGenerateColumns="false">
			<columns>
				<asp:BoundFieldEx DataField="Time" HeaderText="<%$ Resources:Default, AuditPanel.TimeHeaderText %>" DataFormatString="<%$ Resources:Default, AuditPanel.TimeFormat %>" ShouldConvertDateTimesToLocal="true" HeaderStyle-Width="22%" />
				<asp:BoundField DataField="SessionName" HeaderText="<%$ Resources:Default, AuditPanel.SessionHeaderText %>" HeaderStyle-Width="24%" />
				<asp:TemplateField HeaderText="<%$ Resources:Default, AuditPanel.DetailHeaderText %>" HeaderStyle-Width="54%">
					<ItemTemplate>
						<%# this.GetAuditEntryDetailHtml((SessionAuditEntry)Container.DataItem) %>
					</ItemTemplate>
				</asp:TemplateField>
			</columns>
		</asp:GridView>
	</asp:View>
	<asp:View runat="server">
		<dl>
			<dt runat="server" id="currentLevelTitlePanel" />
			<dd>
				<p runat="server" id="currentLevelDescriptionPanel" />
				<p>
					<asp:Button runat="server" Text="<%$ Resources:Default, AuditPanel.StayLevelText %>" OnClick="OnStayButtonClick" />
				</p>
			</dd>
			<dt runat="server" id="otherLevelTitlePanel" />
			<dd>
				<p runat="server" id="otherLevelDescriptionPanel" />
				<p>
					<asp:Button runat="server" Text="<%$ Resources:Default, AuditPanel.SwitchLevelText %>" OnClick="OnSwitchButtonClick" />
				</p>
			</dd>
		</dl>
	</asp:View>
</asp:MultiView>