﻿<%@ Page Language="C#" MasterPageFile="~/Default.master" %>

<script runat="server">
   
	protected override void OnInit(EventArgs e)
	{
		base.OnInit(e);

		Permissions.AssertPermission(new PermissionRequest(), false);

		this.changePassword.ContinueDestinationPageUrl =
		this.changePassword.CancelDestinationPageUrl = ServerConstants.HostPageUrl;
	}

	protected override void OnPreRender(EventArgs e)
	{
		base.OnPreRender(e);

		if (!this.Page.IsPostBack)
			this.SetFocus(this.changePassword.FindControl<Control>(c => c.ID == "CurrentPassword"));
	}

</script>

<asp:Content runat="server" ContentPlaceHolderID="Main">
	<div class="ContentPanel ChangePassword">
		<form runat="server">
		<h1 runat="server" innerhtml="<%$ Resources:Default, ChangePasswordPanel.Heading %>" />
		<asp:ChangePassword
			runat="server"
			ID="changePassword"
			CssClass="ChangePasswordTable"
			FailureTextStyle-CssClass="Failure"
			ChangePasswordTitleText=""
			SuccessTitleText=""
			PasswordLabelText="<%$ Resources:Default, ChangePasswordPanel.CurrentPasswordLabelText %>"
			NewPasswordLabelText="<%$ Resources:Default, ChangePasswordPanel.NewPasswordLabelText %>"
			ConfirmNewPasswordLabelText="<%$ Resources:Default, ChangePasswordPanel.ConfirmNewPasswordLabelText %>"
			ChangePasswordButtonText="<%$ Resources:Default, ChangePasswordPanel.ChangePasswordButtonText %>"
			ContinueButtonText="<%$ Resources:Default, ChangePasswordPanel.ContinueButtonText %>"
			CancelButtonText="<%$ Resources:Default, ChangePasswordPanel.CancelButtonText %>"
			SuccessText="<%$ Resources:Default, ChangePasswordPanel.SuccessText %>" />
		</form>
	</div>
</asp:Content>
