﻿<%@ Page Language="C#" MasterPageFile="~/Default.master" %>

<script runat="server">

	protected override void OnLoad(EventArgs e)
	{
		base.OnLoad(e);
		this.welcomePanel.Visible = Elsinore.ScreenConnect.Extensions.TryParseBool(DR.WelcomePanel_Visible);
	}

</script>
<asp:Content runat="server" ContentPlaceHolderID="Main">
	<div class="ContentPanel Guest">
		<asp:PlaceHolder runat="server" ID="welcomePanel">
			<h1 runat="server" innerhtml="<%$ Resources:Default, WelcomePanel.Heading %>" />
			<p runat="server" innerhtml="<%$ Resources:Default, WelcomePanel.Message %>" />
		</asp:PlaceHolder>
		<div id="emptyView">
			<h2 runat="server" innerhtml="<%$ Resources:Default, NoAvailableSessionsPanel.Heading %>" />
			<p runat="server" innerhtml="<%$ Resources:Default, NoAvailableSessionsPanel.Message %>" />
		</div>
		<div id="directView">
			<h2 runat="server" innerhtml="<%$ Resources:Default, DirectPanel.Heading %>" />
			<p runat="server" innerhtml="<%$ Resources:Default, DirectPanel.Message %>" />
			<p>
				<input type="button" id="directButton" class="GuestJoinButton" value="<%= DR.DirectPanel_ButtonText %>" />
			</p>
		</div>
		<div id="codeView">
			<h2 runat="server" innerhtml="<%$ Resources:Default, CodePanel.Heading %>" />
			<p runat="server" innerhtml="<%$ Resources:Default, CodePanel.Message %>" />
			<p>
				<input type="search" incremental="true" id="codeBox" />
				<input type="button" id="codeButton" class="GuestJoinButton" value="<%= DR.CodePanel_ButtonText %>" />
				<img id="codeLoadingImage" class="SmallLoadingImage" src="Images/ActivityIndicator.gif" style="display: none;" />
				<span id="codeNotFoundLabel" class="Failure" style="display: none;">
					<%= DR.CodePanel_InvalidCodeMessage %></span>
			</p>
		</div>
		<div id="publicView">
			<h2 runat="server" innerhtml="<%$ Resources:Default, PublicSessionPanel.Heading %>" />
			<p runat="server" innerhtml="<%$ Resources:Default, PublicSessionPanel.Message %>" />
			<table id="sessionTable" class="DataTable" cellspacing="0">
				<tr>
					<th style="width: 75px;">&nbsp;
					</th>
					<th style="width: 100px;">
						<%= DR.GuestSessionTable_HostHeader %>
					</th>
					<th style="width: 200px;">
						<%= DR.GuestSessionTable_NameHeader %>
					</th>
				</tr>
			</table>
		</div>
		<div id="loadingView">
		</div>
	</div>
</asp:Content>
<asp:Content runat="server" ContentPlaceHolderID="DeclareScript">
	<script type="text/javascript">

		function refresh(isDirty) {
			var invokeServiceProc = function (version, onSuccess, onFailure) {
				var sessionCode = SC.ui.get("codeBox").value.trim();
				return SC.service.getGuestSessionInfo(sessionCode, window._directSessionID, version, onSuccess, onFailure);
			};

			SC.ui.startSessionInfoRefreshLoop(isDirty, invokeServiceProc, window.onSessionInfoChanged);
		}

		function onSessionInfoChanged() {
			if (window._directSessionID && window._sessionInfo.ss == null)
				window._directSessionID = null;

			if (window._joinSessionID) {
				var joinSession = SC.util.findListElement(window._sessionInfo.lss, function (ss) { return ss.clp.s == window._joinSessionID });

				if (joinSession == null && window._sessionInfo.ss && window._sessionInfo.ss.clp.s == window._joinSessionID)
					joinSession = window._sessionInfo.ss;

				if (joinSession == null) {
					SC.ui.hideModalDialog();
				} else if (joinSession.st == SC.context.types.SessionType.Support && joinSession.gcc != 0) {
					SC.ui.showModalMessageBox(SC.res["ConnectedPanel.Title"], SC.res["ConnectedPanel.Message"]);
					window._joinSessionID = null;
				}
			}

			SC.ui.setVisible(SC.ui.get("codeLoadingImage"), false);
			SC.ui.setVisible(SC.ui.get("codeNotFoundLabel"), window._sessionInfo.ss == null && SC.ui.get("codeBox").value.trim().length != 0);
			SC.ui.rebuildTableRows(SC.ui.get("sessionTable"), 1, window._sessionInfo.lss, function (s) { return s.clp.s; }, window.initializeSessionRow, window.updateSessionRow);
			window.updateUI();
		}

		function beginJoinSession(session) {
			window._joinSessionID = session.clp.s;

			if (SC.util.getSessionTypeResource("JoinPromptPanel.{0}Visible", session.st) === "true") {
				var headingText = SC.util.getSessionTypeResource("JoinPromptPanel.{0}Heading", session.st);
				var messageText = SC.util.getSessionTypeResource("JoinPromptPanel.{0}Message", session.st);
				var buttonText = SC.util.getSessionTypeResource("JoinPromptPanel.{0}ButtonText", session.st);

				var participantNameBox = SC.ui.createTextBox(false, null, "Default");

				SC.ui.showModalButtonDialog("Prompt", headingText, buttonText, "Default",
					function (container) {
						var messageParagraph = SC.ui.addElement(container, "P");
						SC.ui.setElementContent(messageParagraph, messageText, true);

						var participantNameParagraph = SC.ui.addElement(container, "P", null, null, participantNameBox);

						if (SC.util.getSessionTypeResource("JoinPromptPanel.{0}ParticipantNameBoxVisible", session.st) !== "true")
							SC.ui.setVisible(participantNameParagraph, false);
					},
					function (command) {
						window.showJoinDialog(session, participantNameBox.value.trim());
					}
				);

				participantNameBox.focus();
			} else {
				window.showJoinDialog(session);
			}
		}

		function showJoinDialog(session, participantName) {
			var panel = SC.ui.createElement("DIV");

			SC.ui.addElement(panel, "H1", { className: "LoadingHeading" }, null, SC.res["JoinPanel.ActivityMessage"]);

			var troubleParagraph = SC.ui.addElement(panel, "P", { className: "TroubleParagraph" }, null, SC.res["JoinPanel.TroubleMessage"]);
			var optionParagraph = SC.ui.addElement(panel, "P", { className: "OptionParagraph" });
			SC.ui.setVisible(optionParagraph, false);

			SC.ui.addNonBreakingSpace(troubleParagraph);
			var tryAnotherLink = SC.ui.addElement(troubleParagraph, "A", null, null, SC.res["JoinPanel.TryAnotherMessage"]);

			var attemptIndex = 0;
			var clp = SC.util.getCombinedClientLaunchParameters(SC.context.clp, session.clp, session.st, SC.context.types.ProcessType.Guest, participantName);

			var launchFunc = function () {
				var launcher = SC.launch.getLauncher(attemptIndex++);
				launcher.launch(clp);

				var joinData = SC.util.formatString("({0}) {1}", launcher.name, window.navigator.userAgent);
				SC.service.logInitiatedJoin(session.clp.s, joinData);

				return launcher;
			};

			tryAnotherLink.onclick = function () {
				var launcher = launchFunc();

				var optionParagraphContent = SC.util.formatString(SC.res["JoinPanel.TryingMessage"], attemptIndex, launcher.name);
				SC.ui.setElementContent(optionParagraph, optionParagraphContent, true);
				SC.ui.setVisible(optionParagraph, true);

				return false;
			};

			SC.ui.showModalDialog("JoinSession", SC.res["JoinPanel.Title"], panel);
			launchFunc();
		}

		function initializeSessionRow(row) {
			var buttonCell = SC.ui.addCell(row);
			SC.ui.addCell(row);
			SC.ui.addCell(row);

			SC.ui.addElement(buttonCell, "INPUT", { type: "button", _commandName: "Join", value: SC.res["GuestSessionTable.ButtonText"] });
		}

		function updateSessionRow(row) {
			SC.ui.setElementContent(row.cells[1], row._dataItem.h);
			SC.ui.setElementContent(row.cells[2], row._dataItem.clp.i);
		}

		function updateUI() {
			var wasCodeVisible = SC.ui.getVisible(SC.ui.get("codeView"));
			var isDirectVisible = window._directSessionID != null;
			var isCodeVisible = !isDirectVisible && window._sessionInfo != null && window._sessionInfo.hcs;
			var isPublicVisible = !isDirectVisible && window._sessionInfo != null && window._sessionInfo.lss.length != 0;

			SC.ui.setVisible(SC.ui.get("loadingView"), window._sessionInfo == null);
			SC.ui.setVisible(SC.ui.get("emptyView"), window._sessionInfo != null && !isDirectVisible && !isCodeVisible && !isPublicVisible);
			SC.ui.setVisible(SC.ui.get("directView"), isDirectVisible);
			SC.ui.setVisible(SC.ui.get("codeView"), isCodeVisible);
			SC.ui.setVisible(SC.ui.get("publicView"), isPublicVisible);

			SC.ui.get("codeButton").disabled = SC.ui.get("directButton").disabled = (window._sessionInfo == null || window._sessionInfo.ss == null);

			if (!wasCodeVisible && isCodeVisible)
				SC.ui.get("codeBox").focus();
		}

		function onCodeBoxSearch(event) {
			var codeBox = SC.ui.get("codeBox");

			if (codeBox.value != window._codeBoxSearchText) {
				window._codeBoxSearchText = codeBox.value;
				SC.ui.get("codeButton").disabled = true;
				SC.ui.setVisible(SC.ui.get("codeLoadingImage"), true);
				SC.ui.setVisible(SC.ui.get("codeNotFoundLabel"), false);
				window.refresh(true);
			}

			return true;
		}

		function onCodeBoxKeyUp(event) {
			var eventArgs = SC.ui.getEventArgs(event);

			if (SC.ui.isEnterKey(eventArgs)) {
				var codeBox = SC.ui.getElement(eventArgs);
				SC.ui.dispatchCommand(codeBox, codeBox, codeBox, "Join", null);
			}

			return true;
		}

	</script>
</asp:Content>
<asp:Content runat="server" ContentPlaceHolderID="RunScriptBeforeRender">
	<script type="text/javascript">
		var queryStringMap = SC.util.parseQueryString(window.location.search);
		window._directSessionID = SC.util.coalesce(queryStringMap["Session"], null);

		var codeBox = SC.ui.get("codeBox");
		codeBox.value = SC.util.coalesce(queryStringMap["Code"], "");
		SC.ui.addSearchHandler(codeBox, window.onCodeBoxSearch);
		SC.ui.addHandler(codeBox, "keyup", window.onCodeBoxKeyUp);

		SC.util.forEach(["codeButton", "directButton"], function (en) {
			var e = SC.ui.get(en);
			e._commandName = "Join";
			SC.ui.addCommandHandler(e);
		});

		window.document.documentElement._oncommand = function (command) {
			if (command.commandName == "Join") {
				var dataElement = SC.ui.findAncestorNode(command.clickedElement, function (e) { return e._dataItem != undefined });
				var session = null;

				if (dataElement != null)
					session = dataElement._dataItem;

				if (session == null && window._sessionInfo)
					session = window._sessionInfo.ss;

				if (session != null)
					window.beginJoinSession(session);
			}
		};

		window.updateUI();
		window.refresh(true);
	</script>
</asp:Content>
