﻿<%@ Page Language="C#" MasterPageFile="~/Default.master" %>

<script runat="server">

	protected override void OnLoad(EventArgs e)
	{
		base.OnLoad(e);

		var permissionEntries = Permissions.GetEntriesForUser();
		Permissions.AssertPermission(new PermissionRequest(), permissionEntries, false);

		this.AddJavascriptObjectDeclaration("window._hostContext", new
		{
			guestUrl = ServerExtensions.GetWebServerUri(ConfigurationManager.AppSettings, HttpContext.Current.Request.Url, true, false).Uri.ToString(),
			userPermissions = new
			{
				createSupportSession = Permissions.HasPermission(PermissionInfo.CreateSupportSessionPermission, permissionEntries),
				createMeetingSession = Permissions.HasPermission(PermissionInfo.CreateMeetingSessionPermission, permissionEntries),
				buildAccessInstaller = Permissions.HasPermission(PermissionInfo.BuildAccessInstallerPermission, permissionEntries),
				manageSessionGroups = Permissions.HasPermission(PermissionInfo.ManageSessionGroupsPermission, permissionEntries),
			}
		});
	}

</script>
<asp:Content runat="server" ContentPlaceHolderID="Main">
	<div id="masterPanel">
		<div id="masterSelectionPanel"></div>
		<div id="manageSessionGroupsPanel"></div>
	</div>
	<div id="detailPanel">
		<div id="detailSelectionPanel">
			<div id="detailTableHeader"></div>
			<div id="detailSuggestionTableHeader"></div>
			<div id="detailTableContainer">
				<div id="detailEmptyPanel"></div>
				<table id="detailTable"></table>
			</div>
		</div>
		<div id="detailViewPanel">
			<div id="detailCommandPanel"></div>
			<h2 id="detailTitleHeading"></h2>
			<div id="detailTabList"></div>
			<div id="detailTabContent"></div>
		</div>
	</div>
</asp:Content>
<asp:Content runat="server" ContentPlaceHolderID="DeclareScript">
	<script type="text/javascript">

		function refresh(isDirty) {
			if (isDirty)
				SC.ui.ensureCssClass(SC.ui.get("detailSelectionPanel"), "Loading", true);

			var invokeServiceProc = function (version, onSuccess, onFailure) {
				return SC.service.getHostSessionInfo(
					window.getSessionGroupUrlPart(),
					window.getSearchUrlPart(),
					window.getSessionUrlPart(),
					version,
					onSuccess,
					onFailure
				);
			};

			SC.ui.startSessionInfoRefreshLoop(isDirty, invokeServiceProc, window.onSessionInfoChanged);
		}

		function onSessionInfoChanged(requestVersion) {
			var masterSelectionPanel = SC.ui.get("masterSelectionPanel");
			window.rebuildManageSessionGroupsPanel(masterSelectionPanel, SC.context.types.SessionType.Support, window._sessionInfo.sgs, window._hostContext.userPermissions.createSupportSession);
			window.rebuildManageSessionGroupsPanel(masterSelectionPanel, SC.context.types.SessionType.Meeting, window._sessionInfo.sgs, window._hostContext.userPermissions.createMeetingSession);
			window.rebuildManageSessionGroupsPanel(masterSelectionPanel, SC.context.types.SessionType.Access, window._sessionInfo.sgs, window._hostContext.userPermissions.buildAccessInstaller);

			var selectedSessionGroupSummary = window._sessionInfo.sgs[window._sessionInfo.sgi];
			var emptyResourceName = "HostPanel.EmptyMessage";
			var shouldRebuildSessionTable = true;

			if (selectedSessionGroupSummary != null) {
				window.setSessionGroupUrlPart(selectedSessionGroupSummary.n);
				emptyResourceName = SC.util.formatString("HostPanel.{0}EmptyMessage", SC.util.getEnumValueName(SC.context.types.SessionType, selectedSessionGroupSummary.st));
				window.selectSessionGroup(selectedSessionGroupSummary.n, true);
				shouldRebuildSessionTable = (selectedSessionGroupSummary.tv > requestVersion);
			}

			SC.ui.ensureCssClass(SC.ui.get("masterPanel"), "Loading", false);
			SC.ui.ensureCssClass(SC.ui.get("detailSelectionPanel"), "Loading", false);

			if (shouldRebuildSessionTable) {
				SC.ui.ensureCssClass(SC.ui.get("detailTableContainer"), "Empty", window._sessionInfo.sss.length == 0);
				SC.ui.get("detailEmptyPanel").innerHTML = SC.res[emptyResourceName];

				SC.ui.rebuildTableRows(
					SC.ui.get("detailTable"),
					0,
					window._sessionInfo.sss,
					function (ss) { return ss.clp.s; },
					window.initializeSessionRow,
					window.updateSessionRow,
					SC.util.getMillisecondCount(),
					SC.util.getMillisecondCount()
				);

				window.clearInterval(window._refreshSessionTableIntervalID);

				window._refreshSessionTableIntervalID = window.setInterval(function () {
					SC.ui.refreshTableRowsWithExistingData(
						SC.ui.get("detailTable"),
						0,
						window.updateSessionRow,
						SC.util.getMillisecondCount()
					);
				}, 60000);
			} else {
				SC.ui.refreshTableRowsWithNewData(
					SC.ui.get("detailTable"),
					0,
					window._sessionInfo.sss,
					function (ss) { return ss.clp.s; },
					window.updateSessionRow,
					SC.util.getMillisecondCount(),
					SC.util.getMillisecondCount()
				);
			}

			var sessionID = window.getSessionUrlPart();
			var session = (SC.util.isNullOrEmpty(sessionID) ? null : window.selectSession(sessionID, true));

			var commandName = window.getCommandNameUrlPart();

			if (!SC.util.isNullOrEmpty(commandName)) {
				var commandArgument = window.getCommandArgumentUrlPart();
				SC.ui.dispatchCommand(window.document.body, window.document.body, window.document.body, commandName, commandArgument);
			}

			window.setCommandNameUrlPart(null);
			window.setCommandArgumentUrlPart(null);

			window.updateDetailViewPanel();
		}

		function addSessionGroupTypePanel(container, sessionType, shouldRenderButton, buttonProc) {
			var panel = SC.ui.addElement(container, "DIV", { _sessionType: sessionType });

			if (shouldRenderButton)
				SC.ui.addElement(panel, "A", { _commandName: "CreateSession", _commandArgument: sessionType }, null, "+");

			var headingText = SC.util.getSessionTypeResource("HostPanel.{0}Heading", sessionType);
			SC.ui.addElement(panel, "H2", null, null, headingText);

			SC.ui.addElement(panel, "DIV");
		}

		function rebuildManageSessionGroupsPanel(container, sessionType, sessionGroupSummaries, preventOuterPanelHide) {
			var panel = SC.util.findListElement(container.childNodes, function (e) { return e._sessionType == sessionType; })
			var listPanel = panel.getElementsByTagName("DIV")[0];

			SC.ui.rebuildContainer(
				listPanel,
				SC.util.filterList(sessionGroupSummaries, function (sgs) { return sgs.st == sessionType; }),
				function (sgs) { return sgs.n; },
				function (sgs) {
					var e = SC.ui.createElement("A", { _commandName: "Select" });
					SC.ui.addElement(e, "DFN");
					SC.ui.addElement(e, "SPAN", { title: sgs.n }, null, sgs.n);
					return e;
				},
				function (e, sgs) { SC.ui.setElementContent(e.firstChild, sgs.sc.toString()); }
			);

			SC.ui.setVisible(panel, preventOuterPanelHide || listPanel.hasChildNodes());
		}

		function updateSuggestion() {
			var suggestionHtml = SC.launch.getLaunchSuggestionHtml();
			SC.ui.ensureCssClass(document.body, "SuggestionActive", suggestionHtml != null);
			SC.ui.get("detailSuggestionTableHeader").innerHTML = suggestionHtml;
		}

		function initializeSessionRow(row) {
			row._commandName = "Select";
			SC.ui.addCommandHandler(row, true);

			SC.ui.addCell(row, { _commandName: "Check" });
			SC.ui.addCell(row, null, "text-align: left;");
			SC.ui.addCell(row, null, "text-align: right;");
		}

		function updateSessionRow(row, session, sessionTime, currentTime) {
			SC.ui.clearElement(row.cells[1]);
			SC.ui.clearElement(row.cells[2]);

			var ageSeconds = (currentTime - sessionTime) / 1000;
			var isGuestClientVersionUpToDate = (session.gcv >= SC.context.constants.productVersion);
			var sessionInfoPanel = SC.ui.addElement(row.cells[1], "DIV", { className: "SessionInfoPanel" });

			var addSessionInfoProc = function (tagName, className, content) {
				SC.ui.addElement(sessionInfoPanel, tagName, { title: content, className: className || "" }, null, content);
			};

			if (!SC.util.isNullOrEmpty(session.clp.i)) {
				addSessionInfoProc("H3", null, session.clp.i);
			}

			SC.util.forEachVisibleCustomProperty(session.st, function (index, propertyName) {
				if (!SC.util.isNullOrEmpty(session.cps[index]))
					addSessionInfoProc("P", null, SC.util.formatString(SC.res["SessionInfoPanel.CustomPropertyLabelFormat"], SC.util.getSessionTypeResource("SessionProperty.{1}.{0}LabelText", session.st, propertyName), session.cps[index]));
			});

			if (!SC.util.isNullOrEmpty(session.h) && session.st != SC.context.types.SessionType.Access)
				addSessionInfoProc("P", null, SC.util.formatString(SC.res["SessionInfoPanel.HostLabelFormat"], session.h));

			if (session.st != SC.context.types.SessionType.Access)
				addSessionInfoProc("P", null, SC.util.formatString(SC.res["SessionInfoPanel.JoinModeLabelFormat"], window.getJoinModeText(session)));

			if (!SC.util.isNullOrEmpty(session.gmn) && SC.util.getBooleanResource("SessionInfoPanel.GuestOperatingSystemVisibleIfPresent"))
				addSessionInfoProc("P", null, SC.util.formatString(SC.res["SessionInfoPanel.GuestOperatingSystemLabelFormat"], session.gos, session.gov));

			if (!SC.util.isNullOrEmpty(session.gcv) && (SC.util.getBooleanResource("SessionInfoPanel.GuestClientVersionVisibleIfPresent") || (!isGuestClientVersionUpToDate && SC.util.getBooleanResource("SessionInfoPanel.GuestClientVersionVisibleIfOutOfDate"))))
				addSessionInfoProc("P", isGuestClientVersionUpToDate ? null : "Failure", SC.util.formatString(SC.res["SessionInfoPanel.GuestClientVersionLabelFormat"], session.gcv));

			if (!SC.util.isNullOrEmpty(session.gun) && SC.util.getBooleanResource("SessionInfoPanel.GuestLoggedOnUserVisibleIfPresent")) {
				var resourceName = "SessionInfoPanel.GuestLoggedOnUserIdleUnknownLabelFormat";

				if (session.git > parseInt(SC.res["SessionInfoPanel.GuestLoggedOnUserIdleThresholdSeconds"]))
					resourceName = "SessionInfoPanel.GuestLoggedOnUserIdleLabelFormat";
				else if (session.git >= 0)
					resourceName = "SessionInfoPanel.GuestLoggedOnUserActiveLabelFormat";

				var content = SC.util.formatString(SC.res[resourceName], session.gud, session.gun, SC.util.formatDuration(session.git, ageSeconds));
				addSessionInfoProc("P", null, content);
			}

			if (!SC.util.isNullOrEmpty(session.n) && SC.util.getBooleanResource("SessionInfoPanel.NotesVisibleIfPresent"))
				addSessionInfoProc("P", null, SC.util.formatString(SC.res["SessionInfoPanel.NotesLabelFormat"], session.n));

			var sessionTypeName = SC.util.getEnumValueName(SC.context.types.SessionType, session.st);
			var statusDiagramPanel = SC.ui.addElement(row.cells[2], "DIV", { className: "StatusDiagramPanel " + sessionTypeName });

			var addProcessTypeContentProc = function (processTypeName, connectedCount, connectedTime, endPointImagePath) {
				var processTypePanel = SC.ui.addElement(statusDiagramPanel, "DIV", { className: processTypeName });
				var description = SC.util.formatDuration(connectedTime, ageSeconds);

				if (connectedCount > 1)
					description = SC.util.formatString("{0} ({1})", description, connectedCount);

				SC.ui.ensureCssClass(processTypePanel, "Connected", connectedCount > 0);

				SC.ui.addElement(processTypePanel, "DIV");
				SC.ui.addElement(processTypePanel, "P", { title: description }, null, description);
			};

			addProcessTypeContentProc("Host", session.hcc, session.hct);
			addProcessTypeContentProc("Guest", session.gcc, session.gct);
		}

		function addEditField(definitionList, sessionPropertyName, selectableOptionString, trySelectedOption, textValue, renderAsRadioButtons, enterCommandName) {
			var selectableOptions = [
				{ value: "K", text: SC.res["SessionPanel.PropertyKeepOption"], showTextBox: false },
				{ value: "M", text: SC.res["SessionPanel.PropertyMachineNameOption"], showTextBox: false },
				{ value: "I", text: SC.res["SessionPanel.PropertyJoinModeInvitationOnlyText"], showTextBox: false },
				{ value: "P", text: SC.res["SessionPanel.PropertyJoinModePublicText"], showTextBox: false },
				{ value: "E", text: SC.res["SessionPanel.PropertyJoinModeSimpleCodeText"], showTextBox: false },
				{ value: "C", text: SC.res["SessionPanel.PropertyJoinModeSecureCodeText"], showTextBox: true },
				{ value: "S", text: SC.res["SessionPanel.PropertySpecifyOption"], showTextBox: true }
			];

			var labelText = SC.res["SessionProperty." + sessionPropertyName + ".LabelText"];
			SC.ui.addElement(definitionList, "DT", null, null, labelText);

			var selectedOption = (SC.util.isNullOrEmpty(selectableOptionString) ? null : (selectableOptionString.indexOf(trySelectedOption) == -1 ? selectableOptionString.charAt(0) : trySelectedOption));
			var definitionElement = SC.ui.addElement(definitionList, "DD", { _sessionPropertyName: sessionPropertyName });

			if (renderAsRadioButtons) {
				SC.util.forEach(selectableOptions, function (so) {
					if (!SC.util.isNullOrEmpty(selectableOptionString) && selectableOptionString.indexOf(so.value) != -1) {
						SC.ui.addRadioButtonPanel(
							definitionElement,
							"P",
							so.text,
							sessionPropertyName,
							so.value,
							so.value == trySelectedOption,
							true,
							so.showTextBox ? SC.ui.createElement("SPAN", null, null, textValue) : null
						);
					}
				});
			} else {
				var selectBox = SC.ui.addElement(definitionElement, "SELECT");

				SC.util.forEach(selectableOptions, function (so) {
					if (!SC.util.isNullOrEmpty(selectableOptionString) && selectableOptionString.indexOf(so.value) != -1) {
						var option = new Option(so.text, so.value);
						option._selectableOption = so;
						selectBox.add(option);

						if (so.value == trySelectedOption)
							selectBox.selectedIndex = selectBox.options.length - 1;
					}
				});

				var textBox = SC.ui.createTextBox(false, null, enterCommandName);

				if (!SC.util.isNullOrEmpty(textValue))
					textBox.value = textValue;

				definitionElement.appendChild(textBox);

				var updateClassesProc = function () {
					SC.ui.ensureCssClass(definitionElement, "TextOnly", selectBox.options.length == 0);
					SC.ui.ensureCssClass(definitionElement, "SelectOnly", selectBox.options.length > 0 && !selectBox.options[selectBox.selectedIndex]._selectableOption.showTextBox);
				};

				selectBox.onchange = function () {
					updateClassesProc();
					textBox.focus();
				};

				updateClassesProc();
			}
		}

		function getEditFieldElement(definitionList, sessionPropertyName, tagName) {
			var definitionElement = SC.ui.findDescendentNode(definitionList, function (e) { return e._sessionPropertyName == sessionPropertyName; });
			return definitionElement.getElementsByTagName(tagName)[0];
		}

		function getEditFieldOptionValue(definitionList, sessionPropertyName) {
			var selectBox = window.getEditFieldElement(definitionList, sessionPropertyName, "SELECT");

			if (selectBox != null)
				return (selectBox.options.length == 0 ? null : selectBox.options[selectBox.selectedIndex].value);

			return SC.ui.getRadioButtonGroupSelectedValue(sessionPropertyName);
		}

		function getEditFieldTextValue(definitionList, sessionPropertyName) {
			var span = window.getEditFieldElement(definitionList, sessionPropertyName, "SPAN");

			if (span)
				return SC.ui.getElementContent(span);

			var textBox = window.getEditFieldElement(definitionList, sessionPropertyName, "INPUT");
			return textBox.value.trim();
		}

		function focusEditField(definitionList, sessionPropertyName) {
			var textBox = window.getEditFieldElement(definitionList, sessionPropertyName, "INPUT");
			textBox.focus();
		}

		function showBuildAccessInstallerDialog() {
			var titlePanel = SC.ui.createModalDialogTitlePanel(SC.res["BuildInstallerPanel.Title"]);
			var mainContentPanel = SC.ui.createModalDialogContentPanel();
			var buttonPanel = SC.ui.createModalDialogButtonPanel();

			SC.ui.addElement(mainContentPanel, "P", null, null, SC.res["BuildInstallerPanel.Paragraph1Message"]);
			SC.ui.addElement(mainContentPanel, "P", null, null, SC.res["BuildInstallerPanel.Paragraph2Message"]);

			var definitionList = SC.ui.addElement(mainContentPanel, "DL");

			window.addEditField(definitionList, "Name", "MS", "M");

			SC.util.forEachVisibleCustomProperty(SC.context.types.SessionType.Access, function (index, propertyName) {
				window.addEditField(definitionList, propertyName);
			});

			SC.ui.addElement(mainContentPanel, "P", null, null, SC.res["BuildInstallerPanel.Paragraph3Message"]);

			var downloadButtonResourceNames = [];

			for (var resourceName in SC.res)
				if (resourceName.indexOf("BuildInstallerPanel.InstallerType.") == 0)
					downloadButtonResourceNames.push(resourceName);

			downloadButtonResourceNames.sort();

			SC.ui.addElement(buttonPanel, "INPUT", { type: "button", _commandName: "Default", value: SC.res["BuildInstallerPanel.DownloadButtonText"] });

			var installerTypeParagraph = SC.ui.addElement(buttonPanel, "P");

			SC.ui.addElement(installerTypeParagraph, "SPAN", null, null, "Type:");
			var installerTypeList = SC.ui.addElement(installerTypeParagraph, "SELECT");

			SC.util.forEach(downloadButtonResourceNames, function (resourceName) {
				var installerType = resourceName.substring(resourceName.length - 3);
				installerTypeList.add(new Option(SC.res[resourceName], installerType));
			});

			SC.ui.showModalDialogRaw("BuildInstaller", [titlePanel, mainContentPanel, buttonPanel], function (command) {
				var name = (window.getEditFieldOptionValue(definitionList, "Name") == "M" ? "" : window.getEditFieldTextValue(definitionList, "Name"));
				var customPropertyValues = SC.util.createArray(SC.context.customPropertyCount, function () { return ""; });

				SC.util.forEachVisibleCustomProperty(SC.context.types.SessionType.Access, function (index, propertyName) {
					customPropertyValues[index] = window.getEditFieldTextValue(definitionList, propertyName);
				});

				SC.service.getInstallerUrl(installerTypeList.options[installerTypeList.selectedIndex].value, name, customPropertyValues, function (url) {
					SC.util.launchDownload(url);
				});

				return true;
			});
		}

		function showCreateSessionDialog(sessionType) {
			var title = SC.util.getSessionTypeResource("CreateSessionPanel.{0}Title", sessionType);
			var buttonText = SC.util.getSessionTypeResource("CreateSessionPanel.{0}ButtonText", sessionType);

			var titlePanel = SC.ui.createModalDialogTitlePanel(title);
			var mainContentPanel = SC.ui.createModalDialogContentPanel();
			var buttonPanel = SC.ui.createModalDialogButtonPanel(buttonText);

			var definitionList = SC.ui.addElement(mainContentPanel, "DL");

			var settings = SC.util.loadSettings();
			var secureCode = SC.util.getRandomStringFromMask(SC.res["SessionPanel.GenerateCodeMask"]);

			window.addEditField(definitionList, "Name", null, null, null, null, "Default");

			SC.util.forEachVisibleCustomProperty(sessionType, function (index, propertyName) {
				window.addEditField(definitionList, propertyName);
			});

			var joinNowParagraph = SC.ui.addElement(buttonPanel, "P");
			var joinNowBox = SC.ui.addElement(joinNowParagraph, "INPUT", { id: "joinNowBox", type: "checkbox", checked: settings.joinNow });
			SC.ui.addElement(joinNowParagraph, "LABEL", { htmlFor: "joinNowBox" }, null, SC.res["CreateSessionPanel.JoinNowText"]);
			SC.ui.setVisible(joinNowParagraph, SC.util.canBrowserAutoDownload());

			var joinModeOptionString = "";
			if (SC.util.getBooleanResource("SessionPanel.PropertyJoinModeInvitationOnlyVisible")) joinModeOptionString += "I";
			if (SC.util.getBooleanResource("SessionPanel.PropertyJoinModePublicVisible")) joinModeOptionString += "P";
			if (SC.util.getBooleanResource("SessionPanel.PropertyJoinModeSimpleCodeVisible")) joinModeOptionString += "E";
			if (SC.util.getBooleanResource("SessionPanel.PropertyJoinModeSecureCodeVisible")) joinModeOptionString += "C";

			window.addEditField(definitionList, "JoinMode", joinModeOptionString, settings.joinMode || "I", secureCode, true);

			SC.ui.showModalDialogRaw("CreateSession", [titlePanel, mainContentPanel, buttonPanel], function (command) {
				var name = window.getEditFieldTextValue(definitionList, "Name");
				var joinModeOptionValue = window.getEditFieldOptionValue(definitionList, "JoinMode");

				var isPublic = (joinModeOptionValue == "P");
				var code = (joinModeOptionValue == "E" ? name : (joinModeOptionValue == "C" ? window.getEditFieldTextValue(definitionList, "JoinMode") : ""));
				var customPropertyValues = SC.util.createArray(SC.context.customPropertyCount, function () { return ""; });

				SC.util.forEachVisibleCustomProperty(sessionType, function (index, propertyName) {
					customPropertyValues[index] = window.getEditFieldTextValue(definitionList, propertyName);
				});

				settings.joinMode = joinModeOptionValue;
				settings.joinNow = joinNowBox.checked;
				SC.util.saveSettings(settings);

				SC.service.createSession(
					sessionType,
					name,
					isPublic,
					code,
					customPropertyValues,
					function (sessionID) {
						window.setSessionUrlPart(sessionID);
						window.setCommandNameUrlPart(joinNowBox.checked ? "Join" : null);
						SC.ui.hideModalDialog();
						window.refresh(true);
					},
					function (error) {
						SC.ui.setModalDialogButtonPanelError(buttonPanel, error);
					}
				);
			});

			window.focusEditField(definitionList, "Name");
		}

		function showEditSessionsDialog(sessionGroupName, sessions) {
			var titlePanel = SC.ui.createModalDialogTitlePanel(SC.res["EditSessionsPanel.Title"]);
			var mainContentPanel = SC.ui.createModalDialogContentPanel();
			var buttonPanel = SC.ui.createModalDialogButtonPanel(SC.res["EditSessionsPanel.ButtonText"]);
			var definitionList = SC.ui.addElement(mainContentPanel, "DL");

			var sessionType = sessions[0].st;
			var areAllNamesEqual = SC.util.areAllEqual(sessions, function (s) { return s.clp.i; });
			var areAllNamesMachineBased = !SC.util.contains(sessions, function (s) { return (s.a & SC.context.types.SessionAttributes.MachineBasedName) == 0; });
			var nameOptionString = "";
			var initialNameOption = null;

			if (!areAllNamesEqual && !areAllNamesMachineBased) {
				nameOptionString += "K";
				initialNameOption = "K";
			}

			if (sessionType == SC.context.types.SessionType.Access)
				nameOptionString += "M";

			if (nameOptionString.length != 0)
				nameOptionString += "S";

			initialNameOption = initialNameOption || (areAllNamesMachineBased ? "M" : "S");

			window.addEditField(definitionList, "Name", nameOptionString, initialNameOption, areAllNamesMachineBased ? null : sessions[0].clp.i);

			SC.util.forEachVisibleCustomProperty(sessionType, function (index, propertyName) {
				var areAllValuesEqual = SC.util.areAllEqual(sessions, function (s) { return s.cps[index]; });
				window.addEditField(definitionList, propertyName, areAllValuesEqual ? null : "KS", null, areAllValuesEqual ? sessions[0].cps[index] : null);
			});

			if (sessionType != SC.context.types.SessionType.Access) {
				var joinModes = SC.util.selectFromList(sessions, function (s) {
					if (s.ip) return "P";
					else if (s.c == s.clp.i) return "E"
					else if (!SC.util.isNullOrEmpty(s.c)) return "C";
					else return "I";
				});

				var joinModeOptionString = "";
				var initialJoinModeOption = null;
				var textValue = null;

				if (!SC.util.areAllEqual(joinModes) || (joinModes.length > 1 && joinModes[0] == "C")) {
					joinModeOptionString += "K";
					initialJoinModeOption = "K";
				}

				if (SC.util.getBooleanResource("SessionPanel.PropertyJoinModeInvitationOnlyVisible")) joinModeOptionString += "I";
				if (SC.util.getBooleanResource("SessionPanel.PropertyJoinModePublicVisible")) joinModeOptionString += "P";
				if (SC.util.getBooleanResource("SessionPanel.PropertyJoinModeSimpleCodeVisible")) joinModeOptionString += "E";

				if (sessions.length == 1 && SC.util.getBooleanResource("SessionPanel.PropertyJoinModeSecureCodeVisible")) {
					joinModeOptionString += "C";
					textValue = (joinModes[0] == "C" ? sessions[0].c : SC.util.getRandomStringFromMask(SC.res["SessionPanel.GenerateCodeMask"]));
				}

				initialJoinModeOption = initialJoinModeOption || joinModes[0];

				window.addEditField(definitionList, "JoinMode", joinModeOptionString, initialJoinModeOption, textValue, true);
			}

			SC.ui.showModalDialogRaw("EditSessions", [titlePanel, mainContentPanel, buttonPanel], function (command) {
				var sessionIDs = SC.util.selectFromList(sessions, function (s) { return s.clp.s; });
				var names = SC.util.selectFromList(sessions, function (s) { return s.clp.i; });
				var isPublics = SC.util.selectFromList(sessions, function (s) { return s.ip; });
				var codes = SC.util.selectFromList(sessions, function (s) { return s.c; });
				var customPropertyValues = SC.util.selectFromList(sessions, function (s) { return s.cps; });

				var nameOptionValue = window.getEditFieldOptionValue(definitionList, "Name");

				if (nameOptionValue != "K") {
					var value = (nameOptionValue == "M" ? "" : window.getEditFieldTextValue(definitionList, "Name"));
					names = SC.util.createArray(sessions.length, function () { return value; });
				}

				SC.util.forEachVisibleCustomProperty(sessionType, function (index, propertyName) {
					if (window.getEditFieldOptionValue(definitionList, propertyName) != "K") {
						var value = window.getEditFieldTextValue(definitionList, propertyName);

						for (var j = 0; j < sessions.length; j++)
							customPropertyValues[j][index] = value
					}
				});

				if (sessionType != SC.context.types.SessionType.Access) {
					var joinModeOptionValue = window.getEditFieldOptionValue(definitionList, "JoinMode");

					if (joinModeOptionValue != "K") {
						isPublics = SC.util.createArray(sessions.length, function () {
							return (joinModeOptionValue == "P");
						});

						codes = SC.util.createArray(sessions.length, function (index) {
							if (joinModeOptionValue == "I" || joinModeOptionValue == "P")
								return "";
							else if (joinModeOptionValue == "E")
								return names[index];
							else if (joinModeOptionValue == "C")
								return window.getEditFieldTextValue(definitionList, "JoinMode");
						});
					}
				}

				SC.service.updateSessions(
					sessionGroupName,
					sessionIDs,
					names,
					isPublics,
					codes,
					customPropertyValues,
					function () { SC.ui.hideModalDialog(); window.refresh(true); },
					function (error) { SC.ui.setModalDialogButtonPanelError(buttonPanel, error); }
				);
			});
		}

		function showManageSessionGroupsDialog() {
			var titlePanel = SC.ui.createModalDialogTitlePanel(SC.res["ManageSessionGroupsPanel.Title"]);
			var mainContentPanel = SC.ui.createModalDialogContentPanel();
			var buttonPanel = SC.ui.createModalDialogButtonPanel(SC.res["ManageSessionGroupsPanel.ButtonText"]);
			var referenceContentPanel = SC.ui.createModalDialogContentPanel();

			SC.ui.addElement(mainContentPanel, "P", null, null, SC.res["ManageSessionGroupsPanel.Message"]);

			var table = SC.ui.addElement(mainContentPanel, "TABLE", { className: "DataTable", cellSpacing: 0 });

			var headerRow = table.insertRow(-1);
			SC.ui.addElement(headerRow, "TH");
			SC.ui.addElement(headerRow, "TH", null, null, SC.res["ManageSessionGroupsPanel.NameHeader"]);
			SC.ui.addElement(headerRow, "TH", null, null, SC.res["ManageSessionGroupsPanel.SessionFilterHeader"]);

			for (var sessionTypeName in SC.context.types.SessionType) {
				var headerText = SC.res[SC.util.formatString("HostPanel.{0}Heading", sessionTypeName)]

				var sectionHeaderRow = table.insertRow(-1);
				SC.ui.addCell(sectionHeaderRow, { colSpan: 3 }, null, headerText);
			}

			var createDataRowProc = function (tableSection, insertIndex, sessionGroup) {
				var row = tableSection.insertRow(insertIndex);
				row._dataItem = sessionGroup;

				var buttonCell = SC.ui.addCell(row);

				SC.ui.addCommandButtons(buttonCell, [
					{ commandName: "MoveUp", text: SC.res["ManageSessionGroupsPanel.MoveUpButtonText"] },
					{ commandName: "MoveDown", text: SC.res["ManageSessionGroupsPanel.MoveDownButtonText"] },
					{ commandName: "Delete", text: SC.res["ManageSessionGroupsPanel.DeleteButtonText"] },
					{ commandName: "New", text: SC.res["ManageSessionGroupsPanel.NewButtonText"] },
				]);

				var nameCell = SC.ui.addCell(row);
				var nameBox = SC.ui.addElement(nameCell, "INPUT", { type: "text", value: row._dataItem.Name });
				nameBox.focus();

				var sessionFilterBox = SC.ui.createElement("INPUT", { type: "text", spellcheck: false, value: row._dataItem.SessionFilter || "", disabled: row._dataItem.IsSystem }, "width: 400px; font-family: monospace;");
				SC.ui.addCell(row, null, null, sessionFilterBox);
			};

			var buttonStateProc = function () {
				SC.util.findListElement(mainContentPanel.getElementsByTagName("TR"), function (row) {
					if (row._dataItem) {
						SC.ui.ensureCssClass(SC.ui.findDescendentNode(row, function (e) { return e._commandName == "MoveUp"; }), "Disabled", !row.previousSibling._dataItem);
						SC.ui.ensureCssClass(SC.ui.findDescendentNode(row, function (e) { return e._commandName == "MoveDown"; }), "Disabled", row.nextSibling && !row.nextSibling._dataItem);
						SC.ui.ensureCssClass(SC.ui.findDescendentNode(row, function (e) { return e._commandName == "Delete"; }), "Disabled", row._dataItem.IsSystem);
					}
				});
			};

			SC.service.getSessionGroups(function (sessionGroups) {
				var insertIndex = 2;

				for (var j in sessionGroups) {
					if (j != 0 && sessionGroups[j].SessionType != sessionGroups[j - 1].SessionType)
						insertIndex += 1;

					createDataRowProc(table, insertIndex++, sessionGroups[j]);
				}

				buttonStateProc();
			});

			SC.ui.addElement(buttonPanel, "A", { _commandName: "ShowReference" }, null, SC.res["ManageSessionGroupsPanel.ShowReferenceButtonText"]);

			SC.ui.setVisible(referenceContentPanel, false);
			SC.ui.setElementContent(referenceContentPanel, SC.res["ManageSessionGroupsPanel.Instructions"], true);

			SC.ui.showModalDialogRaw("ManageSessionGroups", [titlePanel, mainContentPanel, buttonPanel, referenceContentPanel], function (command) {
				var dataElement = SC.ui.findAncestorNode(command.clickedElement, function (e) { return e._dataItem != undefined });

				if (command.commandName == "MoveUp") {
					SC.ui.moveNodeUp(dataElement);
				} else if (command.commandName == "MoveDown") {
					SC.ui.moveNodeDown(dataElement);
				} else if (command.commandName == "Delete") {
					dataElement.parentNode.removeChild(dataElement);
				} else if (command.commandName == "New") {
					var row = SC.ui.findAncestorNode(command.commandElement, function (e) { return e.tagName == "TR"; });
					createDataRowProc(table, row.rowIndex + 1, { Name: "", SessionType: row._dataItem.SessionType });
				} else if (command.commandName == "ShowReference") {
					SC.ui.setVisible(referenceContentPanel, true);
				} else if (command.commandName == "Default") {
					var sessionGroups = new Array();

					for (var i = 0; table.rows[i]; i++) {
						var sessionGroup = table.rows[i]._dataItem;

						if (sessionGroup) {
							var rowInputElements = table.rows[i].getElementsByTagName("INPUT");
							sessionGroup.Name = rowInputElements[0].value.trim();
							sessionGroup.SessionFilter = rowInputElements[1].value.trim();
							sessionGroups.push(sessionGroup);
						}
					}

					SC.service.saveSessionGroups(
						sessionGroups,
						function () { SC.ui.hideModalDialog(); window.refresh(true); },
						function (error) { SC.ui.setModalDialogButtonPanelError(buttonPanel, error); }
					);
				}

				buttonStateProc();
				return true;
			});
		}

		function updateDetailViewPanel() {
			var rowCheckedCount = 0;
			var checkedOrSelectedSessions = [];
			var permissions = null;
			var lastSessionTime = 0;
			var sessionType = (!window._sessionInfo || window._sessionInfo.sgi == -1 ? null : window._sessionInfo.sgs[window._sessionInfo.sgi].st);
			var rows = SC.ui.get("detailTable").rows;

			SC.util.findListElement(rows, function (row) {
				if (row._dataItem) {
					var isChecked = SC.ui.isChecked(row);
					var isSelected = SC.ui.isSelected(row);

					if (isChecked)
						rowCheckedCount++;

					if (isChecked || isSelected) {
						permissions = (permissions == null ? row._dataItem.p : permissions & row._dataItem.p);
						lastSessionTime = Math.max(lastSessionTime, row._userData);
						checkedOrSelectedSessions.push(row._dataItem);
					}
				}
			});

			var detailTableHeader = SC.ui.get("detailTableHeader");
			SC.ui.ensureCssClass(detailTableHeader, "HalfChecked", rowCheckedCount > 0 && rowCheckedCount < rows.length);
			SC.ui.ensureCssClass(detailTableHeader, "Checked", rowCheckedCount > 0 && rowCheckedCount == rows.length);

			var sessionNames = SC.util.selectFromList(checkedOrSelectedSessions, function (s) { return s.clp.i; });
			SC.ui.setElementContent(SC.ui.get("detailTitleHeading"), sessionNames.join(", "));

			var activeSession = (checkedOrSelectedSessions.length == 1 ? checkedOrSelectedSessions[0] : null);
			SC.ui.ensureCssClass(SC.ui.get("detailViewPanel"), "TabsActive", activeSession != null);

			SC.util.forEach([SC.ui.get("detailCommandPanel"), SC.ui.get("detailTabList"), SC.ui.getPopoutPanel()], function (c) {
				if (c != null) {
					SC.ui.updateCommandButtonsState(
						c,
						function (cn, ca) { return window.isCommandVisible(cn, ca, sessionType); },
						function (cn, ca) { return window.isCommandEnabled(cn, ca, checkedOrSelectedSessions, permissions); }
					);
				}
			});

			window.clearInterval(window._refreshTabContentIntervalID);

			if (activeSession != null) {
				var tabElements = SC.ui.get("detailTabList").childNodes;
				var selectedTabElement = SC.util.findListElement(tabElements, function (t) { return SC.ui.getVisible(t) && SC.ui.isSelected(t); });

				if (!selectedTabElement) {
					selectedTabElement = SC.util.findListElement(tabElements, function (t) { return SC.ui.getVisible(t); });
					SC.ui.setSelected(selectedTabElement, true);
				}

				var detailTabContent = SC.ui.get("detailTabContent");
				var selectedTabName = selectedTabElement._commandArgument;

				if (window._currentTabName != selectedTabName || window._currentTabSessionType != activeSession.st) {
					detailTabContent.className = selectedTabName;
					SC.ui.clearElement(detailTabContent);
					window.initializeTabContent(detailTabContent, selectedTabName, sessionType);
					window._currentTabName = selectedTabName;
					window._currentTabSessionType = activeSession.st;
					window._currentTabSessionID = null;
					window._currentTabVersion = null;
				}

				var isLoading = false;

				if (window._currentTabSessionID != activeSession.clp.s || window._currentTabVersion != activeSession.v) {
					var sessionDetailsEntry = SC.util.getCacheEntry(activeSession.clp.s + "SessionDetails", activeSession.v);

					if (sessionDetailsEntry) {
						window._currentTabSessionID = activeSession.clp.s;
						window._currentTabVersion = activeSession.v;

						var sortedEventsEntry = SC.util.getCacheEntry(activeSession.clp.s + "SortedEvents", activeSession.v);

						if (!sortedEventsEntry) {
							var sortedEvents = window.getSortedEvents(sessionDetailsEntry.item);
							sortedEventsEntry = SC.util.setCacheItem(activeSession.clp.s + "SortedEvents", activeSession.v, sortedEvents);
						}

						var refreshTabContentProc = function () {
							var nowTime = SC.util.getMillisecondCount();
							var sessionAgeSeconds = (nowTime - lastSessionTime) / 1000;
							var sessionDetailsAgeSeconds = (nowTime - sessionDetailsEntry.firstUsedTime) / 1000;
							window.refreshTabContent(detailTabContent, selectedTabName, activeSession, sessionDetailsEntry.item, sortedEventsEntry.item, sessionAgeSeconds, sessionDetailsAgeSeconds);
						};

						refreshTabContentProc();

						if (window.doesTabHaveRelativeTimes(selectedTabName))
							window._refreshTabContentIntervalID = window.setInterval(refreshTabContentProc, 60000);
					} else {
						isLoading = (window._currentTabSessionID != activeSession.clp.s);

						if (window._pendingSessionDetailsRequest == undefined || window._pendingSessionDetailsSessionID != activeSession.clp.s || window._pendingSessionDetailsVersion != activeSession.v) {
							window._pendingSessionDetailsSessionID = activeSession.clp.s;
							window._pendingSessionDetailsVersion = activeSession.v;

							if (window._pendingSessionDetailsRequest != undefined)
								window._pendingSessionDetailsRequest.abort();

							window._pendingSessionDetailsRequest = SC.service.getSessionDetails(
								window._sessionInfo.sgs[window._sessionInfo.sgi].n,
								activeSession.clp.s,
								function (sd) {
									window._pendingSessionDetailsRequest = undefined;

									if (sd) {
										SC.util.setCacheItem(activeSession.clp.s + "SessionDetails", activeSession.v, sd);
										window.updateDetailViewPanel();
									} else {
										window.setTimeout(function () { window.updateDetailViewPanel(); }, 1000);
									}
								},
								function (error) {
									window._pendingSessionDetailsRequest = undefined;
									SC.ui.showModalErrorBox(error.detail || error.message);
								}
							);
						}
					}
				}

				SC.ui.ensureCssClass(detailTabContent, "Loading", isLoading);
			}
		}

		function initializeTabContent(container, tabName, sessionType) {
			switch (tabName) {
				case "General":
					var detailDataPanel = SC.ui.addElement(container, "DIV", { id: "detailDataPanel" });

					var addFieldProc = function (descriptionList, propertyName, getSessionValuesFunc, isPopulatedFunc) {
						var labelText = SC.res["SessionProperty." + propertyName + ".LabelText"];
						var valueFormat = SC.res["SessionProperty." + propertyName + ".ValueFormat"];
						SC.ui.addElement(descriptionList, "DT", null, null, labelText);
						SC.ui.addElement(descriptionList, "DD", { _getSessionValuesFunc: getSessionValuesFunc, _valueFormat: valueFormat, _isPopulatedFunc: isPopulatedFunc });
					};

					var formatConnectionsFunc = function (connections, processType) {
						var activeConnections = SC.util.filterList(connections, function (c) {
							return c.pt == processType && !SC.util.contains(c.es, function (e) {
								return e.et == SC.context.types.SessionEventType.Disconnected;
							});
						});

						var activeConnectionParticipantNames = SC.util.selectFromList(activeConnections, function (c) {
							return SC.util.isNullOrEmpty(c.pn) ? SC.res["HostPanel.GuestAnonymousName"] : c.pn;
						});

						return activeConnectionParticipantNames.join(", ");
					};

					var createCustomPropertyGetFunc = function (i) { return function (s) { return s.cps[i]; }; };

					var descriptionList1 = SC.ui.addElement(detailDataPanel, "DL");

					addFieldProc(descriptionList1, "Name", function (s) { return s.clp.i; });

					SC.util.forEachVisibleCustomProperty(sessionType, function (index, propertyName) {
						addFieldProc(descriptionList1, propertyName, createCustomPropertyGetFunc(index));
					});

					if (sessionType != SC.context.types.SessionType.Access) {
						addFieldProc(descriptionList1, "JoinMode", function (s) { return window.getJoinModeText(s); });
						addFieldProc(descriptionList1, "Host", function (s) { return s.h; });
					}

					var descriptionList2 = SC.ui.addElement(detailDataPanel, "DL");
					addFieldProc(descriptionList2, "HostsConnected", function (s, sd, sas) { return [formatConnectionsFunc(sd.cs, SC.context.types.ProcessType.Host), SC.util.formatDuration(s.hct, sas)]; }, function (s) { return s.hcc > 0; });
					addFieldProc(descriptionList2, "GuestsConnected", function (s, sd, sas) { return [formatConnectionsFunc(sd.cs, SC.context.types.ProcessType.Guest), SC.util.formatDuration(s.gct, sas)]; }, function (s) { return s.gcc > 0; });

					if (sessionType != SC.context.types.SessionType.Meeting) {
						var screenshotPanel = SC.ui.addElement(detailDataPanel, "DIV", { id: "screenshotPanel" });
						SC.ui.addElement(screenshotPanel, "DIV");
						SC.ui.addElement(screenshotPanel, "P");
						SC.ui.setVisible(screenshotPanel, false);

						var guestInfoDefinitionList = SC.ui.addElement(detailDataPanel, "DL", { id: "guestInfoDefinitionList" });
						addFieldProc(guestInfoDefinitionList, "LoggedOnUser", function (s) { return SC.util.formatDomainMember(s.gud, s.gun); });
						addFieldProc(guestInfoDefinitionList, "IdleTime", function (s, sd, sas) { return SC.util.formatDuration(s.git, sas); });
						addFieldProc(guestInfoDefinitionList, "Machine", function (s, sd) { return SC.util.formatDomainMember(sd.s.gmd, sd.s.gmn); });
						addFieldProc(guestInfoDefinitionList, "OperatingSystem", function (s) { return [s.gos, s.gov]; }, function (s) { return !SC.util.isNullOrEmpty(s.gos); });
						addFieldProc(guestInfoDefinitionList, "Processor", function (s, sd) { return [sd.s.gpn, sd.s.gpc]; }, function (s, sd) { return !SC.util.isNullOrEmpty(sd.s.gpn); });
						addFieldProc(guestInfoDefinitionList, "SystemMemory", function (s, sd) { return [sd.s.gtm, sd.s.gam]; }, function (s, sd) { return sd.s.gtm > 0; });
						addFieldProc(guestInfoDefinitionList, "NetworkAddress", function (s, sd) { return [sd.s.gna]; });
						addFieldProc(guestInfoDefinitionList, "ClientVersion", function (s) { return [s.gcv]; });
						SC.ui.setVisible(guestInfoDefinitionList, false);
					}

					if (sessionType != SC.context.types.Access) {
						var detailHelpPanel = SC.ui.addElement(container, "DIV", { id: "detailHelpPanel" });
						SC.ui.setVisible(detailHelpPanel, false);
					}

					return true;
				case "Timeline":
					return true;
				case "Messages":
					SC.ui.addEntryHistoryPanel(container, SC.res["Command.SendMessage.PlaceholderText"], SC.res["Command.SendMessage.ButtonText"], "SendMessage", null, function (e) { return e.eventType == SC.context.types.SessionEventType.QueuedMessage || e.eventType == SC.context.types.SessionEventType.SentMessage; }, function (e) { return e.eventType == SC.context.types.SessionEventType.QueuedMessage; }, true);
					return true;
				case "Commands":
					SC.ui.addEntryHistoryPanel(container, SC.res["Command.RunCommand.PlaceholderText"], SC.res["Command.RunCommand.ButtonText"], "RunCommand", null, function (e) { return e.eventType == SC.context.types.SessionEventType.QueuedCommand || e.eventType == SC.context.types.SessionEventType.RanCommand; }, function (e) { return e.eventType == SC.context.types.SessionEventType.QueuedCommand; }, true);
					return true;
				case "Notes":
					SC.ui.addEntryHistoryPanel(container, SC.res["Command.AddNote.PlaceholderText"], SC.res["Command.AddNote.ButtonText"], "AddNote", "RemoveNote", function (e) { return e.eventType == SC.context.types.SessionEventType.AddedNote; }, function (se) { return true; }, true);
					return true;
				default:
					return false;
			}
		}

		function doesTabHaveRelativeTimes(tabName) {
			switch (tabName) {
				case "General":
					return true;
				default:
					return false;
			}
		}

		function refreshTabContent(container, tabName, session, sessionDetails, sortedEvents, sessionAgeSeconds, sessionDetailsAgeSeconds) {
			switch (tabName) {
				case "General":
					var screenshotPanel = SC.ui.get("screenshotPanel");
					var guestInfoDefinitionList = SC.ui.get("guestInfoDefinitionList");
					var detailHelpPanel = SC.ui.get("detailHelpPanel");

					if (screenshotPanel) {
						SC.ui.clearElement(screenshotPanel.childNodes[0]);
						SC.ui.clearElement(screenshotPanel.childNodes[1]);

						if (sessionDetails.s.sct) {
							SC.ui.addElement(screenshotPanel.childNodes[0], "IMG", { src: sessionDetails.s.sct ? SC.ui.createImageDeclaration(sessionDetails.s.sct, sessionDetails.sc) : "" });
						}

						if (sessionDetails.s.gut >= 0) {
							var lastUpdatedDurationText = SC.util.formatDuration(sessionDetails.s.gut, sessionDetailsAgeSeconds);
							var lastUpdatedText = SC.util.formatString(SC.res["SessionProperty.GuestInfoUpdateTime.ValueFormat"], lastUpdatedDurationText);
							SC.ui.addElement(screenshotPanel.childNodes[1], "SPAN", null, null, lastUpdatedText);
						}

						SC.ui.addCommandButtons(screenshotPanel.childNodes[1], [{ commandName: "UpdateGuestInfo" }]);
						SC.ui.setVisible(screenshotPanel, sessionDetails.s.sct);
					}

					if (guestInfoDefinitionList) {
						SC.ui.setVisible(guestInfoDefinitionList, sessionDetails.s.gut >= 0);
					}

					if (detailHelpPanel) {
						var guestInstructionsResourceKey = "SessionHelpPanel.InstructionsGuestInvitationOnlyFormat";

						if (session.ip)
							guestInstructionsResourceKey = "SessionHelpPanel.InstructionsGuestPublicFormat";
						else if (!SC.util.isNullOrEmpty(session.c))
							guestInstructionsResourceKey = "SessionHelpPanel.InstructionsGuestCodeFormat";

						SC.ui.clearElement(detailHelpPanel);
						SC.ui.addElement(detailHelpPanel, "H2", null, null, SC.res["SessionHelpPanel.InstructionsHeading"]);
						SC.ui.addElement(detailHelpPanel, "P", null, null, SC.res["SessionHelpPanel.InstructionsHostFormat"]);

						var phoneticText = SC.util.generatePhoneticText(session.c);
						var guestInstructions = SC.util.formatString(SC.res[guestInstructionsResourceKey], window._hostContext.guestUrl, session.clp.i, session.c, phoneticText);
						var guestInstructionsParagraph = SC.ui.addElement(detailHelpPanel, "P");
						SC.ui.setElementContent(guestInstructionsParagraph, guestInstructions, true);

						SC.ui.setVisible(detailHelpPanel, session.st == SC.context.types.SessionType.Meeting || (session.st == SC.context.types.SessionType.Support && session.gcc == 0));
					}

					SC.ui.findDescendentNode(container, function (e) {
						if (e._getSessionValuesFunc) {
							var valueString = "";

							if (!e._isPopulatedFunc || e._isPopulatedFunc(session, sessionDetails)) {
								var values = e._getSessionValuesFunc(session, sessionDetails, sessionAgeSeconds, sessionDetailsAgeSeconds);
								valueString = (SC.util.isNullOrEmpty(e._valueFormat) ? values.toString() : SC.util.formatString(e._valueFormat, values));
							}

							SC.ui.setElementContent(e, valueString);
						}
					});

					return true;
				case "Timeline":
					SC.ui.clearElement(container);
					window.buildTimeline(container, sessionDetails, sortedEvents);
					SC.ui.scrollToFarRight(container);
					return false;
				case "Messages":
				case "Commands":
				case "Notes":
					var commandName = SC.ui.getEntryHistoryPanelAddCommandName(container.firstChild);
					var entryEnabled = window.isCommandEnabled(commandName, null, [session], session.p);
					SC.ui.setEntryHistoryPanelEntryEnabled(container.firstChild, entryEnabled);
					SC.ui.rebuildEntryHistoryPanel(container.firstChild, sortedEvents);
					return true;
				default:
					return false;
			}
		}

		function isCommandVisible(commandName, commandArgument, sessionType) {
			switch (commandName) {
				case "Transfer":
				case "Invite":
					return sessionType != SC.context.types.SessionType.Access;
				case "Reinstall":
				case "Uninstall":
				case "Wake":
					return sessionType == SC.context.types.SessionType.Access;
				case "RunCommand":
					return sessionType != SC.context.types.SessionType.Meeting;
				case "Select":
					return sessionType != SC.context.types.SessionType.Meeting || commandArgument != "Commands";
				default:
					return true;
			}
		}

		function isCommandEnabled(commandName, commandArgument, sessions, permissions) {
			switch (commandName) {
				case "UpdateGuestInfo":
					return sessions.length == 1 && sessions[0].gcc != 0;
				case "Wake":
				case "SendMessage":
				case "Join":
					return sessions.length > 0 && (permissions & SC.context.types.SessionPermissions.Join) != 0;
				case "RunCommand":
					return sessions.length > 0 && (permissions & SC.context.types.SessionPermissions.RunCommandOutside) != 0;
				case "Edit":
					return sessions.length > 0 && (permissions & SC.context.types.SessionPermissions.Edit) != 0;
				case "End": return sessions.length > 0 && (permissions & SC.context.types.SessionPermissions.End) != 0;
				case "Transfer": return sessions.length > 0 && (permissions & SC.context.types.SessionPermissions.Transfer) != 0;
				case "Invite": return sessions.length == 1;
				case "Reinstall": return sessions.length > 0 && (permissions & SC.context.types.SessionPermissions.Reinstall) != 0;
				case "Uninstall": return sessions.length > 0 && (permissions & SC.context.types.SessionPermissions.Uninstall) != 0;
				case "AddNote": return sessions.length > 0 && (permissions & SC.context.types.SessionPermissions.AddNote) != 0;
				case "RemoveNote": return sessions.length > 0 && (permissions & SC.context.types.SessionPermissions.RemoveNote) != 0;
				case "More": return sessions.length > 0;
				default: return true;
			}
		}

		function shouldCheckSession(session, checkModeType) {
			switch (checkModeType) {
				case "All": return true;
				case "None": return false;
				case "Neither": return session.hcc == 0 && session.gcc == 0;
				case "Both": return session.hcc != 0 && session.gcc != 0;
				case "OnlyHost": return session.hcc != 0 && session.gcc == 0;
				case "OnlyGuest": return session.hcc == 0 && session.gcc != 0;
			}
		}

		function onCommand(command) {
			var dataElement = SC.ui.findAncestorNode(command.commandElement, function (e) { return e._dataItem != undefined });

			if (command.commandName == "Check") {
				if (dataElement != null || command.commandArgument != null) {
					var selectedSessionIDs = [];

					SC.util.forEach(SC.ui.get("detailTable").rows, function (r) {
						var isRowChecked = SC.ui.isChecked(r);

						if (dataElement != null) {
							if (r == dataElement)
								isRowChecked = !isRowChecked;
						} else {
							isRowChecked = window.shouldCheckSession(r._dataItem, command.commandArgument);
						}

						SC.ui.setChecked(r, isRowChecked);
						SC.ui.setSelected(r, isRowChecked);

						if (isRowChecked)
							selectedSessionIDs.push(r._dataItem.clp.s);
					});

					window.setSessionUrlPart(selectedSessionIDs.length == 1 ? selectedSessionIDs[0] : null);
					window.updateDetailViewPanel();
				} else {
					SC.ui.togglePopoutPanel(command.commandElement, function (popoutPanel, closeProc) {
						SC.ui.addElement(popoutPanel, "P", null, null, SC.res["Command.Check.CheckText"]);

						SC.ui.addCommandButtons(popoutPanel, [
							{ commandName: "Check", commandArgument: "All" },
							{ commandName: "Check", commandArgument: "None" }
						]);

						SC.ui.addElement(popoutPanel, "P", null, null, SC.res["Command.Check.WhereText"]);

						SC.ui.addCommandButtons(popoutPanel, [
							{ commandName: "Check", commandArgument: "Neither" },
							{ commandName: "Check", commandArgument: "Both" },
							{ commandName: "Check", commandArgument: "OnlyHost" },
							{ commandName: "Check", commandArgument: "OnlyGuest" }
						]);
					});
				}
			} else if (command.commandName == "Select") {
				if (command.commandArgument) {
					window.selectTab(command.commandArgument);
					window.updateDetailViewPanel();
				} else if (dataElement._dataItem.clp) {
					if (command.isIntense) {
						window.joinSessions([dataElement._dataItem]);
					} else if (command.isAdvanced) {
						if (!SC.ui.isSelected(dataElement)) {
							var isBeforeSelection = (SC.ui.findNextSibling(dataElement, function (e) { return SC.ui.isSelected(e); }) != null);
							var reachedSelection = false;

							for (var e = dataElement; e != null && !reachedSelection; e = (isBeforeSelection ? e.nextSibling : e.previousSibling)) {
								reachedSelection = SC.ui.isSelected(e);
								SC.ui.setChecked(e, true);
								SC.ui.setSelected(e, true);
							}

							window.setSessionUrlPart(null);
							window.updateDetailViewPanel();
						}
					} else if (!command.isContext || !SC.ui.isChecked(dataElement)) {
						window.selectSession(dataElement._dataItem.clp.s);
						window.setSessionUrlPart(dataElement._dataItem.clp.s);
						window.updateDetailViewPanel();
					}
				} else {
					window.selectSessionGroup(dataElement._dataItem.n);
					window.setSessionGroupUrlPart(dataElement._dataItem.n);
					window.setSearchUrlPart(null);
					window.setSessionUrlPart(null);
					window.refresh(true);
				}
			} else if (command.commandName == "More") {
				SC.ui.togglePopoutPanel(command.commandElement, function (popoutPanel) {
					SC.ui.ensureCssClass(popoutPanel, "Overflow", true);
					SC.ui.addCommandButtons(popoutPanel, window._sessionCommandButtons);
					window.updateDetailViewPanel();
				});
			} else if (command.commandName == "CreateSession") {
				if (command.commandArgument == SC.context.types.SessionType.Access)
					window.showBuildAccessInstallerDialog();
				else
					window.showCreateSessionDialog(command.commandArgument);
			} else if (command.commandName == "Manage") {
				window.showManageSessionGroupsDialog();
			} else if (dataElement) { // came from row in table
				window.processSessionCommand(command.commandName, command.commandArgument, command.commandElement, command.isAdvanced, [dataElement._dataItem], null, function () { window.refresh(true); });
			} else { // came from command panel
				var checkedOrSelectedRows = SC.util.filterList(SC.ui.get("detailTable").rows, function (r) { return SC.ui.isChecked(r) || SC.ui.isSelected(r); });
				var checkedOrSelectedSessions = SC.util.selectFromList(checkedOrSelectedRows, function (r) { return r._dataItem; });
				window.processSessionCommand(command.commandName, command.commandArgument, command.commandElement, command.isAdvanced, checkedOrSelectedSessions, null, function () { window.refresh(true); });
			}
		}

		function processSessionCommand(commandName, commandArgument, commandElement, isAdvanced, sessions) {
			var sessionIDs = SC.util.selectFromList(sessions, function (s) { return s.clp.s; });
			var sessionGroupName = window._sessionInfo.sgs[window._sessionInfo.sgi].n;

			if (commandName == "SendMessage") {
				window.addEventToSessions(sessionGroupName, sessionIDs, SC.context.types.SessionEventType.QueuedMessage, commandArgument, commandName, true, false, isAdvanced);
			} else if (commandName == "RunCommand") {
				window.addEventToSessions(sessionGroupName, sessionIDs, SC.context.types.SessionEventType.QueuedCommand, commandArgument, commandName, true, false, isAdvanced);
			} else if (commandName == "AddNote") {
				window.addEventToSessions(sessionGroupName, sessionIDs, SC.context.types.SessionEventType.AddedNote, commandArgument, commandName, true, false, isAdvanced);
			} else if (commandName == "Reinstall") {
				window.addEventToSessions(sessionGroupName, sessionIDs, SC.context.types.SessionEventType.QueuedReinstall, commandArgument, commandName, false, true, isAdvanced);
			} else if (commandName == "Uninstall") {
				window.addEventToSessions(sessionGroupName, sessionIDs, SC.context.types.SessionEventType.QueuedUninstall, commandArgument, commandName, false, true, isAdvanced);
			} else if (commandName == "Wake") {
				window.addEventToSessions(sessionGroupName, sessionIDs, SC.context.types.SessionEventType.QueuedWake, commandArgument, commandName, false, true, isAdvanced);
			} else if (commandName == "End") {
				window.addEventToSessions(sessionGroupName, sessionIDs, SC.context.types.SessionEventType.EndedSession, commandArgument, commandName, false, true, isAdvanced);
			} else if (commandName == "UpdateGuestInfo") {
				window.addEventToSessions(sessionGroupName, sessionIDs, SC.context.types.SessionEventType.QueuedGuestInfoUpdate, commandArgument, commandName, false, false, isAdvanced);
			} else if (commandName == "RemoveNote") {
				SC.service.removeNoteFromSession(sessionGroupName, sessionIDs[0], commandArgument);
			} else if (commandName == "Edit") {
				window.showEditSessionsDialog(sessionGroupName, sessions);
			} else if (commandName == "Join") {
				if (!isAdvanced) {
					window.joinSessions(sessions, 0);
				} else {
					SC.ui.togglePopoutDropDown(
						commandElement,
						SC.res["SessionJoinPanel.LaunchMessage"],
						function (onSuccess) { onSuccess(SC.util.createArray(SC.launch.getLauncherCount(), function (i) { return SC.launch.getLauncher(i).name; })); },
						function (index, text) { window.joinSessions(sessions, index); }
					);
				}
			} else if (commandName == "Transfer") {
				var titleAndButtonText = SC.res["Command.Transfer.ButtonText"];
				var selectBox = SC.ui.createElement("SELECT");

				SC.service.getEligibleHosts(function (hosts) {
					SC.util.forEach(hosts, function (h) {
						selectBox.add(new Option(h));
					});
				});

				SC.ui.showModalButtonDialog(
					"Prompt",
					titleAndButtonText,
					titleAndButtonText,
					"Default",
					function (container) {
						SC.ui.addElement(container, "P", null, null, SC.res["Command.Transfer.Message"]);
						SC.ui.addElement(container, "P", null, null, selectBox);
					},
					function (command) {
						SC.service.transferSessions(
							sessionGroupName,
							sessionIDs,
							selectBox.options[selectBox.selectedIndex].value,
							function () { SC.ui.hideModalDialog(); }
						);
					}
				);
			} else if (commandName == "Invite") {
				SC.ui.showModalButtonDialog(
					"Invite",
					SC.res["InvitePanel.Title"],
					SC.res["InvitePanel.DoneButtonText"],
					"Close",
					function (container) {
						var url = window._hostContext.guestUrl + SC.util.getQueryString({ Session: sessions[0].clp.s });
						var emailSubject = SC.util.formatString(SC.util.getSessionTypeResource("InvitePanel.{0}EmailSubjectFormat", sessions[0].st), window._context.userName, url);
						var emailBody = SC.util.formatString(SC.util.getSessionTypeResource("InvitePanel.{0}EmailBodyFormat", sessions[0].st), window._context.userName, url);

						if (SC.util.getBooleanResource("InvitePanel.SendEmailVisible")) {
							SC.ui.addElement(container, "P", null, null, SC.res["InvitePanel.SendEmailText"]);

							var sendPanel = SC.ui.addElement(container, "DIV");
							var toBox = SC.ui.addElement(sendPanel, "INPUT", { type: "text" }, "width: 200px;");
							SC.ui.addNonBreakingSpace(sendPanel);
							var sendButton = SC.ui.addElement(sendPanel, "INPUT", { type: "button", value: ">" });
							SC.ui.addNonBreakingSpace(sendPanel);
							var sentLabel = SC.ui.addElement(sendPanel, "SPAN", { className: "Success" }, null, SC.res["InvitePanel.EmailSentMessage"]);
							SC.ui.setVisible(sentLabel, false);

							sendButton.onclick = function () {
								SC.ui.setVisible(sentLabel, false);

								var isBodyHtml = SC.res["InvitePanel.EmailBodyIsHtml"] === "true";

								SC.service.sendEmail(toBox.value.trim(), emailSubject, emailBody, isBodyHtml, function () {
									SC.ui.setVisible(sentLabel, true);
								});
							};
						}

						if (SC.util.getBooleanResource("InvitePanel.ComposeEmailVisible")) {
							SC.ui.addElement(container, "P", null, null, SC.res["InvitePanel.ComposeEmailText"]);

							var linkParagraph = SC.ui.addElement(container, "P");
							var clientEmailLink = SC.ui.addElement(linkParagraph, "A", null, null, SC.res["InvitePanel.SendClientEmailLinkText"]);

							clientEmailLink.onclick = function () {
								SC.util.openClientEmail(null, emailSubject, emailBody);
								closeProc();
								return false;
							};
						}

						if (SC.util.getBooleanResource("InvitePanel.CommunicateUrlVisible")) {
							SC.ui.addElement(container, "P", null, null, SC.res["InvitePanel.CommunicateUrlText"]);

							var linkBoxPanel = SC.ui.addElement(container, "DIV");
							var linkBox = SC.ui.addElement(linkBoxPanel, "INPUT", { type: "text", value: url }, "width: 350px;");

							linkBox.onclick = function () { linkBox.select(); };
						}
					}
				);
			}
		}

		function addEventToSessions(sessionGroupName, sessionIDs, eventType, data, commandName, requiresData, requiresConfirmation, isAdvanced) {
			if ((!requiresConfirmation || isAdvanced) && (!requiresData || !SC.util.isNullOrEmpty(data))) {
				SC.service.addEventToSessions(sessionGroupName, sessionIDs, eventType, data);
			} else {
				var buttonAndTitleText = SC.res["Command." + commandName + ".ButtonText"];
				var textBox = SC.ui.createTextBox(true, null, "Default", SC.res["Command." + commandName + ".PlaceholderText"]);

				SC.ui.showModalButtonDialog("Prompt", buttonAndTitleText, buttonAndTitleText, "Default",
					function (container) {
						SC.ui.addElement(container, "P", null, null, SC.res["Command." + commandName + ".Message"]);

						if (requiresData)
							SC.ui.addElement(container, "P", null, null, textBox);
					},
					function (command) {
						var data = textBox.value.trim();

						if (!requiresData || !SC.util.isNullOrEmpty(data)) {
							SC.service.addEventToSessions(
								sessionGroupName,
								sessionIDs,
								eventType,
								data,
								function () { SC.ui.hideModalDialog(); }
							);
						} else {
							textBox.focus();
						}
					}
				);

				if (requiresData)
					textBox.focus();
			}
		}

		function joinSessions(sessions, launcherIndex) {
			var launcher = SC.launch.getLauncher(launcherIndex);

			SC.util.forEach(sessions, function (session) {
				var clp = SC.util.getCombinedClientLaunchParameters(SC.context.clp, session.clp, session.st, SC.context.types.ProcessType.Host, null);
				launcher.launch(clp);
			});
		}

		function buildTimeline(container, sessionDetails, sortedEvents) {
			// this stuff will get externalized once the feature becomes stable
			var topPadding = 10;
			var leftPadding = 20;
			var rightPadding = 20;
			var bottomPadding = 90;
			var minTimelineWidth = 500;
			var minTimelineHeight = 200;
			var minGap = 35;
			var resolutionMillis = 1000;
			var eventDotRadius = 12;
			var connectionLineThickness = 11;
			var connectionTextFormat = "{1}, {5}";
			var connectionTitleFormat = "Process Type: {0}\nParticipant Name: {1}\nNetwork Address: {2}\nClient Type: {3}\nClient Version: {4}\nDuration: {5}";
			var connectionEventTitleFormat = "Event Type: {0}\nData: {1}";
			var connectionGuestFill = "#cdf";
			var connectionHostFill = "#dcf";
			var eventTitleFormat = "Event Type: {0}\nHost: {1}\nData: {2}";
			var eventFill = "#F99";
			var stroke = "#444";
			var strokeWidth = 1;
			var timeDivisionStrokeColor = "#EEE";
			var timeDivisionTextColor = "#BBB";
			var timeDivisionTextLineOffset = -5;
			var timeDifferenceDivisorPreLog = 150000;
			var timeDifferentMultiplierPostLog = 100;
			var connectionLineCount = 9;
			var connectionTextAboveLineOffset = -16;
			var positionStepY = 10;
			var spanTime = 2592000000; // 30 days

			var getEventTime = function (event) { return Math.round(event.time.getTime() / resolutionMillis) * resolutionMillis; };
			var eventDataMap = {};
			var uniqueTimeDatas = [];
			var positionedPanelBoundingBoxes = [];
			var maxPositionedPanelX = Number.MIN_VALUE;
			var maxPositionedPanelY = Number.MIN_VALUE;
			var currentEventTime = Number.MIN_VALUE;
			var currentEventPosition = Number.MIN_VALUE;
			var firstEventIndex = 0;

			if (sortedEvents.length != 0) {
				var firstEventTime = new Date();
				firstEventTime.setTime(sortedEvents[sortedEvents.length - 1].time.getTime() - spanTime);

				var lowIndex = 0;
				var highIndex = sortedEvents.length - 1;

				while (lowIndex < highIndex) {
					firstEventIndex = Math.floor((lowIndex + highIndex) / 2);

					if (firstEventIndex == 0)
						break;
					else if (sortedEvents[firstEventIndex].time < firstEventTime)
						lowIndex = firstEventIndex;
					else if (sortedEvents[firstEventIndex - 1].time < firstEventTime)
						break;
					else
						highIndex = firstEventIndex;
				}
			}

			for (var i = firstEventIndex; sortedEvents[i]; i++) {
				var eventTime = getEventTime(sortedEvents[i]);

				if (eventTime != currentEventTime) {
					if (currentEventPosition == Number.MIN_VALUE)
						currentEventPosition = leftPadding;
					else
						currentEventPosition = currentEventPosition + Math.max(minGap, Math.log((eventTime - currentEventTime) / timeDifferenceDivisorPreLog) * timeDifferentMultiplierPostLog);

					uniqueTimeDatas.push({ t: eventTime, p: currentEventPosition });
				}

				currentEventTime = eventTime;
				eventDataMap[sortedEvents[i].eventID] = { t: currentEventTime, p: currentEventPosition };
			}

			var timelineDiagram = SC.ui.addSvgElement(container, "svg");
			var timeDivisionContainer = SC.ui.addSvgElement(timelineDiagram, "g");
			var positionedPanelContainer = SC.ui.addSvgElement(timelineDiagram, "g");

			var positionPanelProc = function (panel, widthForMax) {
				var originalBoundingBox = panel.getBBox();
				var newBoundingBox = { x: originalBoundingBox.x, y: topPadding, width: originalBoundingBox.width, height: originalBoundingBox.height };
				var i = 0;

				while (positionedPanelBoundingBoxes[i]) {
					if (SC.ui.areSvgRectsIntersecting(newBoundingBox, positionedPanelBoundingBoxes[i])) {
						newBoundingBox.y += positionStepY;
						i = 0;
					} else {
						i++;
					}
				}

				maxPositionedPanelX = Math.max(maxPositionedPanelX, newBoundingBox.x + (widthForMax || newBoundingBox.width));
				maxPositionedPanelY = Math.max(maxPositionedPanelY, newBoundingBox.y + newBoundingBox.height);

				SC.ui.setSvgTransform(panel, 0, newBoundingBox.y - originalBoundingBox.y, 0);
				positionedPanelBoundingBoxes.push(newBoundingBox);

				// debugging:
				//SC.ui.addSvgElement(timelineDiagram, "rect", { x: newBoundingBox.x, y: newBoundingBox.y, width: newBoundingBox.width, height: newBoundingBox.height, stroke: stroke, fill: "transparent" });
			};

			for (var i = 0; sessionDetails.cs[i]; i++) {
				if (sessionDetails.cs[i].es.length > 0) {
					var connectionPanel = null;
					var linePanel = null;
					var currentPosition = 0;
					var positionIndex = 0;
					var minPosition = Number.MAX_VALUE;
					var maxPosition = Number.MIN_VALUE;
					var minTime = Number.MAX_VALUE;
					var maxTime = Number.MIN_VALUE;
					var fill = (sessionDetails.cs[i].pt == SC.context.types.ProcessType.Guest ? connectionGuestFill : connectionHostFill);
					var hasDisconnectedEvent = false;

					SC.util.forEach(sessionDetails.cs[i].es, function (e) {
						var eventData = eventDataMap[e.id];

						if (eventData) {
							if (eventData.p != currentPosition) {
								minPosition = Math.min(minPosition, eventData.p);
								maxPosition = Math.max(maxPosition, eventData.p);
								minTime = Math.min(minTime, eventData.t);
								maxTime = Math.max(maxTime, eventData.t);
								currentPosition = eventData.p;
								positionIndex = 0;
							} else {
								positionIndex++;
							}

							var connectionEventFormatArguments = [
								SC.util.getEnumValueName(SC.context.types.SessionEventType, e.et),
								e.d
							];

							if (connectionPanel == null) {
								connectionPanel = SC.ui.addSvgElement(positionedPanelContainer, "g")
								linePanel = SC.ui.addSvgElement(connectionPanel, "g")
							}

							var connectionEventTitle = SC.util.formatString(connectionEventTitleFormat, connectionEventFormatArguments);
							SC.ui.addSvgElement(connectionPanel, "circle", { cx: eventData.p, cy: positionIndex * eventDotRadius * 2, r: eventDotRadius, fill: fill, stroke: stroke }, null, null, connectionEventTitle);

							hasDisconnectedEvent = (hasDisconnectedEvent || e.et == SC.context.types.SessionEventType.Disconnected);
						}
					});

					var widthForMax = 0;

					if (connectionPanel != null && !hasDisconnectedEvent) {
						widthForMax = connectionPanel.getBBox().width;
						maxPosition = 1000000;
					}

					if (minPosition != Number.MAX_VALUE) {
						var connectionFormatArguments = [
							SC.util.getEnumValueName(SC.context.types.ProcessType, sessionDetails.cs[i].pt),
							SC.util.isNullOrEmpty(sessionDetails.cs[i].pn) ? SC.res["HostPanel.GuestAnonymousName"] : sessionDetails.cs[i].pn,
							sessionDetails.cs[i].na,
							SC.util.getEnumValueName(SC.context.types.ClientType, sessionDetails.cs[i].ct),
							sessionDetails.cs[i].cv,
							SC.util.formatDuration((maxTime - minTime) / 1000)
						];

						var connectionTitle = SC.util.formatString(connectionTitleFormat, connectionFormatArguments);
						SC.ui.setSvgTitle(connectionPanel, connectionTitle);

						var connectionText = SC.util.formatString(connectionTextFormat, connectionFormatArguments);
						SC.ui.addSvgElement(connectionPanel, "text", { x: minPosition, y: connectionTextAboveLineOffset }, null, connectionText);
					}

					if (maxPosition > minPosition)
						SC.ui.addSvgElement(linePanel, "rect", { x: minPosition, y: -connectionLineThickness / 2, width: maxPosition - minPosition, height: connectionLineThickness, fill: fill, stroke: stroke });

					if (connectionPanel != null)
						positionPanelProc(connectionPanel, widthForMax);
				}
			}

			SC.util.forEach(sessionDetails.es, function (e) {
				var eventData = eventDataMap[e.id];

				if (eventData) {
					var eventPanel = SC.ui.addSvgElement(positionedPanelContainer, "g");

					var eventFormatArguments = [
						SC.util.getEnumValueName(SC.context.types.SessionEventType, e.et),
						e.h,
						e.d
					];

					var title = SC.util.formatString(eventTitleFormat, eventFormatArguments);
					SC.ui.addSvgElement(eventPanel, "circle", { cx: eventData.p, cy: 0, r: eventDotRadius, fill: eventFill, stroke: stroke }, null, null, title);

					positionPanelProc(eventPanel);
				}
			});

			var timelineWidth = Math.max(minTimelineWidth, maxPositionedPanelX + rightPadding);
			var timelineHeight = Math.max(minTimelineHeight, maxPositionedPanelY + bottomPadding);
			SC.ui.setSvgAttributes(timelineDiagram, { width: timelineWidth, height: timelineHeight });

			SC.ui.setSvgTransform(timeDivisionContainer, 0, timelineHeight, -90);

			SC.util.forEach(uniqueTimeDatas, function (td) {
				var labelText = SC.util.formatDateTime(new Date(td.t));
				SC.ui.addSvgElement(timeDivisionContainer, "line", { x1: 0, x2: timelineHeight, y1: td.p, y2: td.p, stroke: timeDivisionStrokeColor });
				SC.ui.addSvgElement(timeDivisionContainer, "text", { x: 0, y: td.p + timeDivisionTextLineOffset, fill: timeDivisionTextColor }, null, labelText);
			});
		}

		function getJoinModeText(session) {
			var joinModeTextResourceKey = (session.ip ? "SessionProperty.JoinMode.PublishedFormat" : (!SC.util.isNullOrEmpty(session.c) ? "SessionProperty.JoinMode.CodeFormat" : "SessionProperty.JoinMode.InvitationOnlyFormat"));
			return SC.util.formatString(SC.res[joinModeTextResourceKey], session.clp.i, session.c);
		}

		function selectSessionGroup(sessionGroupName, shouldScrollIntoView) {
			SC.util.findListElement(SC.ui.get("masterSelectionPanel").getElementsByTagName("A"), function (e) {
				var isSelected = e._dataItem && e._dataItem.n == sessionGroupName

				if (SC.ui.setSelected(e, isSelected) && isSelected && shouldScrollIntoView)
					e.scrollIntoView(false);
			});
		}

		function selectSession(sessionID, shouldScrollIntoView) {
			var session = null;

			SC.util.forEach(SC.ui.get("detailTable").rows, function (r) {
				var isSessionRow = (r._dataItem.clp.s == sessionID);

				if (isSessionRow)
					session = r._dataItem;

				if (!isSessionRow)
					SC.ui.setChecked(r, false);

				if (SC.ui.setSelected(r, isSessionRow) && isSessionRow && shouldScrollIntoView)
					r.scrollIntoView(false);
			});

			return session;
		}

		function selectTab(tabName) {
			SC.util.forEach(SC.ui.get("detailTabList").childNodes, function (dt) {
				SC.ui.setSelected(dt, dt._commandArgument == tabName);
			});
		}

		function getSortedEvents(sessionDetails) {
			var allEvents = [];

			for (var i = 0; sessionDetails.cs[i]; i++)
				for (var j = 0; sessionDetails.cs[i].es[j]; j++)
					allEvents.push({ eventID: sessionDetails.cs[i].es[j].id, eventType: sessionDetails.cs[i].es[j].et, time: sessionDetails.cs[i].es[j].t, data: sessionDetails.cs[i].es[j].d, who: sessionDetails.cs[i].pn });

			for (var i = 0; sessionDetails.es[i]; i++)
				allEvents.push({ eventID: sessionDetails.es[i].id, eventType: sessionDetails.es[i].et, time: sessionDetails.es[i].t, data: sessionDetails.es[i].d, who: sessionDetails.es[i].h });

			allEvents.sort(function (e1, e2) { return e1.time - e2.time; });
			return allEvents;
		}

		function onSearchBoxSearch(event) {
			var eventArgs = SC.ui.getEventArgs(event);
			var element = SC.ui.getElement(eventArgs);
			window.setSearchUrlPart(element.value);
			window.refresh(true);
			return true;
		}

		function getSessionGroupUrlPart() { return SC.util.getHashParameter(0); }
		function getSearchUrlPart() { return SC.util.getHashParameter(1); }
		function getSessionUrlPart() { return SC.util.getHashParameter(2); }
		function getCommandNameUrlPart() { return SC.util.getHashParameter(3); }
		function getCommandArgumentUrlPart() { return SC.util.getHashParameter(4); }

		function setSessionGroupUrlPart(sessionGroupName) { window._ignoreNextHashChange |= SC.util.setHashParameter(0, sessionGroupName); }
		function setSearchUrlPart(searchText) { window._ignoreNextHashChange |= SC.util.setHashParameter(1, searchText); }
		function setSessionUrlPart(sessionID) { window._ignoreNextHashChange |= SC.util.setHashParameter(2, sessionID); }
		function setCommandNameUrlPart(commandName) { window._ignoreNextHashChange |= SC.util.setHashParameter(3, commandName); }
		function setCommandArgumentUrlPart(commandName) { window._ignoreNextHashChange |= SC.util.setHashParameter(4, commandName); }

		function updateHashBasedElements() {
			window.selectSessionGroup(window.getSessionGroupUrlPart(), true);
			SC.ui.get("searchBox").value = window.getSearchUrlPart() || "";
			window.selectSession(window.getSessionUrlPart(), true);
		}

		function onHashChange() {
			if (!window._ignoreNextHashChange) {
				window.updateHashBasedElements();
				window.refresh(true);
			}

			window._ignoreNextHashChange = false;
		}

	</script>
</asp:Content>
<asp:Content runat="server" ContentPlaceHolderID="RunScriptBeforeRender">
	<script type="text/javascript">
		var masterSelectionPanel = SC.ui.get("masterSelectionPanel");
		window.addSessionGroupTypePanel(masterSelectionPanel, SC.context.types.SessionType.Support, window._hostContext.userPermissions.createSupportSession);
		window.addSessionGroupTypePanel(masterSelectionPanel, SC.context.types.SessionType.Meeting, window._hostContext.userPermissions.createMeetingSession);
		window.addSessionGroupTypePanel(masterSelectionPanel, SC.context.types.SessionType.Access, window._hostContext.userPermissions.buildAccessInstaller);

		var masterPanel = SC.ui.get("masterPanel");
		SC.ui.ensureCssClass(masterPanel, "Loading", true);
		SC.ui.ensureCssClass(masterPanel, "HideManageSessionGroups", !window._hostContext.userPermissions.manageSessionGroups);

		SC.ui.addCommandButtons(SC.ui.get("manageSessionGroupsPanel"), [
			{ commandName: "Manage", text: SC.res["HostPanel.ManageSessionGroupsText"] }
		]);

		var detailTableHeader = SC.ui.get("detailTableHeader");
		SC.ui.addElement(detailTableHeader, "A", { _commandName: "Check" });

		var searchBox = SC.ui.addElement(detailTableHeader, "INPUT", { id: "searchBox", incremental: true, placeholder: SC.res["HostPanel.SearchBoxPlaceholderText"] });
		try { searchBox.setAttribute("type", "search"); } catch (ex) { }
		SC.ui.addSearchHandler(searchBox, window.onSearchBoxSearch);

		window._sessionCommandButtons = [
			{ commandName: "Join", className: "NeverOverflow" },
			{ commandName: "End", className: "SometimesOverflow" },
			{ commandName: "Edit", className: "NeverOverflow" },
			{ commandName: "Invite", className: "SometimesOverflow" },
			{ commandName: "More", className: "Overflow" },
			{ commandName: "Transfer", className: "AlwaysOverflow" },
			{ commandName: "Reinstall", className: "AlwaysOverflow" },
			{ commandName: "Uninstall", className: "AlwaysOverflow" },
			{ commandName: "Wake", className: "AlwaysOverflow" },
			{ commandName: "SendMessage", className: "AlwaysOverflow" },
			{ commandName: "RunCommand", className: "AlwaysOverflow" },
			{ commandName: "AddNote", className: "AlwaysOverflow" }
		];

		SC.ui.addCommandButtons(SC.ui.get("detailCommandPanel"), window._sessionCommandButtons);

		SC.ui.addCommandButtons(SC.ui.get("detailTabList"), [
			{ commandName: "Select", commandArgument: "General" },
			{ commandName: "Select", commandArgument: "Timeline" },
			{ commandName: "Select", commandArgument: "Messages" },
			{ commandName: "Select", commandArgument: "Commands" },
			{ commandName: "Select", commandArgument: "Notes" }
		]);

		SC.ui.addHandler(SC.ui.get("detailTable"), "contextmenu", function (event) {
			var eventArgs = SC.ui.getEventArgs(event);

			SC.ui.togglePopoutPanel({ x: eventArgs.clientX, y: eventArgs.clientY }, function (popoutPanel, closeProc) {
				SC.ui.addCommandButtons(popoutPanel, window._sessionCommandButtons);
				window.updateDetailViewPanel();
			});

			SC.ui.preventEventDefault(eventArgs);
		});

		window.document.documentElement._oncommand = window.onCommand;
		window.onhashchange = window.onHashChange;
		window.updateDetailViewPanel();
		window.updateHashBasedElements();
		window.updateSuggestion();
		window.refresh(true);
	</script>
</asp:Content>
