﻿<%@ Control Language="C#" %>
<%@ Implements Interface="Elsinore.ScreenConnect.IDataControl" %>
<script runat="server">
	
	protected override void LoadViewState(object savedState)
	{
		var state = (Pair)savedState;
		base.LoadViewState(state.First);
		this.licenseList.DataSource = state.Second;
	}

	protected override object SaveViewState()
	{
		var state = new Pair();
		state.First = base.SaveViewState();
		state.Second = this.licenseList.DataSource;
		return state;
	}

	public void Refresh()
	{
		var licenseManager = new LicenseManager();
		licenseManager.LoadLicensesFromDefaultPath();
		this.RefreshUpgradeLink(licenseManager.LicenseRuntimes);
		this.licenseList.DataSource = licenseManager.LicenseRuntimes.ToArray();

		this.multiView.ActiveViewIndex = (licenseManager.LicenseRuntimes.Any() ? 0 : 1);
	}

	public void Save()
	{
		var licenseRuntimes = (LicenseRuntime[])this.licenseList.DataSource;
		var licenseEnvelopes = licenseRuntimes.Select(lr => lr.LicenseEnvelope);
		var licenseManager = new LicenseManager();
		licenseManager.AddLicenseEnvelopes(licenseEnvelopes);
		licenseManager.SaveLicensesToDefaultPath();

		WebExtensions.RegisterUpdatePanelStartupScript(this, "SC.ui.clearChangesMade();");
	}

	public bool IsSaveAllowed { get { return true; } }

	protected override void OnLoad(EventArgs e)
	{
		base.OnLoad(e);
		this.licenseList.DataBind();
	}

	protected override void OnPreRender(EventArgs e)
	{
		base.OnPreRender(e);
		this.licenseList.DataBind();
		this.cancelButton.Visible = (this.licenseList.Rows.Count != 0);
	}

	void RefreshUpgradeLink(IEnumerable<LicenseRuntime> licenseRuntimes)
	{
		var parameters = new NameValueCollection();
		parameters["InstanceCode"] = ((uint)ServerExtensions.GetInstanceHashCode()).ToString();
		parameters["License"] = licenseRuntimes.Select(lr => Envelope<License>.ToUserString(lr.LicenseEnvelope)).Join(Environment.NewLine + Environment.NewLine);
		this.upgradeLink.NavigateUrl = Elsinore.ScreenConnect.Extensions.EncodeUrl(ServerConstants.UpgradeUrl, parameters);
	}

	void ModifyLicenseEnvelopes(System.Func<IEnumerable<LicenseEnvelope>, IEnumerable<LicenseEnvelope>> modifyProc)
	{
		var licenseRuntimes = (LicenseRuntime[])this.licenseList.DataSource;
		var licenseEnvelopes = modifyProc(licenseRuntimes.Select(lr => lr.LicenseEnvelope));

		var licenseManager = new LicenseManager();
		licenseManager.AddLicenseEnvelopes(licenseEnvelopes);
		this.RefreshUpgradeLink(licenseManager.LicenseRuntimes);
		this.licenseList.DataSource = licenseManager.LicenseRuntimes.ToArray();
	}

	void OnCancelButtonClick(object sender, EventArgs e)
	{
		this.licenseBox.Text = null;
		this.multiView.ActiveViewIndex = 0;
	}

	void OnEnterLicenseButtonClick(object sender, EventArgs e)
	{
		this.multiView.ActiveViewIndex = 1;
		WebExtensions.RegisterUpdatePanelStartupScript(this, "SC.ui.setChangesMade();");
	}

	void OnLicenseListRowDeleting(object sender, GridViewDeleteEventArgs e)
	{
		this.ModifyLicenseEnvelopes(les => les.Where((lr, i) => i != e.RowIndex));

		if (!((LicenseRuntime[])this.licenseList.DataSource).Any())
			this.multiView.ActiveViewIndex = 1;

		WebExtensions.RegisterUpdatePanelStartupScript(this, "SC.ui.setChangesMade();");
	}

	void OnLicenseListRowDataBound(object sender, GridViewRowEventArgs e)
	{
		if (e.Row.RowType == DataControlRowType.DataRow)
			e.Row.Cells[2].ForeColor = (((LicenseRuntime)e.Row.DataItem).ValidationErrorMessage == null ? Color.DarkGreen : Color.DarkRed);
	}

	void OnValidLicenseValidatorServerValidate(object sender, ServerValidateEventArgs e)
	{
		e.IsValid = ((LicenseRuntime[])this.licenseList.DataSource).Any(lr => lr.ValidationErrorMessage == null);
	}

	void OnCheckLicenseValidatorServerValidate(object sender, ServerValidateEventArgs e)
	{
		// not real happy to be doing work in this method, but it's what works
		var licenseEnvelope = default(LicenseEnvelope);

		if (!string.IsNullOrEmpty(this.licenseBox.Text))
		{
			try
			{
				licenseEnvelope = Envelope<License>.FromUserString<LicenseEnvelope>(this.licenseBox.Text);
				this.licenseBox.Text = null;
			}
			catch (Exception ex)
			{
				TypeTrace<Exception>.TraceException(ex);
			}
		}

		if (licenseEnvelope != null)
		{
			this.ModifyLicenseEnvelopes(les => les.Concat(licenseEnvelope.ToSingleElementArray()));
			this.multiView.ActiveViewIndex = 0;
			this.validateLicenseValidator.Validate();
		}
		else
		{
			e.IsValid = false;
		}
	}

</script>
<asp:MultiView runat="server" ID="multiView">
	<asp:View runat="server">
		<p runat="server" innerhtml="<%$ Resources:Default, LicensePanel.CurrentLicenseText %>" />
		<asp:GridView runat="server" ID="licenseList" CssClass="DataTable" AutoGenerateColumns="false" EnableViewState="false" OnRowDeleting="OnLicenseListRowDeleting" OnRowDataBound="OnLicenseListRowDataBound">
			<Columns>
				<asp:ButtonField CommandName="Delete" Text="<%$ Resources:Default, LicensePanel.DeleteButtonText %>" />
				<asp:BoundField HeaderText="<%$ Resources:Default, LicensePanel.LicenseHeaderText %>" DataField="LicenseEnvelope" />
				<asp:BoundField HeaderText="<%$ Resources:Default, LicensePanel.ValidationStatusHeaderText %>" DataField="ValidationErrorMessage" NullDisplayText="<%$ Resources:Default, LicensePanel.ValidationStatusNullDisplayText %>" />
			</Columns>
		</asp:GridView>
		<p>
			<asp:LinkButton runat="server" ID="enterLicenseButton" Text="<%$ Resources:Default, LicensePanel.EnterAnotherLicenseButtonText %>" OnClick="OnEnterLicenseButtonClick" CausesValidation="true" />
			|		
			<asp:HyperLink runat="server" ID="upgradeLink" Target="_blank" Text="<%$ Resources:Default, LicensePanel.UpgradeLicenseButtonText %>" />
			<asp:CustomValidator runat="server" ID="validateLicenseValidator" Display="Dynamic" ErrorMessage="<%$ Resources:Default, LicensePanel.NoValidLicensesErrorMessage %>" OnServerValidate="OnValidLicenseValidatorServerValidate" />
		</p>
	</asp:View>
	<asp:View runat="server">
		<p runat="server" innerhtml="<%$ Resources:Default, LicensePanel.AddLicenseText %>" />
		<p>
			<asp:TextBox runat="server" ID="licenseBox" CssClass="LicenseTextBox" TextMode="MultiLine" Wrap="false" />
		</p>
		<p>
			<asp:LinkButton runat="server" ID="checkLicenseButton" Text="<%$ Resources:Default, LicensePanel.CheckLicenseButtonText %>" />
			<asp:LinkButton runat="server" ID="cancelButton" Text="<%$ Resources:Default, LicensePanel.CancelButtonText %>" OnClick="OnCancelButtonClick" CausesValidation="false" />
			<asp:CustomValidator runat="server" Display="Dynamic" ErrorMessage="<%$ Resources:Default, LicensePanel.InvalidLicenseErrorMessage %>" OnServerValidate="OnCheckLicenseValidatorServerValidate" />
		</p>
	</asp:View>
</asp:MultiView>
