﻿<%@ Page Language="C#" MasterPageFile="~/Default.master" %>

<script runat="server">
	
	protected override void OnInit(EventArgs e)
	{
		base.OnInit(e);

		if (!this.IsPostBack)
		{
			this.multiView.ActiveViewIndex = 0;

			if (Elsinore.ScreenConnect.WebConfigurationManager.AuthenticationMode == AuthenticationMode.Windows)
			{
				if (this.User.Identity.IsAuthenticated)
				{
					this.RedirectToReturnUrl();
				}
				else
				{
					this.Response.StatusCode = (int)HttpStatusCode.Unauthorized;
					this.Response.End();
				}
			}
			else if (Elsinore.ScreenConnect.WebConfigurationManager.AuthenticationMode == AuthenticationMode.Forms)
			{
				FormsAuthentication.SignOut();
				this.Context.User = new System.Security.Principal.GenericPrincipal(new System.Security.Principal.GenericIdentity(string.Empty), new string[0]);
			}
		}
	}

	protected override void OnPreRender(EventArgs e)
	{
		base.OnPreRender(e);

		if (!this.IsPostBack)
			this.SetFocus(this.loginPanel.FindControl("UserName"));
	}

	void OnLoginPanelLoggedIn(object sender, EventArgs e)
	{
		this.RedirectToReturnUrl();
	}

	void OnLoginPanelAuthenticate(object sender, AuthenticateEventArgs e)
	{
		var isUserValid = Membership.ValidateUser(this.loginPanel.UserName, this.loginPanel.Password);
		var oneTimePasswordUserKey = default(string);
		var oneTimePasswordAuthenticationProvider = default(OneTimePasswordAuthenticationProvider);

		if (isUserValid)
		{
			this.GetOneTimePasswordAuthenticationInfo(ref oneTimePasswordUserKey, ref oneTimePasswordAuthenticationProvider);

			if (oneTimePasswordUserKey == null)
			{
				this.OnLoginSuccess();
			}
			else
			{
				this.ViewState["Password"] = this.loginPanel.Password;
				this.multiView.ActiveViewIndex = 1;
				this.oneTimePasswordBox.Focus();

				try
				{
					oneTimePasswordAuthenticationProvider.PrepareOneTimePassword(this.loginPanel.UserName, oneTimePasswordUserKey, Resources.Default.ResourceManager);
				}
				catch
				{
					this.oneTimePasswordInvalidLabel.Visible = true;
				}
			}
		}
	}

	void OnOneTimePasswordLoginClick(object sender, EventArgs e)
	{
		var oneTimePasswordUserKey = default(string);
		var oneTimePasswordAuthenticationProvider = default(OneTimePasswordAuthenticationProvider);
		this.GetOneTimePasswordAuthenticationInfo(ref oneTimePasswordUserKey, ref oneTimePasswordAuthenticationProvider);

		try
		{
			if (!Membership.ValidateUser(this.loginPanel.UserName, this.ViewState["Password"] as string))
				throw new System.Security.SecurityException("Original password invalid");

			if (!oneTimePasswordAuthenticationProvider.ValidateOneTimePassword(this.loginPanel.UserName, oneTimePasswordUserKey, this.oneTimePasswordBox.Text.Trim()))
				throw new System.Security.SecurityException("One-time password invalid");

			this.OnLoginSuccess();
		}
		catch
		{
			this.oneTimePasswordInvalidLabel.Visible = true;
		}
	}

	void GetOneTimePasswordAuthenticationInfo(ref string userKey, ref OneTimePasswordAuthenticationProvider provider)
	{
		var membershipUser = Membership.GetUser(this.loginPanel.UserName);
		string providerKey;

		if (OneTimePasswordAuthenticationProvider.ParsePasswordQuestion(membershipUser.PasswordQuestion, out userKey, out providerKey))
			provider = OneTimePasswordAuthenticationProvider.GetInstance(providerKey);
	}

	void OnLoginSuccess()
	{
		// get correct capitalization
		var userName = Membership.Provider.GetUser(this.loginPanel.UserName, false).UserName;

		var authCookie = FormsAuthentication.GetAuthCookie(userName, this.loginPanel.RememberMeSet);
		authCookie.HttpOnly = true; // GetAuthCookie/SetAuthCookie in mono won't set HttpOnly
		this.Response.Cookies.Add(authCookie);

		this.RedirectToReturnUrl();
	}

	void RedirectToReturnUrl()
	{
		var redirectUrl = this.Context.Request.QueryString["ReturnUrl"] ?? FormsAuthentication.DefaultUrl;
		this.Response.Redirect(redirectUrl);
	}
	
</script>
<asp:Content runat="server" ContentPlaceHolderID="Main">
	<div class="ContentPanel Login">
		<form runat="server">
		<h1 runat="server" innerhtml="<%$ Resources:Default, LoginPanel.Heading %>" />
		<asp:MultiView runat="server" ID="multiView">
			<asp:View runat="server">
				<p runat="server" innerhtml="<%$ Resources:Default, LoginPanel.Message %>" />
				<asp:Login runat="server" ID="loginPanel" TitleText="" CssClass="LoginTable" OnLoggedIn="OnLoginPanelLoggedIn" OnAuthenticate="OnLoginPanelAuthenticate" UserNameLabelText="<%$ Resources:Default, LoginPanel.UserNameLabelText %>" PasswordLabelText="<%$ Resources:Default, LoginPanel.PasswordLabelText %>" RememberMeText="<%$ Resources:Default, LoginPanel.RememberMeText %>" LoginButtonText="<%$ Resources:Default, LoginPanel.ButtonText %>" FailureText="<%$ Resources:Default, LoginPanel.FailureText %>" />
			</asp:View>
			<asp:View runat="server">
				<p runat="server" innerhtml="<%$ Resources:Default, LoginPanel.OneTimePasswordMessage %>" />
				<p>
					<span runat="server" innerhtml="<%$ Resources:Default, LoginPanel.OneTimePasswordLabelText %>" />
					<asp:TextBox runat="server" ID="oneTimePasswordBox" />
				</p>
				<p>
					<asp:Button runat="server" OnClick="OnOneTimePasswordLoginClick" Text="<%$ Resources:Default, LoginPanel.ButtonText %>" />
					<asp:Label runat="server" ID="oneTimePasswordInvalidLabel" Visible="false" Text="<%$ Resources:Default, LoginPanel.FailureText %>" ForeColor="Red" />
				</p>
			</asp:View>
		</asp:MultiView>
		</form>
	</div>
</asp:Content>
