﻿<%@ Control Language="C#" EnableViewState="false" %>
<%@ Implements Interface="Elsinore.ScreenConnect.IDataControl" %>
<script runat="server">

	public void Refresh()
	{
		var configuration = Elsinore.ScreenConnect.WebConfigurationManager.OpenWebConfiguration();
		var smtpSection = Elsinore.ScreenConnect.WebConfigurationManager.GetSection<SmtpSection>(configuration);

		this.smtpDirectButton.Checked = string.IsNullOrEmpty(smtpSection.Network.Host);
		this.smtpRelayButton.Checked = !this.smtpDirectButton.Checked;
		this.smtpRelayServerBox.Text = smtpSection.Network.Host;
		this.mailFromAddressBox.Text = smtpSection.From;
	}

	public void Save()
	{
		var configuration = Elsinore.ScreenConnect.WebConfigurationManager.OpenWebConfiguration();
		var smtpSection = Elsinore.ScreenConnect.WebConfigurationManager.GetSection<SmtpSection>(configuration);
		
		smtpSection.DeliveryMethod = System.Net.Mail.SmtpDeliveryMethod.Network;
		smtpSection.Network.Host = (this.smtpRelayButton.Checked ? this.smtpRelayServerBox.GetTrimmedOrNullText() : null);
		smtpSection.From = this.mailFromAddressBox.GetTrimmedOrNullText();

		ServerToolkit.Instance.SaveConfiguration(configuration);
	}

	public bool IsSaveAllowed { get { return true; } }

	protected override void OnInit(EventArgs e)
	{
		base.OnInit(e);

		this.smtpRelayButton.Attributes.Add("onclick", string.Format("var textBox = {0}; textBox.focus(); textBox.select();", this.smtpRelayServerBox.GetClientReference()));
		this.smtpRelayServerBox.Attributes.Add("onfocus", string.Format("{0}.checked = true;", this.smtpRelayButton.GetClientReference()));
	}

</script>
<script type="text/javascript">

	function createTestEmail() {
		var from = <%= this.mailFromAddressBox.GetClientReference() %>.value;
		var to = <%= this.mailTestToAddressBox.GetClientReference() %>.value;
		var relayHost = (<%= this.smtpRelayButton.GetClientReference() %>.checked ? <%= this.smtpRelayServerBox.GetClientReference() %>.value : null);

		SC.service.sendTestEmail(from, relayHost, to, function (email) {
			SC.ui.showModalMessageBox(SC.res["MailPanel.SuccessHeading"], SC.res["MailPanel.SuccessMessage"]);
		});
	}

</script>
<dl>
	<dt runat="server" innerhtml="<%$ Resources:Default, MailPanel.EmailInvitationDeliveryText %>" />
	<dd>
		<asp:RadioButton runat="server" ID="smtpDirectButton" GroupName="MailDelivery" Text="<%$ Resources:Default, MailPanel.SmtpDirectRadioButtonText %>" />
		<br />
		<asp:RadioButton runat="server" ID="smtpRelayButton" GroupName="MailDelivery" Text="<%$ Resources:Default, MailPanel.SmtpRelayRadioButtonText %>" />
		<asp:TextBox runat="server" ID="smtpRelayServerBox" />
		<asp:RequiredIfCheckedValidator runat="server" ControlToValidate="smtpRelayServerBox" CheckBoxControl="smtpRelayButton" Text="*" Display="Dynamic" SetFocusOnError="true" />
	</dd>
	<dt runat="server" innerhtml="<%$ Resources:Default, MailPanel.MailFromAddressLabelText %>" />
	<dd>
		<asp:TextBox runat="server" ID="mailFromAddressBox" Columns="35" />
		<asp:RequiredFieldValidator runat="server" ControlToValidate="mailFromAddressBox" Text="*" Display="Dynamic" />
	</dd>
	<dt runat="server" innerhtml="<%$ Resources:Default, MailPanel.SendTestMailToAddressLabelText %>" />
	<dd>
		<asp:TextBox runat="server" ID="mailTestToAddressBox" Columns="35" />
		<input type="button" value="<%= DR.MailPanel_SendTestMailButtonText %>" onclick="window.createTestEmail();" />
	</dd>
</dl>
