﻿window.SC = window.SC || {};
SC.launch = SC.launch || {};

SC.launch.ClickOnceDirectLauncher = function () {
	this.name = ".NET ClickOnce Direct";

	this.launch = function (clientLaunchParameters) {
		var url = SC.launch.getLaunchUrl("Elsinore.ScreenConnect.Client.application", clientLaunchParameters);
		var launched = false;

		if (window.navigator.userAgent.match("Chrome")) {
			try {
				// this is specific to Chrome plugin for ClickOnce to prevent page reload
				var embedElement = SC.ui.get("clickOnceEmbed") || SC.ui.addElement(document.body, "EMBED", { id: "clickOnceEmbed", type: "application/x-ms-application" }, "width: 0px; height: 0px;");
				embedElement.launchClickOnce(url);
				launched = true;
			} catch (ex) {
				// don't care, will launch normally
			}
		}

		if (!launched)
			SC.util.launchDownload(url);
	};
}

SC.launch.ClickOnceBootstrapLauncher = function () {
	this.name = ".NET ClickOnce Bootstrap";

	this.launch = function (clientLaunchParameters) {
		var url = SC.launch.getLaunchUrl("Elsinore.ScreenConnect.ClientBootstrap.exe", clientLaunchParameters);
		SC.util.launchDownload(url);
	};
}

SC.launch.ClickOnceRunLauncher = function () {
	this.name = ".NET ClickOnce Run";

	this.launch = function (clientLaunchParameters) {
		var url = SC.launch.getLaunchUrl("Elsinore.ScreenConnect.Client.exe", clientLaunchParameters);
		SC.util.launchDownload(url);
	};
}

SC.launch.WebStartLauncher = function () {
	this.name = "Java Web Start";

	this.launch = function (clientLaunchParameters) {
		var url = SC.launch.getLaunchUrl("Elsinore.ScreenConnect.Client.jnlp", clientLaunchParameters);
		SC.util.launchDownload(url);
	};
}

SC.launch.WebStartBootstrapLauncher = function () {
	this.name = "Java Web Start Bootstrap";

	this.launch = function (clientLaunchParameters) {
		var url = SC.launch.getLaunchUrl("Elsinore.ScreenConnect.ClientBootstrap.jnlp", clientLaunchParameters);
		SC.util.launchDownload(url);
	};
}

SC.launch.MacBundleLauncher = function () {
	this.name = "Mac Bundle";

	this.launch = function (clientLaunchParameters) {
		var url = SC.launch.getRelaySchemeUrl(clientLaunchParameters);
		var fallbackUrl = SC.launch.getLaunchUrl("Elsinore.ScreenConnect.Client.zip", clientLaunchParameters);
		SC.launch.launchWithFallback(url, fallbackUrl, 2000, false);
	};
}

SC.launch.NativeClientLauncher = function () {
	this.name = "Native Client";

	this.launch = function (clientLaunchParameters) {
		var relayUrl = SC.launch.getRelaySchemeUrl(clientLaunchParameters);
		SC.util.launchDownload(relayUrl, true);
	};
}

SC.launch.AndroidFallbackLauncher = function () {
	this.name = "Android Fallback";

	this.launch = function (clientLaunchParameters) {
		var url = SC.launch.getRelaySchemeUrl(clientLaunchParameters);
		var packageSuffix = SC.launch.getAndroidPackageSuffix();
		var fallbackUrl = SC.util.formatString("market://details?id=com.elsitech.screenconnect.androidclient{1}&referrer={0}", encodeURIComponent(url), packageSuffix);
		SC.launch.launchWithFallback(url, fallbackUrl, 2000, true);
	};
}

SC.launch.AndroidIntentLauncher = function () {
	this.name = "Android Intent";

	this.launch = function (clientLaunchParameters) {
		var relayUrl = SC.launch.getRelaySchemeUrl(clientLaunchParameters);
		var packageSuffix = SC.launch.getAndroidPackageSuffix();
		var intentUrl = relayUrl.replace("relay:", "intent:") + "#Intent;scheme=relay;package=com.elsitech.screenconnect.androidclient" + packageSuffix + ";end";
		SC.util.launchDownload(intentUrl, true);
	};
}

SC.launch.iOSFallbackLauncher = function () {
	this.name = "iOS Fallback";

	this.launch = function (clientLaunchParameters) {
		var url = SC.launch.getRelaySchemeUrl(clientLaunchParameters);
		var fallbackUrl = "http://itunes.apple.com/us/app/screenconnect/id423995707";
		SC.launch.launchWithFallback(url, fallbackUrl, 25, true);
	};
}

SC.launch.getSortedLaunchers = function () {
	var launchers = [];

	// these are the best launchers for each of the respective conditions
	// and mutually exclusive with each other
	if (SC.util.isWindowsNT() && SC.util.isClickOnceCapable())
		launchers.push(new SC.launch.ClickOnceDirectLauncher());
	else if (SC.util.isIntelMacOS(10.6))
		launchers.push(new SC.launch.MacBundleLauncher());
	else if (SC.util.isNativeClient())
		launchers.push(new SC.launch.NativeClientLauncher());

	if (SC.util.isWindowsNT()) {
		// 2013-03 Firefox pretty friendly with JNLP files, giving open/save option to directly run the file, sometimes leaves download window open
		// 2013-03 Firefox annoying with EXE files, only allows save, and have to click on file in downloads popup window
		// 2013-03 Chrome very hostile to JNLP files, giving keep/discard prompt as it considers them "dangerous"
		// 2013-03 Chrome very friendly with EXE files, giving one click run option and presenting OS-level prompt afterwards
		// 2013-04 IE equally friendly to JNLP and EXE providing bottom bar Run/Save dialog and launching directly
		var shouldUseWebStartBootstrapBeforeExes = navigator.userAgent.match(/Firefox/) && SC.util.isWebStartCapable();

		if (shouldUseWebStartBootstrapBeforeExes)
			launchers.push(new SC.launch.WebStartBootstrapLauncher());

		if (SC.util.isWindowsNT(6))
			launchers.push(new SC.launch.ClickOnceRunLauncher());
		else
			launchers.push(new SC.launch.ClickOnceBootstrapLauncher());

		if (!shouldUseWebStartBootstrapBeforeExes)
			launchers.push(new SC.launch.WebStartBootstrapLauncher());
	} else if (SC.util.isAndroid()) {
		// some newfangled hack google came up with for chrome 25
		// this will fallback to the google play store automatically
		if (SC.util.isWebKit(537))
			launchers.push(new SC.launch.AndroidIntentLauncher());

		launchers.push(new SC.launch.AndroidFallbackLauncher());
	} else if (SC.util.isiOS()) {
		launchers.push(new SC.launch.iOSFallbackLauncher());
	}

	if (!SC.util.isMobile())
		launchers.push(new SC.launch.WebStartLauncher());

	return launchers;
}

SC.launch.getLauncherCount = function (attemptIndex) {
	if (window._launchers === undefined)
		window._launchers = SC.launch.getSortedLaunchers();

	return window._launchers.length;
}

SC.launch.getLauncher = function (launcherWrappableIndex) {
	if (window._launchers === undefined)
		window._launchers = SC.launch.getSortedLaunchers();

	var launcherIndex = (launcherWrappableIndex || 0) % window._launchers.length;
	return window._launchers[launcherIndex];
}

SC.launch.getLaunchSuggestionHtml = function () {
	if (SC.util.isWindowsNT() && !SC.util.isClickOnceCapable()) {
		if (navigator.userAgent.match(/Firefox/))
			return SC.res["Launcher.FirefoxClickOnceSuggestion"];
		else if (navigator.userAgent.match(/Chrome/))
			return SC.res["Launcher.ChromeClickOnceSuggestion"];
	}

	return null;
}

SC.launch.getAndroidPackageSuffix = function () {
	if (navigator.userAgent.match(/Samsung|GT-|SCH-|SGH-|SM-/))
		return ".samsung";
	else
		return "";
}

SC.launch.getLaunchUrl = function (fileName, clientLaunchParameters) {
	return SC.util.getScriptBaseUrl() + "Bin/" + fileName + SC.util.getQueryString(clientLaunchParameters);
}

SC.launch.getRelaySchemeUrl = function (clientLaunchParameters) {
	return SC.util.formatString(
			"relay://{0}:{1}/{2}/{3}/{4}/{5}/{6}/{7}",
			clientLaunchParameters.h,
			clientLaunchParameters.p,
			clientLaunchParameters.s,
			encodeURIComponent(clientLaunchParameters.k || ""),
			encodeURIComponent(clientLaunchParameters.n || ""),
			encodeURIComponent(clientLaunchParameters.r || ""),
			clientLaunchParameters.e,
			encodeURIComponent(clientLaunchParameters.i || "")
	);
}

SC.launch.launchWithFallback = function (url, fallbackUrl, fallbackAfterMilliseconds, isDownlevel) {
	if (SC.util.canSilentlyFailBadUrl()) {
		var initialLaunchTime = new Date();
		var blurred = false;
		var blurHandler = function () { blurred = true; };

		SC.ui.addHandler(window, "blur", blurHandler);

		window.setTimeout(function () {
			SC.ui.removeHandler(window, "blur", blurHandler);

			if (!blurred && !document.webkitHidden && new Date() - initialLaunchTime < fallbackAfterMilliseconds + 500)
				SC.util.launchDownload(fallbackUrl, isDownlevel);
		}, fallbackAfterMilliseconds);

		SC.util.launchDownload(url, isDownlevel);
	} else {
		var confirmedInstallation = window.confirm(SC.res["Launcher.InstallPrompt"]);
		SC.util.launchDownload(confirmedInstallation ? url : fallbackUrl, isDownlevel);
	}
}
