﻿window.SC = window.SC || {};
SC.ui = SC.ui || {};

SC.ui.get = function (elementID) {
	return window.document.getElementById(elementID);
}

SC.ui.getVisible = function (element) {
	return element.style.display != "none";
}

SC.ui.setVisible = function (element, visible) {
	element.style.display = (visible ? "" : "none");
}

SC.ui.findNextSibling = function (element, predicate) {
	for (var e = element.nextSibling; e != null; e = e.nextSibling)
		if (predicate(e))
			return e;

	return null;
}

SC.ui.findAncestorNode = function (element, predicate) {
	while (element && !predicate(element))
		element = element.parentNode;

	return element;
}

SC.ui.findDescendentNode = function (element, predicate) {
	for (var childNode = element.firstChild; childNode; childNode = childNode.nextSibling) {
		if (predicate(childNode))
			return childNode;

		var foundNode = SC.ui.findDescendentNode(childNode, predicate);

		if (foundNode != null)
			return foundNode;
	}

	return null;
}

SC.ui.setElementContent = function (element, content, isHtml) {
	if (isHtml) {
		element.innerHTML = (content == null ? "" : content);
	} else {
		element.innerHTML = "";

		if (content != null) {
			var textNode = element.ownerDocument.createTextNode(content);
			element.appendChild(textNode);
		}
	}
}

SC.ui.getElementContent = function (element) {
	return element.innerHTML;
}

SC.ui.discardElement = function (element) {
	var leakBin = document.getElementById("leakBin");

	if (!leakBin)
		leakBin = SC.ui.addElement(document.body, "DIV", { id: "leakBin" }, "display: none;");

	leakBin.appendChild(element);
	SC.ui.clearElement(leakBin);
}

SC.ui.clearElement = function (element) {
	if (element.innerHTML)
		element.innerHTML = "";
}

SC.ui.createTextBox = function (isMultiLine, styles, enterCommandName, placeholderText) {
	var element;

	if (isMultiLine)
		element = SC.ui.createElement("TEXTAREA", null, styles);
	else
		element = SC.ui.createElement("INPUT", { type: "text" }, styles);

	if (!SC.util.isNullOrEmpty(placeholderText))
		element.placeholder = placeholderText;

	element.onkeypress = function (event) {
		var eventArgs = SC.ui.getEventArgs(event);

		if (enterCommandName && SC.ui.isEnterKey(eventArgs) && !eventArgs.shiftKey) {
			SC.ui.dispatchCommand(element, element, element, enterCommandName, null);
			return false;
		}

		return true;
	}

	return element;
}

SC.ui.showModalActivityBox = function (title, message) {
	var loadingHeading = SC.ui.createElement("H1", { className: "LoadingHeading" }, null, message);
	return SC.ui.showModalDialog("ActivityBox", title, loadingHeading);
}

SC.ui.showModalErrorBox = function (message) {
	return SC.ui.showModalMessageBox(SC.res["ErrorPanel.Title"], message);
}

SC.ui.showModalMessageBox = function (title, message) {
	var paragraph = SC.ui.createElement("P", null, null, message);
	return SC.ui.showModalDialog("MessageBox", title, paragraph);
}

SC.ui.showModalPage = function (title, url, subClassName) {
	var titlePanel = SC.ui.createModalDialogTitlePanel(title);
	var frame = SC.ui.createElement("IFRAME", { src: url });
	SC.ui.showModalDialogRaw(subClassName, [titlePanel, frame]);
}

SC.ui.showModalButtonDialog = function (subClassName, title, buttonText, buttonCommandName, contentBuilderProc, commandProc) {
	var titlePanel = SC.ui.createModalDialogTitlePanel(title);
	var mainContentPanel = SC.ui.createModalDialogContentPanel();
	var buttonPanel = SC.ui.createModalDialogButtonPanel();
	var button = SC.ui.addElement(buttonPanel, "INPUT", { type: "button", value: buttonText, _commandName: buttonCommandName });

	contentBuilderProc(mainContentPanel);

	SC.ui.showModalDialogRaw(subClassName, [titlePanel, mainContentPanel, buttonPanel], commandProc);
	button.focus();
}

SC.ui.showModalDialog = function (subClassName, title, content) {
	var titlePanel = SC.ui.createModalDialogTitlePanel(title);
	var contentPanel = SC.ui.createModalDialogContentPanel(content);
	SC.ui.showModalDialogRaw(subClassName, [titlePanel, contentPanel]);
}

SC.ui.showModalDialogRaw = function (subClassName, dialogPanels, commandProc) {
	SC.ui.hideModalDialog();

	var dialog = SC.ui.addElement(document.body, "DIV", { id: "dialog", className: "ModalDialog " + subClassName });
	SC.util.forEach(dialogPanels, function (dialogPanel) { dialog.appendChild(dialogPanel); });

	Sys.UI.DomElement.setLocation(dialog, 0, 0);

	SC.ui.repositionModalDialog();

	SC.ui.addHandler(dialog, "mousedown", function (event) {
		var eventArgs = SC.ui.getEventArgs(event);
		var element = SC.ui.getElement(eventArgs);
		var commandElement = SC.ui.findAncestorNode(element, function (e) { return e._commandName != undefined; });

		if (commandElement == null && SC.ui.findAncestorNode(element, function (e) { return SC.ui.containsCssClass(e, "TitlePanel"); }) != null) {
			var location = Sys.UI.DomElement.getLocation(dialog);
			var mouseLocation = SC.ui.getMouseLocation(eventArgs);
			window._dragOffset = { x: location.x - mouseLocation.x, y: location.y - mouseLocation.y };
			SC.ui.preventEventDefault(eventArgs);
		}
	});

	SC.ui.addHandler(dialog, "mousemove", function (event) {
		if (window._dragOffset) {
			var eventArgs = SC.ui.getEventArgs(event);
			var mouseLocation = SC.ui.getMouseLocation(eventArgs);
			Sys.UI.DomElement.setLocation(dialog, window._dragOffset.x + mouseLocation.x, window._dragOffset.y + mouseLocation.y);
		}
	});

	SC.ui.addHandler(dialog, "mouseup", function () { SC.ui.clearModalDialogDragState(); });

	SC.ui.addHandler(window, "mouseup", SC.ui.onModalDialogWindowMouseUp);
	SC.ui.addHandler(window, "resize", SC.ui.onModalDialogWindowResize);

	dialog._oncommand = function (command) {
		if (command.commandName == "Close") {
			SC.ui.hideModalDialog();
			return true;
		}

		if (commandProc)
			return commandProc(command);
	};

	// HACK HACK HACK for iOS fixed position bug
	if (SC.util.isiOS()) {
		SC.ui.findDescendentNode(dialog, function (e) {
			if (e.tagName == "TEXTAREA" || (e.tagName == "INPUT" && e.type == "text")) {
				SC.ui.addHandler(e, "blur", function (event) {
					document.body.scrollTop = 0;
				});
			}
		});
	}
}

SC.ui.getModalDialog = function () {
	return SC.ui.get("dialog");
}

SC.ui.onModalDialogWindowMouseUp = function (event) {
	SC.ui.clearModalDialogDragState();
}

SC.ui.onModalDialogWindowResize = function (event) {
	SC.ui.repositionModalDialog();
}

SC.ui.clearModalDialogDragState = function () {
	if (window._dragOffset) {
		window._dragOffset = undefined;
		return true;
	}
}

SC.ui.repositionModalDialog = function () {
	var dialog = SC.ui.getModalDialog();
	var bounds = Sys.UI.DomElement.getBounds(dialog);

	Sys.UI.DomElement.setLocation(
		dialog,
		Math.round(Math.max(0, (window.document.body.clientWidth / 2) - (bounds.width / 2))),
		Math.round(Math.max(0, (window.document.body.clientHeight / 2) - (bounds.height / 2)))
	);
}

SC.ui.hideModalDialog = function () {
	var dialog = SC.ui.getModalDialog();

	if (dialog) {
		SC.ui.removeHandler(window, "mouseup", SC.ui.onModalDialogWindowMouseUp);
		SC.ui.removeHandler(window, "resize", SC.ui.onModalDialogWindowResize);
		SC.ui.discardElement(dialog);
		return true;
	}
}

SC.ui.createModalDialogTitlePanel = function (title) {
	var panel = SC.ui.createElement("DIV", { className: "TitlePanel" });
	SC.ui.addElement(panel, "SPAN", null, null, title);
	SC.ui.addElement(panel, "A", { _commandName: "Close" }, null, "[X]");
	return panel;
}

SC.ui.createModalDialogContentPanel = function (content) {
	return SC.ui.createElement("DIV", { className: "ContentPanel" }, null, content);
}

SC.ui.createModalDialogButtonPanel = function (defaultButtonText) {
	var panel = SC.ui.createElement("DIV", { className: "ButtonPanel" });

	if (!SC.util.isNullOrEmpty(defaultButtonText))
		SC.ui.addElement(panel, "INPUT", { type: "button", _commandName: "Default", value: defaultButtonText });

	return panel;
}

SC.ui.setModalDialogButtonPanelError = function (buttonPanel, error) {
	var errorParagraph = SC.util.findListElement(buttonPanel.childNodes, function (n) { return n.className == "Failure" });

	if (errorParagraph == null)
		errorParagraph = SC.ui.addElement(buttonPanel, "P", { className: "Failure" });

	SC.ui.setElementContent(errorParagraph, error.message);
}

SC.ui.addEntryHistoryPanel = function (container, placeholderText, buttonText, addCommandName, deleteCommandName, eventFilter, historyNavigateFilter, activeImmediatelyIfHardKeyboard) {
	var entryHistoryPanel = SC.ui.addElement(container, "DIV", { className: "EntryHistoryPanel", _addCommandName: addCommandName, _deleteCommandName: deleteCommandName, _eventFilter: eventFilter });

	var historyPanel = SC.ui.addElement(entryHistoryPanel, "DIV", { className: "HistoryPanel" });
	var entryPanel = SC.ui.addElement(entryHistoryPanel, "DIV", { className: "EntryPanel" });

	var entryBoxPositioningPanel = SC.ui.addElement(entryPanel, "DIV");
	var entryBox = SC.ui.createTextBox(true, null, "Default", placeholderText);
	entryBoxPositioningPanel.appendChild(entryBox);

	var button = SC.ui.addElement(entryPanel, "INPUT", { type: "button", value: buttonText, _commandName: "Default" });

	entryBox.onkeydown = function (event) {
		var eventArgs = SC.ui.getEventArgs(event);
		var step = 0;

		if (eventArgs.keyCode == 38) {
			step = -1; // up
		} else if (eventArgs.keyCode == 40) {
			step = 1; // down
		} else if (eventArgs.keyCode == 33) {
			step = -10; // page up
		} else if (eventArgs.keyCode == 34) {
			step = 10; // page down
		}

		if (step != 0) {
			var navigateItems = SC.util.filterList(historyPanel.childNodes, function (n) { return historyNavigateFilter(n._event); });
			var index = SC.util.findListIndex(navigateItems, function (n) { return n._event.eventID == entryBox._historyEventID; });

			if (index == -1)
				index = navigateItems.length;

			index = Math.max(0, index + step);

			if (navigateItems[index] == undefined) {
				entryBox._historyEventID = null;
				entryBox.value = "";
			} else {
				entryBox._historyEventID = navigateItems[index]._event.eventID;
				entryBox.value = navigateItems[index]._event.data;
			}
		}
	};

	entryHistoryPanel._oncommand = function (command) {
		if (command.commandName == "Default") {
			var entryText = entryBox.value.trim();

			if (!SC.util.isNullOrEmpty(entryText)) {
				SC.ui.dispatchCommand(entryPanel, button, entryHistoryPanel, entryHistoryPanel._addCommandName, entryText);
				entryBox._historyEventID = null;
				entryBox.value = "";
			}

			entryBox.focus();
			return true;
		}
	};

	if (activeImmediatelyIfHardKeyboard && !SC.util.isMobile()) {
		SC.ui.scrollToBottom(entryHistoryPanel.firstChild);
		entryHistoryPanel.firstChild.nextSibling.firstChild.firstChild.focus();
	}

	return entryHistoryPanel;
}

SC.ui.getEntryHistoryPanelAddCommandName = function (entryHistoryPanel) {
	return entryHistoryPanel._addCommandName;
}

SC.ui.setEntryHistoryPanelEntryEnabled = function (entryHistoryPanel, entryEnabled) {
	SC.ui.findDescendentNode(entryHistoryPanel, function (e) {
		if (e.tagName == "INPUT" || e.tagName == "TEXTAREA")
			e.disabled = (entryEnabled ? "" : "disabled");
	});
}

SC.ui.rebuildEntryHistoryPanel = function (entryHistoryPanel, events) {
	var historyPanel = entryHistoryPanel.firstChild;

	SC.ui.clearElement(historyPanel);

	var filteredEvents = SC.util.filterList(events, entryHistoryPanel._eventFilter);

	for (var i = 0; filteredEvents[i]; i++) {
		var eventPanel = SC.ui.addElement(historyPanel, "DIV", { _event: filteredEvents[i] });

		if (entryHistoryPanel._deleteCommandName != null)
			SC.ui.addElement(eventPanel, "A", { _commandName: entryHistoryPanel._deleteCommandName, _commandArgument: filteredEvents[i].eventID }, null, "[X]");

		var whoText = SC.util.isNullOrEmpty(filteredEvents[i].who) ? SC.res["HostPanel.GuestAnonymousName"] : filteredEvents[i].who;
		SC.ui.addElement(eventPanel, "P", { className: "Who" }, null, whoText);

		var timeText = SC.util.formatDateTime(filteredEvents[i].time);
		SC.ui.addElement(eventPanel, "P", { className: "Time" }, null, timeText);

		SC.ui.addElement(eventPanel, "P", { className: "Data" }, null, filteredEvents[i].data);
	}

	SC.ui.scrollToBottom(historyPanel);
}

SC.ui.togglePopoutDropDown = function (popoutFrom, label, asyncPopulateProc, buttonProc) {
	var dropDown;

	var populateProcCallback = function (values) {
		for (var i in values)
			dropDown.add(new Option(values[i]), null);
	};

	var inputBuilderProc = function (panel, button) {
		dropDown = SC.ui.createElement("SELECT");
		panel.appendChild(dropDown);

		asyncPopulateProc(populateProcCallback);
	};

	var showProc = function () { dropDown.focus(); };
	var outerButtonProc = function () { buttonProc(dropDown.selectedIndex, dropDown.options[dropDown.selectedIndex].value); };
	SC.ui.togglePopoutInput(popoutFrom, label, inputBuilderProc, showProc, outerButtonProc);
}

SC.ui.togglePopoutInput = function (popoutFrom, label, inputBuilderProc, showProc, buttonProc) {
	var buildProc = function (popoutPanel, closeProc) {
		var paragraph = SC.ui.addElement(popoutPanel, "P");

		if (label) {
			SC.ui.addTextNode(paragraph, label);
			SC.ui.addNonBreakingSpace(paragraph);
		}

		var button = SC.ui.createElement("INPUT", { type: "button", value: ">" });
		button.onclick = function () { buttonProc(); closeProc(); }

		inputBuilderProc(paragraph, button);

		SC.ui.addNonBreakingSpace(paragraph);
		paragraph.appendChild(button);
	}

	SC.ui.togglePopoutPanel(popoutFrom, buildProc, showProc);
}

SC.ui.getPopoutPanel = function () {
	return SC.ui.get("popoutPanel");
};

SC.ui.togglePopoutPanel = function (popoutFrom, buildProc, showProc) {
	var popoutPanel = SC.ui.getPopoutPanel();

	if (popoutPanel != null) {
		SC.ui.discardElement(popoutPanel);
	} else {
		popoutPanel = SC.ui.addElement(document.body, "DIV", { id: "popoutPanel" });

		var closeProc = function () { SC.ui.discardElement(popoutPanel); };
		popoutPanel._oncommand = closeProc;
		buildProc(popoutPanel, closeProc);

		var popoutPanelStyle = (window.getComputedStyle ? window.getComputedStyle(popoutPanel) : null);
		var borderWidth = (popoutPanelStyle == null || SC.util.isNullOrEmpty(popoutPanelStyle.borderWidth) ? 0 : parseInt(popoutPanelStyle.borderWidth, 10));

		if (popoutFrom.nodeType == 1) {
			var popoutFromBounds = popoutFrom.getBoundingClientRect();
			popoutPanel.style.top = (popoutFromBounds.bottom + (document.body.scrollTop || document.documentElement.scrollTop) - borderWidth) + "px";

			var leftOrRight = true;

			SC.ui.findAncestorNode(popoutFrom, function (e) {
				var computedStyle = SC.ui.getComputedStyle(e);

				if (computedStyle != null) {
					if (computedStyle.left != "auto" || computedStyle.cssFloat == "left") {
						leftOrRight = true;
						return true;
					} else if (computedStyle.right != "auto" || computedStyle.cssFloat == "right") {
						leftOrRight = false;
						return true;
					}
				}
			});

			if (leftOrRight)
				popoutPanel.style.left = (popoutFromBounds.left + (document.body.scrollLeft || document.documentElement.scrollLeft)) + "px";
			else
				popoutPanel.style.right = (document.body.clientWidth - popoutFromBounds.right + (document.body.scrollLeft || document.documentElement.scrollLeft)) + "px";
		} else if (popoutFrom.x != undefined && popoutFrom.y != undefined) {
			popoutPanel.style.left = popoutFrom.x + "px";
			popoutPanel.style.top = popoutFrom.y + "px";
		}

		var bodyHandler = function (event) {
			var element = SC.ui.getElement(SC.ui.getEventArgs(event));

			if (SC.ui.findAncestorNode(element, function (e) { return e == popoutPanel || e == popoutFrom; }) == null) {
				SC.ui.removeHandler(document.body, "touchstart", bodyHandler);
				SC.ui.removeHandler(document.body, "mousedown", bodyHandler);
				SC.ui.discardElement(popoutPanel);
			}
		};

		SC.ui.addHandler(document.body, "touchstart", bodyHandler);
		SC.ui.addHandler(document.body, "mousedown", bodyHandler);

		var popoutHandler = function (event) {
			var eventArgs = SC.ui.getEventArgs(event);
			SC.ui.cancelEventBubble(event);
		};

		SC.ui.addHandler(popoutPanel, "touchstart", popoutHandler);
		SC.ui.addHandler(popoutPanel, "mousedown", popoutHandler);

		if (showProc)
			showProc();
	}
}

SC.ui.addCell = function (row, properties, styles, content) {
	var cell = row.insertCell(-1);
	SC.ui.initializeElement(cell, properties, styles, content);
	return cell;
}

SC.ui.createElement = function (tagName, properties, styles, content) {
	var createTagName = tagName;

	if (SC.util.isInternetExplorer(5, 7) && properties && properties.name) // awful, awful
		createTagName = SC.util.formatString("<{0} name=\"{1}\" />", tagName, properties.name);

	var element = document.createElement(createTagName);
	SC.ui.initializeElement(element, properties, styles, content);
	return element;
}

SC.ui.addElement = function (container, tagName, properties, styles, content) {
	var element = SC.ui.createElement(tagName, properties, styles, content);
	container.appendChild(element);
	return element;
}

SC.ui.addRadioButtonPanel = function (container, tagName, labelContent, groupName, value, checked, enabled, extraElement) {
	var id = groupName + value;
	var panel = SC.ui.addElement(container, tagName);
	var radioButton = SC.ui.addElement(panel, "INPUT", { id: id, type: "radio", value: value, name: groupName, checked: checked, disabled: !enabled });
	SC.ui.addNonBreakingSpace(panel);

	var label = SC.ui.addElement(panel, "LABEL", { htmlFor: enabled ? id : null });
	SC.ui.setElementContent(label, labelContent, true);

	if (extraElement) {
		SC.ui.addNonBreakingSpace(panel);
		panel.appendChild(extraElement);

		extraElement.onclick = function () { radioButton.checked = true; };

		if (extraElement.tagName == "INPUT")
			radioButton.onclick = function () { extraElement.select(); };
	}

	return panel;
}

SC.ui.initializeElement = function (element, properties, styles, content) {
	if (properties) {
		for (var propertyName in properties)
			element[propertyName] = properties[propertyName];

		if (properties._commandName != undefined)
			SC.ui.addCommandHandler(element);
	}

	if (element.tagName == "A" && !element.href)
		element.href = "#";

	if (typeof styles == "string")
		element.style.cssText = styles;
	else if (styles)
		for (var styleName in styles)
			element.style[styleName] = styles[styleName];

	SC.ui.addContent(element, content);
}

SC.ui.addCommandHandler = function (element, allowContextCommand) {
	var updateCommandCoordinatesProc = function (eventArgs) {
		window._commandCoordinates = { x: eventArgs.clientX, y: eventArgs.clientY };
	};

	var isNearCommandCoordinatesFunc = function (eventArgs) {
		return window._commandCoordinates && Math.sqrt(Math.pow(Math.abs(window._commandCoordinates.x - eventArgs.clientX), 2) + Math.pow(Math.abs(window._commandCoordinates.y - eventArgs.clientY), 2)) < 10;
	};

	var downProc = function (eventArgs, activeClassName, intensiveActiveClassName) {
		if (window._cancelActiveProc) {
			if (!SC.ui.containsCssClass(element, activeClassName))
				window._cancelActiveProc();

			window.clearTimeout(window._cancelActiveTimeout);
			window._cancelActiveProc = undefined;
		}

		var isDisabled = SC.ui.containsCssClass(element, "Disabled");
		SC.ui.ensureCssClass(element, activeClassName, !isDisabled);

		if (!isNearCommandCoordinatesFunc(eventArgs))
			SC.ui.ensureCssClass(element, intensiveActiveClassName, false);

		updateCommandCoordinatesProc(eventArgs);
	};

	var upProc = function (eventArgs, activeClassName, intensiveActiveClassName, canBeIntense) {
		if (SC.ui.containsCssClass(element, activeClassName)) {
			if (isNearCommandCoordinatesFunc(eventArgs)) {
				var clickedElement = SC.ui.getElement(eventArgs);

				SC.ui.dispatchCommand(
					element,
					clickedElement,
					element,
					element._commandName,
					element._commandArgument,
					eventArgs.shiftKey,
					canBeIntense && SC.ui.containsCssClass(element, intensiveActiveClassName),
					SC.ui.isRightButton(eventArgs)
				);

				updateCommandCoordinatesProc(eventArgs);

				if (canBeIntense)
					SC.ui.ensureCssClass(element, intensiveActiveClassName, true);

				window._cancelActiveProc = function () {
					SC.ui.ensureCssClass(element, intensiveActiveClassName, false);
					SC.ui.ensureCssClass(element, activeClassName, false);
				};

				window._cancelActiveTimeout = window.setTimeout(function () {
					if (window._cancelActiveProc) {
						window._cancelActiveProc();
						window._cancelActiveProc = undefined;
					}
				}, 250);
			} else {
				SC.ui.ensureCssClass(element, intensiveActiveClassName, false);
				SC.ui.ensureCssClass(element, activeClassName, false);
			}
		}
	};

	SC.ui.addHandler(element, "mousedown", function (event) {
		var eventArgs = SC.ui.getEventArgs(event);

		if ((allowContextCommand || SC.ui.isLeftButton(eventArgs)) && !window._lastTouchEndMillis || window._lastTouchEndMillis < SC.util.getMillisecondCount() - 1000)
			downProc(eventArgs, "ClickActive", "ClickIntenseActive");
	});

	SC.ui.addHandler(element, "mouseup", function (event) {
		var eventArgs = SC.ui.getEventArgs(event);
		var isLeftButton = SC.ui.isLeftButton(eventArgs);

		if (allowContextCommand || isLeftButton) {
			upProc(eventArgs, "ClickActive", "ClickIntenseActive", isLeftButton);
			SC.ui.cancelEventBubble(eventArgs);
		}
	});

	SC.ui.addHandler(element, "touchstart", function (event) {
		var eventArgs = SC.ui.getEventArgs(event);
		downProc(eventArgs.changedTouches[0], "TouchActive", "TouchIntenseActive");
	});

	SC.ui.addHandler(element, "touchend", function (event) {
		var eventArgs = SC.ui.getEventArgs(event);
		window._lastTouchEndMillis = SC.util.getMillisecondCount();
		upProc(eventArgs.changedTouches[0], "TouchActive", "TouchIntenseActive", true);
		SC.ui.preventEventDefault(eventArgs);
		SC.ui.cancelEventBubble(eventArgs);
	});

	SC.ui.addHandler(element, "click", function (event) {
		var eventArgs = SC.ui.getEventArgs(event);

		if (allowContextCommand || SC.ui.isLeftButton(eventArgs)) {
			SC.ui.preventEventDefault(eventArgs);
			SC.ui.cancelEventBubble(eventArgs);
		}
	});
}

SC.ui.addContent = function (container, content) {
	if (typeof content == "string")
		SC.ui.setElementContent(container, content);
	else if (content && content.length)
		for (var i = 0; content[i]; i++)
			SC.ui.addContent(container, content[i]);
	else if (content)
		container.appendChild(content);
}

SC.ui.addTextNode = function (container, text) {
	var textNode = document.createTextNode(text);
	container.appendChild(textNode);
}

SC.ui.addNonBreakingSpace = function (container) {
	SC.ui.addTextNode(container, "\u00a0");
}

SC.ui.getRadioButtonGroupSelectedValue = function (groupName) {
	var checkedRadioButton = SC.util.findListElement(document.getElementsByName(groupName), function (rb) { return rb.checked; });
	return (checkedRadioButton == null ? null : checkedRadioButton.value);
}

SC.ui.setRadioButtonGroupSelectedValue = function (groupName, value) {
	SC.util.findListElement(document.getElementsByName(groupName), function (rb) { rb.checked = (rb.value == value); });
}

SC.ui.moveNodeUp = function (node) {
	var parentNode = node.parentNode;
	var nodeBefore = node.previousSibling
	parentNode.removeChild(node);
	parentNode.insertBefore(node, nodeBefore);
}

SC.ui.moveNodeDown = function (node) {
	var parentNode = node.parentNode;
	var nodeAfterAfter = node.nextSibling.nextSibling;
	parentNode.removeChild(node);

	if (nodeAfterAfter)
		parentNode.insertBefore(node, nodeAfterAfter);
	else
		parentNode.appendChild(node);
}

SC.ui.insertChild = function (parentElement, childElement, index) {
	var beforeElement = parentElement.childNodes[index];

	if (beforeElement)
		parentElement.insertBefore(childElement, beforeElement);
	else
		parentElement.appendChild(childElement);
}

SC.ui.refreshTableRowsWithNewData = function (table, tableRowIndex, dataArray, dataKeySelector, dataRowUpdater, dataRowUpdaterUserData, rowUserData) {
	var dataRow = table.rows[tableRowIndex];

	for (var i = 0; dataArray[i]; i++) {
		var dataKey = dataKeySelector(dataArray[i]);

		while (true) {
			if (!dataRow)
				return;

			if (dataKeySelector(dataRow._dataItem) == dataKey)
				break;

			dataRow = dataRow.nextSibling;
		}

		dataRow._dataItem = dataArray[i];
		dataRow._userData = rowUserData;
		dataRowUpdater(dataRow, dataRow._dataItem, dataRow._userData, dataRowUpdaterUserData);
	}
}

SC.ui.refreshTableRowsWithExistingData = function (table, tableRowIndex, dataRowUpdater, dataRowUpdaterUserData) {
	for (var dataRow = table.rows[tableRowIndex]; dataRow; dataRow = dataRow.nextSibling)
		dataRowUpdater(dataRow, dataRow._dataItem, dataRow._userData, dataRowUpdaterUserData);
}

SC.ui.rebuildTableRows = function (table, tableRowIndex, dataArray, dataKeySelector, dataRowInitializer, dataRowUpdater, dataRowUpdaterUserData, rowUserData) {
	for (var i = 0; dataArray[i]; i++) {
		var dataKey = dataKeySelector(dataArray[i]);
		var dataRow = null;

		for (var j = tableRowIndex; table.rows[j]; j++) {
			if (table.rows[j]._dataItem && dataKeySelector(table.rows[j]._dataItem) == dataKey) {
				dataRow = table.rows[j];

				if (j != tableRowIndex) {
					table.tBodies[0].removeChild(dataRow);
					table.tBodies[0].insertBefore(dataRow, table.tBodies[0].rows[tableRowIndex]);
				}
			}
		}

		if (dataRow == null) {
			dataRow = table.insertRow(tableRowIndex);
			dataRowInitializer(dataRow, dataArray[i]);
		}

		tableRowIndex++;

		dataRow._dataItem = dataArray[i];
		dataRow._userData = rowUserData;
		dataRowUpdater(dataRow, dataRow._dataItem, dataRow._userData, dataRowUpdaterUserData);
	}

	while (table.rows[tableRowIndex])
		table.deleteRow(tableRowIndex);
}

SC.ui.rebuildContainer = function (container, dataArray, dataKeySelector, elementCreator, elementUpdater) {
	var childIndex = 0;

	for (var i = 0; dataArray[i]; i++) {
		var dataKey = dataKeySelector(dataArray[i]);
		var elementForDataKey = null;

		for (var j = childIndex; container.childNodes[j]; j++) {
			if (container.childNodes[j]._dataItem && dataKeySelector(container.childNodes[j]._dataItem) == dataKey) {
				elementForDataKey = container.childNodes[j];

				if (j != childIndex) {
					container.removeChild(elementForDataKey);
					SC.ui.insertChild(container, elementForDataKey, childIndex);
				}
			}
		}

		if (elementForDataKey == null) {
			elementForDataKey = elementCreator(dataArray[i]);
			SC.ui.insertChild(container, elementForDataKey, childIndex);
		}

		childIndex++;

		elementForDataKey._dataItem = dataArray[i];
		elementUpdater(elementForDataKey, dataArray[i]);
	}

	while (container.childNodes[childIndex])
		container.removeChild(container.childNodes[childIndex]);
}

SC.ui.getComputedStyle = function (element) {
	if (window.getComputedStyle)
		return window.getComputedStyle(element);
	else
		return element.currentStyle;
}

SC.ui.cancelEventBubble = function (eventArgs) {
	if (eventArgs.stopPropagation)
		eventArgs.stopPropagation();
	else
		eventArgs.cancelBubble = true;
}

SC.ui.preventEventDefault = function (eventArgs) {
	if (eventArgs.preventDefault)
		eventArgs.preventDefault();
	else
		eventArgs.returnValue = false;
}

SC.ui.getEventArgs = function (event) {
	return event || window.event;
}

SC.ui.getElement = function (eventArgs) {
	return eventArgs.target ? eventArgs.target : eventArgs.srcElement;
}

SC.ui.isLeftButton = function (eventArgs) {
	return eventArgs.which === 1 || eventArgs.button === 1 || eventArgs.button === 0;
}

SC.ui.isRightButton = function (eventArgs) {
	return eventArgs.which === 3 || eventArgs.button === 2;
}

SC.ui.getMouseLocation = function (eventArgs) {
	if (eventArgs.pageX || eventArgs.pageY)
		return { x: eventArgs.pageX, y: eventArgs.pageY };

	return {
		x: eventArgs.clientX + document.body.scrollLeft - document.body.clientLeft,
		y: eventArgs.clientY + document.body.scrollTop - document.body.clientTop
	};
}

SC.ui.scrollToBottom = function (element) {
	element.scrollTop = element.scrollHeight;
}

SC.ui.scrollToFarRight = function (element) {
	element.scrollLeft = element.scrollWidth;
}

SC.ui.createImageDeclaration = function (contentType, base64Content) {
	return "data:" + contentType + ";base64," + base64Content;
}

SC.ui.dispatchCommand = function (element, clickedElement, commandElement, commandName, commandArgument, isAdvanced, isIntense, isContext) {
	var command = {
		clickedElement: clickedElement,
		commandElement: commandElement,
		commandName: commandName,
		commandArgument: commandArgument,
		isAdvanced: isAdvanced,
		isIntense: isIntense,
		isContext: isContext
	};

	var commandProcs = [];

	SC.ui.findAncestorNode(element.parentNode, function (e) {
		if (e._oncommand)
			commandProcs.push(e._oncommand);
	});

	SC.util.findListElement(commandProcs, function (cp) {
		return cp(command);
	});
}

SC.ui.isEnterKey = function (eventArgs) {
	return eventArgs && eventArgs.keyCode == 13;
}

SC.ui.addSearchHandler = function (element, func) {
	SC.ui.addHandler(element, SC.util.isDefined(element.onsearch) ? "search" : "keyup", func);
}

SC.ui.addHandler = function (element, eventName, func) {
	if (SC.util.isDefined(element.addEventListener))
		element.addEventListener(eventName, func, false);
	else if (SC.util.isDefined(element.attachEvent))
		element.attachEvent("on" + eventName, func);
	else
		element["on" + eventName] = func;
}

SC.ui.removeHandler = function (element, eventName, func) {
	if (SC.util.isDefined(element.removeEventListener))
		element.removeEventListener(eventName, func);
	else if (SC.util.isDefined(element.detachEvent))
		element.detachEvent("on" + eventName, func);
	else
		element["on" + eventName] = null;
}

SC.ui.addCommandButtons = function (container, buttonDefinitions) {
	for (var i in buttonDefinitions) {
		var commandName = buttonDefinitions[i].commandName;
		var button = SC.ui.addElement(container, "A", { _commandName: buttonDefinitions[i].commandName, _commandArgument: buttonDefinitions[i].commandArgument, className: buttonDefinitions[i].className || "" });

		var text = buttonDefinitions[i].text ||
			SC.res["Command." + commandName + buttonDefinitions[i].commandArgument + ".Text"] ||
			SC.res["Command." + commandName + ".Text"];

		if (buttonDefinitions[i].hideText)
			button.title = text;

		if (buttonDefinitions[i].imageUrl)
			SC.ui.addElement(button, "IMG", { src: buttonDefinitions[i].imageUrl, alt: text });

		if (text && !buttonDefinitions[i].hideText)
			SC.ui.addElement(button, "SPAN", null, null, text);
	}
}

SC.ui.updateCommandButtonsState = function (container, isVisibleFunc, isEnabledFunc) {
	SC.ui.findDescendentNode(container, function (e) {
		if (e._commandName) {
			var isVisible = isVisibleFunc(e._commandName, e._commandArgument);
			SC.ui.setVisible(e, isVisible);

			if (isVisible) {
				var isEnabled = isEnabledFunc(e._commandName, e._commandArgument);
				SC.ui.ensureCssClass(e, "Disabled", !isEnabled);
			}
		}
	});
}

SC.ui.containsCssClass = function (element, className) {
	return !SC.util.isNullOrEmpty(element.className) && (" " + element.className + " ").indexOf(" " + className + " ") != -1;
}

SC.ui.ensureCssClass = function (element, className, hasOrNot) {
	var previouslyContained = SC.ui.containsCssClass(element, className);

	if (hasOrNot && !previouslyContained) {
		element.className = (element.className === "" ? className : element.className + " " + className);
		return true;
	} else if (!hasOrNot && previouslyContained) {
		var paddedClassName = " " + element.className + " ";
		var index = paddedClassName.indexOf(" " + className + " ");
		element.className = (paddedClassName.substr(0, index) + " " + paddedClassName.substring(index + className.length + 1, paddedClassName.length)).trim();
		return true;
	}
}

SC.ui.setChangesMade = function () {
	if (!window._isChangesMadeSubscribed) {
		SC.ui.addHandler(window, "beforeunload", function () {
			if (window._changesMade)
				return SC.res["ChangesMadePrompt.Text"];
		});

		window._isChangesMadeSubscribed = true;
	}

	window._changesMade = true;
}

SC.ui.clearChangesMade = function () {
	window._changesMade = false;
}

SC.ui.setSelected = function (element, isSelected) {
	return SC.ui.ensureCssClass(element, "Selected", isSelected);
}

SC.ui.setChecked = function (element, isChecked) {
	return SC.ui.ensureCssClass(element, "Checked", isChecked);
}

SC.ui.isSelected = function (element) {
	return SC.ui.containsCssClass(element, "Selected");
}

SC.ui.isChecked = function (element) {
	return SC.ui.containsCssClass(element, "Checked");
}

SC.ui.onPageRequestManagerEndRequest = function (sender, eventArgs) {
	var error = eventArgs.get_error();

	if (error != null) {
		eventArgs.set_errorHandled(true);

		if (error.httpStatusCode != 0) {
			// ASP.NET prepends the name, which is very unfriendly, to the description, with a colon and space after
			var message = error.message.substring(error.name.length + 2);
			SC.ui.showModalErrorBox(message);
		}
	}
}

SC.ui.setSvgAttributes = function (element, attributes) {
	if (attributes)
		for (var attributeName in attributes)
			element.setAttributeNS(null, attributeName, attributes[attributeName]);
};

SC.ui.addSvgElement = function (container, name, attributes, style, textContent, title) {
	var element = document.createElementNS("http://www.w3.org/2000/svg", name);

	SC.ui.setSvgAttributes(element, attributes);

	if (style)
		element.style = style;

	if (title)
		SC.ui.setSvgTitle(element, title);

	if (textContent)
		SC.ui.addTextNode(element, textContent);

	container.appendChild(element);

	return element;
};

SC.ui.setSvgTitle = function (element, title) {
	SC.ui.addSvgElement(element, "title", null, null, title);
}

SC.ui.setSvgTransform = function (element, translateX, translateY, postRotateAngle) {
	var transformString = "";

	if (translateX != 0 || translateY != 0)
		transformString += "translate(" + translateX + " " + translateY + ")";

	if (postRotateAngle != 0)
		transformString += "rotate(" + postRotateAngle + ")";

	SC.ui.setSvgAttributes(element, { transform: transformString });
};

SC.ui.areSvgRectsIntersecting = function (r1, r2) {
	return ((((r2.x < (r1.x + r1.width)) && (r1.x < (r2.x + r2.width))) && (r2.y < (r1.y + r1.height))) && (r1.y < (r2.y + r2.height)));
};

SC.ui.initializeWindowFocusTracking = function () {
	if (!SC.util.isInternetExplorer(5, 8)) {
		SC.ui.addHandler(window, "blur", function () { window._blurred = true; });
		SC.ui.addHandler(window, "focus", function () { window._blurred = false; });
	}
}

SC.ui.isWindowInFocus = function () {
	return !window._blurred;
}

SC.ui.startSessionInfoRefreshLoop = function (isDirty, invokeServiceProc, sessionInfoChangedProc) {
	window.clearTimeout(window._sessionInfoRefreshTimeoutID);

	if (!SC.ui.isWindowInFocus()) {
		window._sessionInfoRefreshTimeoutID = window.setTimeout(function () {
			SC.ui.startSessionInfoRefreshLoop(isDirty, invokeServiceProc, sessionInfoChangedProc);
		}, 1000);
	} else {
		var requestVersion = (isDirty || !window._sessionInfo || !window._lastSessionInfoFullRefreshTime || SC.util.getMillisecondCount() - window._lastSessionInfoFullRefreshTime > 3600000 ? 0 : window._sessionInfo.v);

		if (requestVersion == 0)
			window._lastSessionInfoFullRefreshTime = SC.util.getMillisecondCount();

		if (window._pendingSessionInfoRequest != undefined) {
			window._pendingSessionInfoRequest.abort();
			window._pendingSessionInfoRequest = undefined;
		}

		var onSuccess = function (result) {
			window._pendingSessionInfoRequest = undefined;

			window._sessionInfoRefreshTimeoutID = window.setTimeout(function () {
				SC.ui.startSessionInfoRefreshLoop(false, invokeServiceProc, sessionInfoChangedProc);
			}, 1000);

			if (result) {
				window._sessionInfo = result;
				sessionInfoChangedProc(requestVersion);
			}
		}

		var onFailure = function (error) {
			window._pendingSessionInfoRequest = undefined;

			var shouldShowError = (error.errorType !== "TimeoutException")

			if (shouldShowError)
				SC.ui.showModalErrorBox(error.detail || error.message);

			window._sessionInfoRefreshTimeoutID = window.setTimeout(function () {
				if (shouldShowError)
					SC.ui.hideModalDialog();

				SC.ui.startSessionInfoRefreshLoop(true, invokeServiceProc, sessionInfoChangedProc);
			}, 10000);
		}

		window._pendingSessionInfoRequest = invokeServiceProc(requestVersion, onSuccess, onFailure);
	}
}
