﻿window.SC = window.SC || {};
SC.util = SC.util || {};

SC.util.jsonSerialize = function (object) {
	if (SC.util.isDefined(Sys)) {
		return Sys.Serialization.JavaScriptSerializer.serialize(object);
	} else if (SC.util.isDefined(JSON)) {
		if (window.Prototype)
			delete Array.prototype.toJSON;

		return JSON.stringify(object);
	} else if (SC.util.isDefined(object.toJSON)) {
		return object.toJSON();
	}
}

SC.util.jsonDeserialize = function (jsonString) {
	if (SC.util.isDefined(Sys))
		return Sys.Serialization.JavaScriptSerializer.deserialize(jsonString);
	else if (SC.util.isDefined(JSON))
		return JSON.parse(jsonString);
	else if (SC.util.isDefined(jsonString.evalJSON))
		return jsonString.evalJSON(true);
}

SC.util.formatString = function (format, args) {
	var actualArguments = arguments;
	var actualArgumentsOffset = 1;

	if (args instanceof Array) {
		actualArguments = args;
		actualArgumentsOffset = 0;
	}

	var replaceFunc = function (a, b, c, d) {
		var argIndex = parseInt(b);
		var argFormat = d;
		var argValue = actualArguments[argIndex + actualArgumentsOffset];

		if (argValue == undefined || argValue == null)
			return "";
		else if (d != undefined && argValue.toFormattedString)
			return argValue.toFormattedString(d);
		else if (d != undefined && argValue.format)
			return argValue.format(d);
		else
			return argValue.toString();
	};

	return format.replace(/\{([0-9]+)(:([^\}]+))?\}/g, replaceFunc);
}

SC.util.generatePhoneticText = function (string) {
	var phoneticCodes = SC.util.selectFromList(string, function (codeChar) { return SC.res["PhoneticAlphabet." + codeChar.toUpperCase()] || codeChar });
	return phoneticCodes.join("-");
}

SC.util.getCookieValue = function (name) {
	var cookieStrings = document.cookie.split(";");

	for (var i = 0; cookieStrings[i]; i++) {
		var cookieParts = cookieStrings[i].split("=");

		if (decodeURIComponent(cookieParts[0]).trim() == name)
			return decodeURIComponent(cookieParts[1]);
	}

	return null;
}

SC.util.setCookieValue = function (name, value, days) {
	var date = new Date();
	date.setDate(date.getDate() + days);
	var encodedValue = encodeURIComponent(value);
	document.cookie = SC.util.formatString("{0}={1}; expires={2:F}", name, encodedValue, date);
}

SC.util.loadSettings = function () {
	var stringValue = SC.util.getCookieValue("settings");

	if (stringValue == null)
		return {};

	return SC.util.jsonDeserialize(stringValue);
}

SC.util.saveSettings = function (settings) {
	var stringValue = SC.util.jsonSerialize(settings);
	SC.util.setCookieValue("settings", stringValue, 3650);
}

SC.util.parseQueryString = function (queryString) {
	var map = {};

	if (queryString.length != 0) {
		if (queryString.charAt(0) == "?")
			queryString = queryString.slice(1);

		queryString = queryString.replace(/\+/g, ' ');

		var parts = queryString.split("&");

		for (var i = 0; parts[i]; i++) {
			var subParts = parts[i].split("=");
			var name = decodeURIComponent(subParts[0]);
			var value = decodeURIComponent(subParts[1]);
			map[name] = value;
		}
	}

	return map;
}

SC.util.getQueryString = function (map) {
	var queryString = "";
	var first = true;

	for (var key in map) {
		var value = map[key];
		var valueArray;

		if (value == undefined || value == null) {
			valueArray = [];
		} else if (value instanceof Array) {
			valueArray = value;
		} else {
			// watch out, in one JS version Array constructor with integer
			// will create that many elements
			valueArray = new Array();
			valueArray.push(value);
		}

		for (var i = 0; i < valueArray.length; i++) {
			queryString += (first ? "?" : "&") + encodeURIComponent(key) + "=" + encodeURIComponent(valueArray[i]);
			first = false;
		}
	}

	return queryString;
}

SC.util.launchDownload = function (url, isDownlevel) {
	if (isDownlevel)
		window.location.href = url;
	else
		SC.ui.addElement(document.body, "IFRAME", { src: url }, "display: none;");
}

SC.util.areAllEqual = function (array, selector) {
	var firstValue = (selector ? selector(array[0]) : array[0]);

	for (var i = 1; array[i] != undefined; i++)
		if ((selector ? selector(array[i]) : array[i]) != firstValue)
			return false;

	return true;
}

SC.util.contains = function (array, predicate) {
	return SC.util.findListIndex(array, predicate) != -1;
}

SC.util.findListIndex = function (array, predicate) {
	if (array != null)
		for (var i = 0; array[i] != undefined; i++)
			if (predicate(array[i], i))
				return i;

	return -1;
}

SC.util.findListElement = function (array, predicate) {
	var index = SC.util.findListIndex(array, predicate);
	return (index == -1 ? null : array[index]);
}

SC.util.filterList = function (array, predicate) {
	var newArray = [];

	if (array != null)
		for (var i = 0; array[i] != undefined; i++)
			if (predicate(array[i], i))
				newArray.push(array[i]);

	return newArray;
}

SC.util.selectFromList = function (array, selector) {
	var newArray = [];

	if (array != null)
		for (var i = 0; array[i] != undefined; i++)
			newArray[i] = selector(array[i], i);

	return newArray;
}

SC.util.createArray = function (size, populator) {
	var array = [];

	for (var i = 0; i < size; i++)
		array[i] = populator(i);

	return array;
}

SC.util.indexOf = function (array, item) {
	for (var i = 0; array[i] !== undefined; i++)
		if (array[i] === item)
			return i;

	return -1;
}

SC.util.forEach = function (array, func) {
	if (array != null)
		for (var i = 0; array[i] !== undefined; i++)
			func(array[i], i);
}

SC.util.coalesce = function (x, y) {
	return (x === null || x === undefined ? y : x);
}

SC.util.isVersion = function (minVersion, maxVersion, actualVersion) {
	if (actualVersion == 0)
		return false;

	if (minVersion !== undefined && actualVersion < minVersion)
		return false;

	if (maxVersion !== undefined && actualVersion > maxVersion)
		return false;

	return true;
}

SC.util.isInternetExplorer = function (minVersion, maxVersion) {
	if (window._internetExplorerVersion === undefined) {
		var matches = navigator.userAgent.match(/MSIE ([0-9.]+)/);
		window._internetExplorerVersion = (matches == null ? 0 : parseFloat(matches[1]));
	}

	return SC.util.isVersion(minVersion, maxVersion, window._internetExplorerVersion);
}

SC.util.isWindowsNT = function (minVersion, maxVersion) {
	if (window._windowsNTVersion === undefined) {
		var matches = navigator.userAgent.match(/Windows NT ([0-9.]+)/);
		window._windowsNTVersion = (matches == null ? 0 : parseFloat(matches[1]));
	}

	return SC.util.isVersion(minVersion, maxVersion, window._windowsNTVersion);
}

SC.util.isIntelMacOS = function (minVersion, maxVersion) {
	if (window._intelMacOSVersion === undefined) {
		var matches = navigator.userAgent.match(/Intel Mac OS X ([0-9]+)(_|\.)([0-9]+)(_|;|\))/);
		window._intelMacOSVersion = (matches == null ? 0 : parseFloat(matches[1] + "." + matches[3]));
	}

	return SC.util.isVersion(minVersion, maxVersion, window._intelMacOSVersion);
}

SC.util.isWebKit = function (minVersion, maxVersion) {
	if (window._webKitVersion === undefined) {
		var matches = navigator.userAgent.match(/WebKit\/([0-9.]+)/);
		window._webKitVersion = (matches == null ? 0 : parseFloat(matches[1]));
	}

	return SC.util.isVersion(minVersion, maxVersion, window._webKitVersion);
}

SC.util.isNativeClient = function (minVersion, maxVersion) {
	if (window._nativeClientVersion === undefined) {
		var matches = navigator.userAgent.match(/ScreenConnect\/([0-9]+\.[0-9]+)\./);
		window._nativeClientVersion = (matches == null ? 0 : parseFloat(matches[1]));
	}

	return SC.util.isVersion(minVersion, maxVersion, window._nativeClientVersion);
}

SC.util.isAndroid = function () {
	return navigator.userAgent.match(/android/i);
}

SC.util.isiOS = function () {
	return navigator.userAgent.match(/iphone|ipad|ipod|ios/i);
}

SC.util.isMobile = function () {
	return SC.util.isiOS() || SC.util.isAndroid();
}

SC.util.canBrowserAutoDownload = function () {
	return !SC.util.isInternetExplorer();
}

SC.util.canSilentlyFailBadUrl = function () {
	// they do some kind of prompting
	if (navigator.userAgent.match(/Android.*Firefox/))
		return false;

	// they broke it and now goes to error page with ERR_UNKNOWN_URL_SCHEME
	if (navigator.userAgent.match(/Android/) && SC.util.isWebKit(537))
		return false;

	// safari on mavericks now displays "There is no application set to open the URL"
	if (SC.util.isIntelMacOS(10.9) && navigator.userAgent.match(/Safari/))
		return false;

	// chrome always displays "External Protocol Request" prompt regardless of whether the app is installed
	if (SC.util.isIntelMacOS() && navigator.userAgent.match(/Chrome/))
		return false;

	return true;
}

SC.util.isWebStartCapable = function () {
	if (window.ActiveXObject) {
		try {
			var obj = new ActiveXObject("JavaWebStart.isInstalled");

			if (obj != null)
				return true;
		} catch (e) {
			// don't care
		}
	}

	if (window.navigator.mimeTypes["application/x-java-jnlp-file"] != null || navigator.mimeTypes["application/x-java-applet;version=1.5"] != null)
		return true;

	return false;
}

SC.util.isClickOnceCapable = function () {
	return SC.context.clickOnceHeaderValue != null ||
		navigator.userAgent.match(/\.NET/) ||
		SC.util.isInternetExplorer(9) ||
		(navigator.userAgent.match(/Chrome/) && window.navigator.mimeTypes["application/x-ms-application"] != null);
}

SC.util.combineObjects = function () {
	var newObject = {};

	SC.util.findListElement(arguments, function (i) {
		for (var j in i)
			newObject[j] = i[j]
	});

	return newObject;
}

SC.util.openClientEmail = function (to, subject, body) {
	var url = "mailto:" + (to == null ? "" : to) + SC.util.getQueryString({ subject: subject, body: body });
	SC.util.launchDownload(url);
}

SC.util.formatDomainMember = function (domain, member) {
	var domainEmpty = SC.util.isNullOrEmpty(domain);
	var memberEmpty = SC.util.isNullOrEmpty(member);

	if (domainEmpty && memberEmpty)
		return "";
	else if (domainEmpty)
		return member;
	else if (memberEmpty)
		return domain + "\\";
	else
		return domain + "\\" + member;
}

SC.util.formatDuration = function (originalSeconds, additionalSeconds) {
	var string = "";
	var durationSeconds = originalSeconds;

	if (additionalSeconds)
		durationSeconds += additionalSeconds;

	if (originalSeconds >= 0) {
		var days = Math.floor(durationSeconds / 86400); durationSeconds %= 86400;
		var hours = Math.floor(durationSeconds / 3600); durationSeconds %= 3600;
		var minutes = Math.floor(durationSeconds / 60); durationSeconds %= 60;

		if (days != 0)
			string += days + "d ";

		if (hours != 0)
			string += hours + "h ";

		string += minutes + "m";
	}

	return string;
}

SC.util.formatDateTime = function (dateTime) {
	return SC.util.padToTwoDigits(dateTime.getMonth() + 1) +
		"-" +
		SC.util.padToTwoDigits(dateTime.getDate()) +
		" " +
		SC.util.padToTwoDigits(dateTime.getHours()) +
		":" +
		SC.util.padToTwoDigits(dateTime.getMinutes()) +
		":" +
		SC.util.padToTwoDigits(dateTime.getSeconds());
}

SC.util.padToTwoDigits = function (number) {
	return (number < 10) ? "0" + number : number.toString();
}

SC.util.getHashParameters = function () {
	var hashString = SC.util.getWindowHashString();

	if (!hashString || hashString.length < 1)
		return [];

	var hashParts = hashString.substring(1).split("/");
	return SC.util.selectFromList(hashParts, function (hashPart) { return decodeURIComponent(hashPart); });
}

SC.util.getHashStringFromParameters = function (parameters) {
	var lastParameterIndex = -1;
	var hashString = "";

	for (var i = 0; i < parameters.length; i++)
		if (!SC.util.isNullOrEmpty(parameters[i]))
			lastParameterIndex = i;

	for (var i = 0; i <= lastParameterIndex; i++) {
		hashString += (i == 0 ? "#" : "/");

		if (!SC.util.isNullOrEmpty(parameters[i]))
			hashString += encodeURIComponent(parameters[i]);
	}

	return hashString;
}

SC.util.getWindowHashString = function () {
	// bug in firefox requires using different impl than window.location.hash
	// https://bugzilla.mozilla.org/show_bug.cgi?id=582361
	var hashIndex = window.location.href.indexOf("#");
	return (hashIndex == -1 ? "" : window.location.href.substring(hashIndex));
}

SC.util.getHashParameter = function (index) {
	var hashParameters = SC.util.getHashParameters();
	return hashParameters[index];
}

SC.util.setHashParameter = function (index, value) {
	var hashParameters = SC.util.getHashParameters();

	for (var i = 0; i < index; i++)
		if (hashParameters[i] == undefined)
			hashParameters.push("");

	hashParameters[i] = value;

	var newHashString = SC.util.getHashStringFromParameters(hashParameters)
	var existingHashString = SC.util.getWindowHashString();
	var isDifferent = newHashString != existingHashString;

	if (isDifferent)
		window.location.hash = newHashString;

	return isDifferent;
}

SC.util.base64Encode = function (input) {
	var keyStr = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
	var output = "";
	var chr1, chr2, chr3, enc1, enc2, enc3, enc4;
	var i = 0;

	while (i < input.length) {
		chr1 = input.charCodeAt(i++);
		chr2 = input.charCodeAt(i++);
		chr3 = input.charCodeAt(i++);

		enc1 = chr1 >> 2;
		enc2 = ((chr1 & 3) << 4) | (chr2 >> 4);
		enc3 = ((chr2 & 15) << 2) | (chr3 >> 6);
		enc4 = chr3 & 63;

		if (isNaN(chr2)) {
			enc3 = enc4 = 64;
		} else if (isNaN(chr3)) {
			enc4 = 64;
		}

		output = output + keyStr.charAt(enc1) + keyStr.charAt(enc2) + keyStr.charAt(enc3) + keyStr.charAt(enc4);
	}

	return output;
}

SC.util.getScriptBaseUrl = function () {
	return SC.util.isNullOrEmpty(SC.context.scriptBaseUrl) ? SC.util.getBaseUrl(location.href) : SC.context.scriptBaseUrl;
}

SC.util.getBaseUrl = function (url) {
	var hashIndex = url.lastIndexOf("#")

	if (hashIndex != -1)
		url = url.substring(0, hashIndex);

	var slashIndex = url.lastIndexOf("/");

	return url.substring(0, slashIndex + 1);
}

SC.util.isNullOrEmpty = function (string) {
	return (typeof string != "string" || string == "");
}

SC.util.getEnumValueName = function (enumType, value) {
	for (var enumName in enumType)
		if (enumType[enumName] == value)
			return enumName;

	return null;
}

SC.util.getRandomStringFromMask = function (mask) {
	var string = "";

	for (var i = 0; mask[i]; i++) {
		var maskChar = mask.charAt(i);

		if (maskChar == "#")
			string += SC.util.getRandomChar(48, 58);
		else if (maskChar == "A")
			string += SC.util.getRandomChar(65, 91);
		else
			string += maskChar;
	}

	return string;
}

SC.util.getRandomChar = function (minCharCode, maxCharCode) {
	var charCode = minCharCode + Math.floor(Math.random() * (maxCharCode - minCharCode));
	return String.fromCharCode(charCode);
}

SC.util.areObjectsEqual = function (objectX, objectY) {
	for (var field in objectX) {
		if (objectX[field] != null && objectY[field] != null && typeof (objectX[field]) == "object") {
			if (!SC.util.areObjectsEqual(objectX[field], objectY[field]))
				return false;
		} else {
			if (objectX[field] !== objectY[field])
				return false;
		}
	}

	return true;
}

SC.util.getBooleanResource = function (resourceString) {
	return SC.res[resourceString] === "true";
}

SC.util.replaceAll = function (string, find, replace, ignoreCase) {
	return string.replace(new RegExp(find.replace(/([\/\,\!\\\^\$\{\}\[\]\(\)\.\*\+\?\|\<\>\-\&])/g, "\\$&"), (ignoreCase ? "gi" : "g")), (typeof (replace) == "string") ? replace.replace(/\$/g, "$$$$") : replace);
};

SC.util.encodeHtml = function (htmlString) {
	return SC.util.replaceAll(SC.util.replaceAll(SC.util.replaceAll(SC.util.replaceAll(SC.util.replaceAll(htmlString, "&", "&amp;"), ">", "&gt;"), "<", "&lt;"), "\"", "&quot;"), "'", "&#39;");
}

SC.util.getCombinedClientLaunchParameters = function (commonClientLaunchParameters, sessionClientLaunchParameters, sessionType, processType, participantName) {
	var sessionTypeName = SC.util.getEnumValueName(SC.context.types.SessionType, sessionType);
	var processTypeName = SC.util.getEnumValueName(SC.context.types.ProcessType, processType);
	return SC.util.combineObjects(commonClientLaunchParameters, sessionClientLaunchParameters, { e: sessionTypeName, y: processTypeName, r: participantName });
}

SC.util.getSessionTypeResource = function (resourceNameFormat, sessionType) {
	var argumentsCopy = Array.prototype.slice.call(arguments);
	var sessionTypeName = SC.util.getEnumValueName(SC.context.types.SessionType, sessionType);

	for (var i = 0; i < 2; i++) {
		argumentsCopy[1] = (i == 0 ? sessionTypeName : "");

		var resourceName = SC.util.formatString.apply(this, argumentsCopy);
		var value = SC.res[resourceName];

		if (value != undefined && value != null)
			return value;
	}

	return null;
}

SC.util.isSessionCustomPropertyVisible = function (sessionType, propertyIndex) {
	return SC.util.getSessionTypeResource("SessionProperty.Custom{1}.{0}Visible", sessionType, propertyIndex + 1) === "true";
}

SC.util.forEachVisibleCustomProperty = function (sessionType, proc) {
	for (var i = 0; i < SC.context.constants.customPropertyCount; i++)
		if (SC.util.isSessionCustomPropertyVisible(sessionType, i))
			proc(i, "Custom" + (i + 1));
};

SC.util.getMillisecondCount = function () {
	return new Date().getTime();
}

SC.util.isDefined = function (reference) {
	// === "function" does not work for built-in functions and IE 8
	return typeof reference !== "undefined";
}

SC.util.getCacheEntry = function (key, version) {
	window._cache = window._cache || {};

	var cacheEntry = window._cache[key];

	if (!cacheEntry || cacheEntry.version != version)
		return null;

	cacheEntry.lastUsedTime = SC.util.getMillisecondCount();
	return cacheEntry;
}

SC.util.setCacheItem = function (key, version, item) {
	window._cache = window._cache || {};

	var cacheEntry = window._cache[key];

	if (!cacheEntry) {
		cacheEntry = {};
		window._cache[key] = cacheEntry;
	}

	cacheEntry.version = version;
	cacheEntry.firstUsedTime =
	cacheEntry.lastUsedTime = SC.util.getMillisecondCount();
	cacheEntry.item = item;

	// scavenge
	if (!window._cacheIntervalID) {
		window._cacheIntervalID = window.setTimeout(function () {
			var hasEntries = false;
			var now = SC.util.getMillisecondCount();

			for (var cacheKey in window._cache) {
				if (now - window._cache[cacheKey].lastUsedTime > 120000)
					window._cache[cacheKey] = undefined;
				else
					hasEntries = true;
			}

			if (!hasEntries) {
				window.clearInterval(window._cacheIntervalID);
				window._cacheIntervalID = undefined;
			}
		}, 120000);
	}

	return cacheEntry;
}

SC.util.invokeService = function (methodName, params, onSuccess, onFailure, userContext, userName, password) {
	var url = SC.context.scriptBaseUrl + "Service.ashx/" + methodName;
	var paramsString = SC.util.jsonSerialize(params);
	onSuccess = onSuccess || SC.context.defaultOnServiceSuccess;
	onFailure = onFailure || SC.context.defaultOnServiceFailure;

	var xhr;

	var completeProc = function (isKnownError) {
		var result;

		try {
			result = SC.util.jsonDeserialize(xhr.responseText);
		} catch (e) {
			// too bad, don't care
		}

		if (isKnownError || (xhr.status !== undefined && xhr.status !== 200)) {
			if (onFailure) {
				result = result || {
					errorType: (SC.util.indexOf([0, 404, 408, 504, 598, 599, 12002], xhr.status) == -1 ? "UnknownException" : "TimeoutException"),
					message: (SC.util.isNullOrEmpty(xhr.statusText) ? "Unknown error" : xhr.statusText)
				};

				onFailure(result, userContext);
			}
		} else {
			if (onSuccess) {
				onSuccess(result, userContext);
			}
		}
	}

	var authorizationString = (userName && password ? "Basic " + SC.util.base64Encode(userName + ":" + password) : null);

	var sendProc = function () {
		var fullUrl = url;

		if (SC.util.isDefined(xhr.onload))
			xhr.onload = function () { completeProc(false); }

		if (SC.util.isDefined(xhr.onerror))
			xhr.onerror = function () { completeProc(true); }

		if (SC.util.isDefined(xhr.onprogress))
			xhr.onprogress = function () { }

		if (!SC.util.isDefined(xhr.setRequestHeader) && authorizationString != null)
			fullUrl += SC.util.getQueryString({ "__Authorization": authorizationString });

		xhr.open("POST", fullUrl);

		if (!SC.util.isDefined(xhr.onload))
			xhr.onreadystatechange = function () { if (xhr.readyState == 4) completeProc(false); }

		if (SC.util.isDefined(xhr.withCredentials))
			xhr.withCredentials = true;

		if (SC.util.isDefined(xhr.setRequestHeader) && authorizationString != null)
			xhr.setRequestHeader("Authorization", authorizationString);

		xhr.send(paramsString);
	}

	try {
		xhr = new XMLHttpRequest();
		sendProc(xhr);
	} catch (e) {
		if (!SC.util.isDefined(XDomainRequest))
			throw e;

		xhr = new XDomainRequest();
		sendProc(xhr);
	}

	return xhr;
}
