﻿<%@ WebHandler Language="C#" Class="Elsinore.ScreenConnect.Script" %>

using System;
using System.Web;
using System.Configuration;
using System.Collections.Generic;
using System.Linq;
using System.Globalization;
using System.Collections;
using System.Web.Script.Serialization;
using System.Web.Compilation;

namespace Elsinore.ScreenConnect
{
	public class Script : SingletonHandler
	{
		public override void ProcessRequest(HttpContext context)
		{
			var relayUri = ServerExtensions.GetRelayUri(ConfigurationManager.AppSettings, context.Request.Url, true, true);

			var scContext = new
			{
				types = new
				{
					ProcessType = this.GenerateEnumDeclaration(typeof(ProcessType)),
					SessionEventType = this.GenerateEnumDeclaration(typeof(SessionEventType)),
					SessionType = this.GenerateEnumDeclaration(typeof(SessionType)),
					SessionPermissions = this.GenerateEnumDeclaration(typeof(SessionPermissions)),
					ClientType = this.GenerateEnumDeclaration(typeof(ClientType)),
					SessionAttributes = this.GenerateEnumDeclaration(typeof(SessionAttributes)),
				},
				clp = new
				{
					h = relayUri.Host,
					p = relayUri.Port,
					k = ServerCryptoManager.Instance.PublicKeyString,
				},
				clickOnceHeaderValue = context.Request.Headers["X-ClickOnceSupport"],
				scriptBaseUrl = string.Empty,
				constants = new
				{
					productVersion = Constants.ProductVersion.ToShortString(),
					customPropertyCount = Session.CustomPropertyCount,
				},
			};

			var scRes = this.GenerateResourceStringsDeclaration
			(
				"ErrorPanel.",
				"ChangesMadePrompt.",
				"Launcher.",
				"GuestSessionTable.",
				"ConnectedPanel.",
				"JoinPanel.",
				"JoinPromptPanel.",
				"SessionPanel.",
				"SessionJoinPanel.",
				"TransferSessionsPanel.",
				"SessionInfoPanel.",
				"ManageSessionGroupsPanel.",
				"BuildInstallerPanel.",
				"HostPanel.",
				"MailPanel.Success",
				"CheckSessionsPanel.",
				"InvitePanel.",
				"PhoneticAlphabet.",
				"SessionProperty.",
				"QueueEventPanel.",
				"Command.",
				"UserPanel.",
				"EditSessionsPanel.",
				"CreateSessionPanel.",
				"LogoPanel.",
				"SessionHelpPanel.",
				"NavigationPanel."
			);

			var webServiceType = BuildManager.GetCompiledType("~/Service.ashx");
			var functionAssignmentStrings = new List<string>();

			foreach (var methodParameterEntry in WebServiceBase.GetWebMethodParameterMap(webServiceType))
			{
				var camelCasedMethodName = char.ToLowerInvariant(methodParameterEntry.Key[0]) + methodParameterEntry.Key.Substring(1);
				var parametersString = string.Join(", ", methodParameterEntry.Value);
				var parametersDeclarationString = (parametersString == string.Empty ? string.Empty : parametersString + ", ");
				var functionAssignmentString = string.Format("{0}: function({1}onSuccess, onFailure, userContext, userName, password) {{ return SC.util.invokeService(\"{2}\", [{3}], onSuccess, onFailure, userContext, userName, password); }}", camelCasedMethodName, parametersDeclarationString, methodParameterEntry.Key, parametersString);
				functionAssignmentStrings.Add(functionAssignmentString);
			}

			if (!context.IsDebuggingEnabled)
			{
				context.Response.Cache.SetCacheability(HttpCacheability.Server);
				context.Response.Cache.SetExpires(DateTime.MaxValue);
				context.Response.Cache.SetValidUntilExpires(true);
				context.Response.Cache.VaryByHeaders["Host"] = true;
				context.Response.Cache.VaryByHeaders["Accept-Encoding"] = true;
				context.Response.Cache.VaryByHeaders["Accept-Language"] = true;
				context.Response.Cache.VaryByHeaders["X-ClickOnceSupport"] = true;
				context.Response.Cache.VaryByParams["*"] = true;
			}

			context.Response.ContentType = "text/javascript";

			context.Response.WriteFile(context.Request.MapPath("Script.Util.js"));
			context.Response.WriteFile(context.Request.MapPath("Script.Launch.js"));
			context.Response.WriteFile(context.Request.MapPath("Script.UI.js"));
			context.Response.Output.WriteLine("SC.service = {{\r\n\t{0}\r\n}};", string.Join(",\r\n\t", functionAssignmentStrings.ToArray()));
			context.Response.Output.WriteLine("SC.context = {0};", new JavaScriptSerializer().Serialize(scContext));
			context.Response.Output.WriteLine("SC.res = {0};", new JavaScriptSerializer().Serialize(scRes));
		}

		object GenerateEnumDeclaration(Type type)
		{
			return Enum
				.GetValues(type)
				.OfType<object>()
				.ToDictionary(v => v.ToString());
		}

		object GenerateResourceStringsDeclaration(params string[] resourceNameStartsWiths)
		{
			return Resources.Default.ResourceManager
				.GetResourceSet(CultureInfo.CurrentUICulture, true, true)
				.OfType<DictionaryEntry>()
				.Where(de => resourceNameStartsWiths.Any(sw => ((string)de.Key).StartsWith(sw)))
				.ToDictionary(de => de.Key, de => de.Value);
		}
	}
}
