﻿<%@ Control Language="C#" CodeFile="Security.ascx.cs" Inherits="Elsinore.ScreenConnect.SecurityPanel" %>
<asp:MultiView runat="server" ID="multiView" ActiveViewIndex="0">
	<asp:View runat="server">
		<div style="float: right;">
			<span runat="server" id="authenticationTitleLabel" />
			<asp:LinkButton runat="server" ID="changeButton" Text="<%$ Resources:Default, SecurityPanel.ChangeButtonText %>" CommandName="Change" OnClick="OnAuthenticationButtonClick" /></div>
		<dl class="SecurityPanel">
			<dt runat="server" innerhtml="<%$ Resources:Default, SecurityPanel.RolesLabelText %>" />
			<dd>
				<asp:GridView runat="server" ID="roleView" EnableViewState="false" CssClass="DataTable" EmptyDataText="<%$ Resources:Default, SecurityPanel.EmptyRoleMessage %>" EmptyDataRowStyle-CssClass="EmptyRow" AutoGenerateColumns="false" OnRowEditing="OnViewRowEditing" OnRowUpdating="OnViewRowUpdating" OnRowCancelingEdit="OnViewRowCancelingEdit" OnRowDeleting="OnViewRowDeleting">
					<Columns>
						<asp:TemplateField>
							<EditItemTemplate>
								<asp:LinkButton runat="server" CommandName="Update" Text="<%$ Resources:Default, SecurityPanel.DoneButtonText %>" CausesValidation="true" ValidationGroup="Grid" />
								<asp:LinkButton runat="server" CommandName="Cancel" Text="<%$ Resources:Default, SecurityPanel.CancelButtonText %>" CausesValidation="false" />
							</EditItemTemplate>
							<ItemTemplate>
								<asp:LinkButton runat="server" CommandName="Edit" Text="<%$ Resources:Default, SecurityPanel.EditButtonText %>" CausesValidation="false" Enabled="<%# this.userView.EditIndex == -1 && this.roleView.EditIndex == -1 %>" />
								<asp:LinkButton runat="server" CommandName="Delete" Text="<%$ Resources:Default, SecurityPanel.DeleteButtonText %>" CausesValidation="false" Enabled="<%# this.userView.EditIndex == -1 && this.roleView.EditIndex == -1 %>" />
							</ItemTemplate>
						</asp:TemplateField>
						<asp:TemplateField HeaderText="<%$ Resources:Default, SecurityPanel.RoleNameHeaderText %>">
							<ItemTemplate>
								<%# Eval("Name") %></ItemTemplate>
							<EditItemTemplate>
								<asp:TextBox runat="server" ID="NameBox" Text='<%# Eval("Name") %>' />
								<asp:RequiredFieldValidator runat="server" ControlToValidate="NameBox" Text="*" EnableClientScript="false" ValidationGroup="Grid" Display="Dynamic" />
								<asp:CustomValidator runat="server" ControlToValidate="NameBox" Text="*" ValidationGroup="Grid" OnServerValidate="OnNameValidatorServerValidate" Display="Dynamic" />
							</EditItemTemplate>
						</asp:TemplateField>
						<asp:TemplateField HeaderText="<%$ Resources:Default, SecurityPanel.PermissionsHeaderText %>">
							<ItemTemplate>
								<asp:RepeaterEx runat="server" DataSource='<%# Eval("PermissionEntries") %>' />
							</ItemTemplate>
							<EditItemTemplate>
								<asp:RepeaterEx runat="server" DataSource='<%# ((GridRole)Container.DataItem).EditingPermissionEntries %>' OnItemCommand="OnRepeaterItemCommand">
									<ItemTemplate>
										<%# Container.DataItem %>
										<asp:LinkButton runat="server" CommandName="Delete" Text="[X]" CausesValidation="false" /></ItemTemplate>
								</asp:RepeaterEx>
								<div runat="server" ondatabinding="OnPermissionPanelDataBinding">
									<asp:DropDownList runat="server" ID="permissionList" AutoPostBack="true" OnSelectedIndexChanged="OnPermissionListChanged" />
									<asp:DropDownList runat="server" ID="sessionGroupFilterList" AutoPostBack="true" OnSelectedIndexChanged="OnPermissionListChanged" />
									<asp:DropDownList runat="server" ID="sessionGroupList" />
									<asp:DropDownList runat="server" ID="ownershipFilterList" />
									<asp:LinkButton runat="server" Text="<%$ Resources:Default, SecurityPanel.AddButtonText %>" OnClick="OnAddButtonClick" CausesValidation="false" />
								</div>
							</EditItemTemplate>
						</asp:TemplateField>
					</Columns>
				</asp:GridView>
				<asp:LinkButton runat="server" ID="newRoleButton" Text="<%$ Resources:Default, SecurityPanel.NewRoleButtonText %>" OnClick="OnNewRoleButtonClick" CausesValidation="false" />
				<asp:CustomValidator runat="server" ID="roleValidator" EnableClientScript="false" OnServerValidate="OnRoleValidatorServerValidate" />
			</dd>
			<dt runat="server" id="usersLabel" innerhtml="<%$ Resources:Default, SecurityPanel.UsersLabelText %>" />
			<dd runat="server" id="usersPanel">
				<asp:GridView runat="server" ID="userView" EnableViewState="false" CssClass="DataTable" EmptyDataText="<%$ Resources:Default, SecurityPanel.EmptyUserMessage %>" EmptyDataRowStyle-CssClass="EmptyRow" AutoGenerateColumns="false" OnRowEditing="OnViewRowEditing" OnRowUpdating="OnViewRowUpdating" OnRowCancelingEdit="OnViewRowCancelingEdit" OnRowDeleting="OnViewRowDeleting">
					<Columns>
						<asp:TemplateField>
							<EditItemTemplate>
								<asp:LinkButton runat="server" CommandName="Update" Text="<%$ Resources:Default, SecurityPanel.DoneButtonText %>" CausesValidation="true" ValidationGroup="Grid" />
								<asp:LinkButton runat="server" CommandName="Cancel" Text="<%$ Resources:Default, SecurityPanel.CancelButtonText %>" CausesValidation="false" />
							</EditItemTemplate>
							<ItemTemplate>
								<asp:LinkButton runat="server" CommandName="Edit" Text="<%$ Resources:Default, SecurityPanel.EditButtonText %>" CausesValidation="false" Enabled="<%# this.userView.EditIndex == -1 && this.roleView.EditIndex == -1 %>" />
								<asp:LinkButton runat="server" CommandName="Delete" Text="<%$ Resources:Default, SecurityPanel.DeleteButtonText %>" CausesValidation="false" Enabled="<%# this.userView.EditIndex == -1 && this.roleView.EditIndex == -1 %>" />
							</ItemTemplate>
						</asp:TemplateField>
						<asp:TemplateField HeaderText="<%$ Resources:Default, SecurityPanel.UserNameHeaderText %>">
							<ItemTemplate>
								<%# Eval("Name") %></ItemTemplate>
							<EditItemTemplate>
								<asp:TextBox runat="server" ID="NameBox" Text='<%# Eval("Name") %>' />
								<asp:RequiredFieldValidator runat="server" ControlToValidate="NameBox" Text="*" EnableClientScript="false" ValidationGroup="Grid" Display="Dynamic" />
								<asp:CustomValidator runat="server" ControlToValidate="NameBox" Text="*" ValidationGroup="Grid" OnServerValidate="OnNameValidatorServerValidate" Display="Dynamic" />
							</EditItemTemplate>
						</asp:TemplateField>
						<asp:TemplateField HeaderText="<%$ Resources:Default, SecurityPanel.PasswordHeaderText %>">
							<ItemTemplate>
								<%= new string('*', SecurityPanel.EmptyPassword.Length) %></ItemTemplate>
							<EditItemTemplate>
								<asp:Literal runat="server" Text="<%$ Resources:Default, SecurityPanel.EnterPasswordLabelText %>" />
								<asp:PasswordTextBox runat="server" ID="PasswordBox" Text='<%# Eval("Password") %>' autocomplete="off" />
								<asp:RequiredFieldValidator runat="server" ControlToValidate="PasswordBox" Text="*" EnableClientScript="false" ValidationGroup="Grid" Display="Dynamic" /><br />
								<asp:Literal runat="server" Text="<%$ Resources:Default, SecurityPanel.VerifyPasswordLabelText %>" />
								<asp:PasswordTextBox runat="server" ID="VerifyPasswordBox" Text='<%# Eval("Password") %>' autocomplete="off" />
								<asp:CompareValidator runat="server" ControlToValidate="PasswordBox" ControlToCompare="VerifyPasswordBox" Text="*" EnableClientScript="false" ValidationGroup="Grid" Display="Dynamic" />
							</EditItemTemplate>
						</asp:TemplateField>
						<asp:BoundField DataField="PasswordQuestion" HeaderText="<%$ Resources:Default, SecurityPanel.PasswordQuestionHeaderText %>" />
						<asp:BoundField DataField="Comment" HeaderText="<%$ Resources:Default, SecurityPanel.CommentHeaderText %>" />
						<asp:TemplateField HeaderText="<%$ Resources:Default, SecurityPanel.RolesHeaderText %>">
							<ItemTemplate>
								<asp:RepeaterEx runat="server" DataSource='<%# Eval("Roles") %>' />
							</ItemTemplate>
							<EditItemTemplate>
								<asp:RepeaterEx runat="server" DataSource='<%# Eval("EditingRoles") %>' OnItemCommand="OnRepeaterItemCommand">
									<ItemTemplate>
										<%# Container.DataItem %>
										<asp:LinkButton runat="server" CommandName="Delete" Text="[X]" CausesValidation="false" /></ItemTemplate>
								</asp:RepeaterEx>
								<div runat="server" id="rolePanel" ondatabinding="OnRolePanelDataBinding">
									<asp:DropDownList runat="server" ID="roleList" />
									<asp:LinkButton runat="server" Text="<%$ Resources:Default, SecurityPanel.AddButtonText %>" OnClick="OnAddButtonClick" CausesValidation="false" />
								</div>
							</EditItemTemplate>
						</asp:TemplateField>
					</Columns>
				</asp:GridView>
				<asp:LinkButton runat="server" ID="newUserButton" Text="<%$ Resources:Default, SecurityPanel.NewUserButtonText %>" OnClick="OnNewUserButtonClick" CausesValidation="false" />
				<asp:CustomValidator runat="server" ID="userValidator" EnableClientScript="false" OnServerValidate="OnUserValidatorServerValidate" />
			</dd>
		</dl>
		<p runat="server" id="windowsInstructionsPanel" style="color: Red;" innerhtml="<%$ Resources:Default, SecurityPanel.WindowsInstructionsMessage %>" />
	</asp:View>
	<asp:View runat="server">
		<dl>
			<dt runat="server" id="currentAuthenticationTitlePanel" />
			<dd>
				<p runat="server" id="currentAuthenticationDescriptionPanel" />
				<p>
					<asp:Button runat="server" Text="<%$ Resources:Default, SecurityPanel.StayAuthenticationText %>" CommandName="Stay" OnClick="OnAuthenticationButtonClick" /></p>
			</dd>
			<dt runat="server" id="otherAuthenticationTitlePanel" />
			<dd>
				<p runat="server" id="otherAuthenticationDescriptionPanel" />
				<p>
					<asp:Button runat="server" Text="<%$ Resources:Default, SecurityPanel.SwitchAuthenticationKeepText %>" CommandName="Switch" CommandArgument="Keep" OnClick="OnAuthenticationButtonClick" /></p>
				<p>
					<asp:Button runat="server" Text="<%$ Resources:Default, SecurityPanel.SwitchAuthenticationDefaultText %>" CommandName="Switch" CommandArgument="Default" OnClick="OnAuthenticationButtonClick" /></p>
			</dd>
		</dl>
	</asp:View>
</asp:MultiView>