﻿<%@ Page Language="C#" MasterPageFile="~/Default.master" %>

<%@ Register TagPrefix="asp" TagName="MailPanel" Src="~/Mail.ascx" %>
<%@ Register TagPrefix="asp" TagName="LicensePanel" Src="~/License.ascx" %>
<script runat="server">

	protected override void OnLoad(EventArgs e)
	{
		base.OnLoad(e);

		if (!this.IsPostBack)
			this.licensePanel.Refresh();
	}

	protected override void OnPreRender(EventArgs e)
	{
		base.OnPreRender(e);

		var buttonPath = default(string);

		if (this.wizard.ActiveStepIndex == 0)
			buttonPath = "StartNavigationTemplateContainerID$StartNextButton";
		else if (this.wizard.ActiveStepIndex == this.wizard.WizardSteps.Count - 1)
			buttonPath = "FinishNavigationTemplateContainerID$FinishButton";
		else
			buttonPath = "StepNavigationTemplateContainerID$StepNextButton";

		var templateButton = this.wizard.FindControl(buttonPath);

		if (templateButton != null)
			this.Form.DefaultButton = templateButton.UniqueID.Substring(this.Form.UniqueID.Length + 1);
	}

	protected void OnWizardFinishButtonClick(object sender, EventArgs e)
	{
		this.licensePanel.Save();

		var configuration = Elsinore.ScreenConnect.WebConfigurationManager.OpenWebConfiguration();
		var authenticationSection = Elsinore.ScreenConnect.WebConfigurationManager.GetSection<AuthenticationSection>(configuration);
		var roleManagerSection = Elsinore.ScreenConnect.WebConfigurationManager.GetSection<RoleManagerSection>(configuration);
		authenticationSection.Mode = AuthenticationMode.Forms;
		roleManagerSection.DefaultProvider = AuthenticationMode.Forms.ToString();

		var userName = this.userNameBox.GetTrimmedOrNullText();
		var password = this.passwordBox.GetTrimmedOrNullText();
		((IResettable)Membership.Provider).Reset();
		Membership.CreateUser(userName, password);

		var roles = PermissionInfo.GetDefaultRoles(authenticationSection.Mode);
		Permissions.Provider.SaveRoles(roles);

		Roles.Providers[roleManagerSection.DefaultProvider].AddUsersToRoles(new[] { userName }, new[] { PermissionInfo.AdministratorRoleName });

		SetupModule.MarkSetupComplete(configuration);
		ServerToolkit.Instance.SaveConfiguration(configuration);

		FormsAuthentication.SetAuthCookie(userName, true);

		var delaySeconds = ServerToolkit.Instance.GetWebServerReloadDelaySeconds();
		var script = string.Format(JavaScriptFormatter.Default, "SC.ui.addHandler(window, 'load', function() {{ SC.ui.showModalActivityBox({0:js}, {1:js}); }});", Resources.Default.ActivityPanel_Title, Resources.Default.ActivityPanel_LoadingMessage);
		WebExtensions.RegisterPageStartupScript(this, script);
		this.Response.AddHeader("Refresh", string.Format("{0}; URL={1}", delaySeconds, ServerConstants.HostPageUrl));
	}

</script>
<asp:Content runat="server" ContentPlaceHolderID="Main">
	<div class="ContentPanel SetupWizard">
		<form runat="server">
		<asp:ScriptManager runat="server" EnablePartialRendering="true" />
		<h1 runat="server" innerhtml="<%$ Resources:Default, SetupWizard.Heading %>" />
		<asp:UnskippableWizard runat="server" ID="wizard" CssClass="Wizard" SideBarStyle-CssClass="WizardSideBar" NavigationStyle-CssClass="WizardNavigation" StepStyle-CssClass="WizardStep" OnFinishButtonClick="OnWizardFinishButtonClick">
			<WizardSteps>
				<asp:WizardStep runat="server" Title="<%$ Resources:Default, SetupWizard.WelcomeTitle %>">
					<p runat="server" innerhtml="<%$ Resources:Default, SetupWizard.WelcomeMessage1 %>" />
					<p runat="server" innerhtml="<%$ Resources:Default, SetupWizard.WelcomeMessage2 %>" />
				</asp:WizardStep>
				<asp:WizardStep runat="server" Title="<%$ Resources:Default, SetupWizard.SecurityTitle %>">
					<p runat="server" innerhtml="<%$ Resources:Default, SetupWizard.SecurityMessage %>" />
					<dl>
						<dt runat="server" innerhtml="<%$ Resources:Default, SetupWizard.SecurityUserNameMessage %>" />
						<dd>
							<asp:TextBox runat="server" ID="userNameBox" Text="<%$ Resources:Default, SetupWizard.SecurityDefaultUserName %>" />
							<asp:RequiredFieldValidator runat="server" ControlToValidate="userNameBox" Text="*" />
						</dd>
						<dt runat="server" innerhtml="<%$ Resources:Default, SetupWizard.SecurityPasswordMessage %>" />
						<dd>
							<asp:PasswordTextBox runat="server" ID="passwordBox" />
							<asp:RequiredFieldValidator runat="server" ControlToValidate="PasswordBox" Text="*" />
						</dd>
						<dt runat="server" innerhtml="<%$ Resources:Default, SetupWizard.SecurityVerifyPasswordMessage %>" />
						<dd>
							<asp:PasswordTextBox runat="server" ID="verifyPasswordBox" />
							<asp:CompareValidator runat="server" ControlToValidate="passwordBox" ControlToCompare="verifyPasswordBox" Text="*" />
						</dd>
					</dl>
				</asp:WizardStep>
				<asp:WizardStep runat="server" Title="<%$ Resources:Default, SetupWizard.LicenseTitle %>">
					<p runat="server" innerhtml="<%$ Resources:Default, SetupWizard.LicenseMessage %>" />
					<asp:UpdatePanel runat="server" UpdateMode="Conditional">
						<contenttemplate>
							<asp:LicensePanel runat="server" ID="licensePanel" />
						</contenttemplate>
					</asp:UpdatePanel>
				</asp:WizardStep>
				<asp:WizardStep runat="server" Title="<%$ Resources:Default, SetupWizard.FinishTitle %>">
					<p runat="server" innerhtml="<%$ Resources:Default, SetupWizard.FinishMessage1 %>" />
					<p runat="server" innerhtml="<%$ Resources:Default, SetupWizard.FinishMessage2 %>" />
				</asp:WizardStep>
			</WizardSteps>
		</asp:UnskippableWizard>
		</form>
	</div>
</asp:Content>
