﻿<%@ Control Language="C#" CodeFile="Status.ascx.cs" Inherits="Elsinore.ScreenConnect.StatusPanel" EnableViewState="true" %>
<asp:Timer runat="server" ID="timer" Interval="1" />
<asp:StatusTestPanel runat="server" ID="versionCheckPanel" TitleLabelText="<%$ Resources:Default, StatusPanel.VersionCheckHeading %>">
	<AnyResultTemplate>
		<p runat="server" innerhtml="<%$ Resources:Default, StatusPanel.VersionCheckMessage %>" />
		<dl>
			<dt runat="server" innerhtml="<%$ Resources:Default, StatusPanel.YourVersionText %>" />
			<dd>
				<%# ((VersionTestResult)Container.TestData).CheckedVersion %></dd>
			<dt runat="server" innerhtml="<%$ Resources:Default, StatusPanel.LatestVersionText %>" />
			<dd>
				<%# ((VersionTestResult)Container.TestData).LatestVersion %></dd>
			<dt runat="server" innerhtml="<%$ Resources:Default, StatusPanel.LatestEligibleVersionText %>" />
			<dd>
				<%# ((VersionTestResult)Container.TestData).LatestEligibleVersion %></dd>
			<dt runat="server" innerhtml="<%$ Resources:Default, StatusPanel.DownloadLocationText %>" />
			<dd>
				<asp:UriHyperLink runat="server" EnableViewState="false" NavigateUrl="<%# ((VersionTestResult)Container.TestData).DownloadLocation %>" Target="_blank" /></dd>
		</dl>
	</AnyResultTemplate>
</asp:StatusTestPanel>
<asp:StatusTestPanel runat="server" ID="windowsFirewallCheckPanel" TitleLabelText="<%$ Resources:Default, StatusPanel.WindowsFirewallCheckHeading %>">
	<AnyResultTemplate>
		<p runat="server" innerhtml="<%$ Resources:Default, StatusPanel.WindowsFirewallCheckMessage %>" />
		<p runat="server" visible="<%# Container.TestResult == TestResult.Failed %>">
			<asp:LinkButton runat="server" Text="<%$ Resources:Default, StatusPanel.RetestButtonText %>" CommandName="Retry" EnableViewState="false" /></p>
		<dl>
			<dt runat="server" innerhtml="<%$ Resources:Default, StatusPanel.FirewallEnabledText %>" />
			<dd>
				<%# ((WindowsFirewallTestResult)Container.TestData).IsFirewallEnabled %></dd>
			<dt runat="server" innerhtml="<%$ Resources:Default, StatusPanel.WebServerAllowedText %>" />
			<dd>
				<%# ((WindowsFirewallTestResult)Container.TestData).IsWebServerPortAllowed %></dd>
			<dt runat="server" innerhtml="<%$ Resources:Default, StatusPanel.RelayAllowedText %>" />
			<dd>
				<%# ((WindowsFirewallTestResult)Container.TestData).IsRelayPortAllowed %></dd>
		</dl>
	</AnyResultTemplate>
</asp:StatusTestPanel>
<asp:StatusTestPanel runat="server" ID="externalAccessibilityCheckPanel" TitleLabelText="<%$ Resources:Default, StatusPanel.ExternalAccessibilityCheckHeading %>">
	<AnyResultTemplate>
		<p runat="server" innerhtml="<%$ Resources:Default, StatusPanel.ExternalAccessibilityCheckMessage %>" />
		<p runat="server" visible="<%# Container.TestResult == TestResult.Failed %>">
			<asp:LinkButton runat="server" Text="<%$ Resources:Default, StatusPanel.RetestButtonText %>" CommandName="Retry" EnableViewState="false" /></p>
		<dl>
			<dt runat="server" innerhtml="<%$ Resources:Default, StatusPanel.WebServerTestUrlText %>" />
			<dd>
				<asp:UriHyperLink runat="server" EnableViewState="false" NavigateUrl="<%# ((ExternalAccessibilityTestResult)Container.TestData).WebServerUri %>" Target="_blank" /></dd>
			<dt runat="server" innerhtml="<%$ Resources:Default, StatusPanel.WebServerErrorText %>" />
			<dd>
				<%# ((ExternalAccessibilityTestResult)Container.TestData).WebServerErrorMessage %></dd>
			<dt runat="server" innerhtml="<%$ Resources:Default, StatusPanel.RelayTestUrlText %>" />
			<dd>
				<%# ((ExternalAccessibilityTestResult)Container.TestData).RelayUri %></dd>
			<dt runat="server" innerhtml="<%$ Resources:Default, StatusPanel.RelayErrorText %>" />
			<dd>
				<%# ((ExternalAccessibilityTestResult)Container.TestData).RelayErrorMessage %></dd>
		</dl>
	</AnyResultTemplate>
</asp:StatusTestPanel>
<asp:StatusTestPanel runat="server" ID="browserUrlCheckPanel" TitleLabelText="<%$ Resources:Default, StatusPanel.BrowserUrlCheckHeading %>">
	<AnyResultTemplate>
		<p runat="server" innerhtml="<%$ Resources:Default, StatusPanel.BrowserUrlCheckMessage %>" />
		<dl>
			<dt runat="server" innerhtml="<%$ Resources:Default, StatusPanel.BrowsableText %>" />
			<dd>
				<%# ((BrowserUrlTestResult)Container.TestData).IsHostResolvable %></dd>
			</dd>
			<dt runat="server" innerhtml="<%$ Resources:Default, StatusPanel.YourUrlText %>" />
			<dd>
				<asp:UriHyperLink runat="server" NavigateUrl="<%# this.Request.Url %>" Target="_blank" />
			</dd>
			<dt runat="server" innerhtml="<%$ Resources:Default, StatusPanel.PossibleUrlsText %>" />
			<dd>
				<asp:Repeater runat="server" DataSource="<%# ((BrowserUrlTestResult)Container.TestData).AlternateHosts %>" EnableViewState="false">
					<ItemTemplate>
						<p style="margin-bottom: 5px; padding: 0px;">
							<asp:UriHyperLink runat="server" NavigateUrl="<%# (new UriBuilder(this.Request.Url) { Host = (string)Container.DataItem }).Uri %>" Target="_blank" /></p>
					</ItemTemplate>
				</asp:Repeater>
			</dd>
		</dl>
	</AnyResultTemplate>
</asp:StatusTestPanel>
<asp:StatusTestPanel runat="server" ID="webServerCheckPanel" TitleLabelText="<%$ Resources:Default, StatusPanel.WebServerCheckHeading %>">
	<AnyResultTemplate>
		<p runat="server" innerhtml="<%$ Resources:Default, StatusPanel.WebServerCheckMessage %>" />
		<dl>
			<dt runat="server" innerhtml="<%$ Resources:Default, StatusPanel.TestUrlText %>" />
			<dd>
				<asp:UriHyperLink runat="server" EnableViewState="false" NavigateUrl="<%# Container.TestData %>" Target="_blank" /></dd>
		</dl>
	</AnyResultTemplate>
</asp:StatusTestPanel>
<asp:StatusTestPanel runat="server" ID="relayCheckPanel" TitleLabelText="<%$ Resources:Default, StatusPanel.RelayCheckHeading %>">
	<AnyResultTemplate>
		<p runat="server" innerhtml="<%$ Resources:Default, StatusPanel.RelayCheckMessage %>" />
		<dl>
			<dt runat="server" innerhtml="<%$ Resources:Default, StatusPanel.TestUrlText %>" />
			<dd>
				<%# Container.TestData %></dd>
		</dl>
	</AnyResultTemplate>
</asp:StatusTestPanel>
<asp:StatusTestPanel runat="server" ID="sessionManagerCheckPanel" TitleLabelText="<%$ Resources:Default, StatusPanel.SessionManagerCheckHeading %>">
	<AnyResultTemplate>
		<p runat="server" innerhtml="<%$ Resources:Default, StatusPanel.SessionManagerCheckMessage %>" />
		<dl>
			<dt runat="server" innerhtml="<%$ Resources:Default, StatusPanel.TestUrlText %>" />
			<dd>
				<%# Container.TestData %></dd>
		</dl>
	</AnyResultTemplate>
</asp:StatusTestPanel>
