/*
 Copyright (c) 2010, Yahoo! Inc. All rights reserved.
 Code licensed under the BSD License:
 http://developer.yahoo.com/yui/license.html
 version: 3.3.0
 build: 3167
 */
YUI.add('autocomplete-base',function(Y){var Escape=Y.Escape,Lang=Y.Lang,YArray=Y.Array,YObject=Y.Object,isFunction=Lang.isFunction,isString=Lang.isString,trim=Lang.trim,INVALID_VALUE=Y.Attribute.INVALID_VALUE,_FUNCTION_VALIDATOR='_functionValidator',_SOURCE_SUCCESS='_sourceSuccess',ALLOW_BROWSER_AC='allowBrowserAutocomplete',INPUT_NODE='inputNode',QUERY='query',QUERY_DELIMITER='queryDelimiter',REQUEST_TEMPLATE='requestTemplate',RESULTS='results',RESULT_LIST_LOCATOR='resultListLocator',VALUE='value',VALUE_CHANGE='valueChange',EVT_CLEAR='clear',EVT_QUERY=QUERY,EVT_RESULTS=RESULTS;function AutoCompleteBase(){Y.before(this._bindUIACBase,this,'bindUI');Y.before(this._destructorACBase,this,'destructor');Y.before(this._syncUIACBase,this,'syncUI');this.publish(EVT_CLEAR,{defaultFn:this._defClearFn});this.publish(EVT_QUERY,{defaultFn:this._defQueryFn});this.publish(EVT_RESULTS,{defaultFn:this._defResultsFn});}
AutoCompleteBase.ATTRS={allowBrowserAutocomplete:{value:false},allowTrailingDelimiter:{value:false},inputNode:{setter:Y.one,writeOnce:'initOnly'},maxResults:{value:0},minQueryLength:{value:1},query:{readOnly:true,value:null},queryDelay:{value:100},queryDelimiter:{value:null},requestTemplate:{setter:'_setRequestTemplate',value:null},resultFilters:{setter:'_setResultFilters',value:[]},resultFormatter:{validator:_FUNCTION_VALIDATOR},resultHighlighter:{setter:'_setResultHighlighter'},resultListLocator:{setter:'_setLocator'},results:{readOnly:true,value:[]},resultTextLocator:{setter:'_setLocator'},source:{setter:'_setSource'},tokenInput:{readOnly:true},value:{value:''}};AutoCompleteBase.CSS_PREFIX='ac';AutoCompleteBase.UI_SRC=(Y.Widget&&Y.Widget.UI_SRC)||'ui';AutoCompleteBase.prototype={sendRequest:function(query,requestTemplate){var request,source=this.get('source');if(query||query===''){this._set(QUERY,query);}else{query=this.get(QUERY);}
if(source){if(!requestTemplate){requestTemplate=this.get(REQUEST_TEMPLATE);}
request=requestTemplate?requestTemplate(query):query;source.sendRequest({request:request,callback:{success:Y.bind(this._onResponse,this,query)}});}
return this;},_bindUIACBase:function(){var inputNode=this.get(INPUT_NODE),tokenInput=inputNode&&inputNode.tokenInput;if(tokenInput){inputNode=tokenInput.get(INPUT_NODE);this._set('tokenInput',tokenInput);}
if(!inputNode){Y.error('No inputNode specified.');return;}
this._inputNode=inputNode;this._acBaseEvents=[inputNode.on(VALUE_CHANGE,this._onInputValueChange,this),inputNode.on('blur',this._onInputBlur,this),this.after(ALLOW_BROWSER_AC+'Change',this._syncBrowserAutocomplete),this.after(VALUE_CHANGE,this._afterValueChange)];},_destructorACBase:function(){var events=this._acBaseEvents;while(events&&events.length){events.pop().detach();}},_syncUIACBase:function(){this._syncBrowserAutocomplete();this.set(VALUE,this.get(INPUT_NODE).get(VALUE));},_createArraySource:function(source){var that=this;return{sendRequest:function(request){that[_SOURCE_SUCCESS](source.concat(),request);}};},_createFunctionSource:function(source){var that=this;return{sendRequest:function(request){that[_SOURCE_SUCCESS](source(request.request)||[],request);}};},_createObjectSource:function(source){var that=this;return{sendRequest:function(request){var query=request.request;that[_SOURCE_SUCCESS](YObject.owns(source,query)?source[query]:[],request);}};},_functionValidator:function(value){return value===null||isFunction(value);},_getObjectValue:function(obj,path){if(!obj){return;}
for(var i=0,len=path.length;obj&&i<len;i++){obj=obj[path[i]];}
return obj;},_parseResponse:function(query,response,data){var facade={data:data,query:query,results:[]},listLocator=this.get(RESULT_LIST_LOCATOR),results=[],unfiltered=response&&response.results,filters,formatted,formatter,highlighted,highlighter,i,len,maxResults,result,text,textLocator;if(unfiltered&&listLocator){unfiltered=listLocator(unfiltered);}
if(unfiltered&&unfiltered.length){filters=this.get('resultFilters');textLocator=this.get('resultTextLocator');for(i=0,len=unfiltered.length;i<len;++i){result=unfiltered[i];text=textLocator?textLocator(result):result.toString();results.push({display:Escape.html(text),raw:result,text:text});}
for(i=0,len=filters.length;i<len;++i){results=filters[i](query,results.concat());if(!results){return;}
if(!results.length){break;}}
if(results.length){formatter=this.get('resultFormatter');highlighter=this.get('resultHighlighter');maxResults=this.get('maxResults');if(maxResults&&maxResults>0&&results.length>maxResults){results.length=maxResults;}
if(highlighter){highlighted=highlighter(query,results.concat());if(!highlighted){return;}
for(i=0,len=highlighted.length;i<len;++i){result=results[i];result.highlighted=highlighted[i];result.display=result.highlighted;}}
if(formatter){formatted=formatter(query,results.concat());if(!formatted){return;}
for(i=0,len=formatted.length;i<len;++i){results[i].display=formatted[i];}}}}
facade.results=results;this.fire(EVT_RESULTS,facade);},_parseValue:function(value){var delim=this.get(QUERY_DELIMITER);if(delim){value=value.split(delim);value=value[value.length-1];}
return Lang.trimLeft(value);},_setLocator:function(locator){if(this[_FUNCTION_VALIDATOR](locator)){return locator;}
var that=this;locator=locator.toString().split('.');return function(result){return result&&that._getObjectValue(result,locator);};},_setRequestTemplate:function(template){if(this[_FUNCTION_VALIDATOR](template)){return template;}
template=template.toString();return function(query){return Lang.sub(template,{query:encodeURIComponent(query)});};},_setResultFilters:function(filters){var acFilters,getFilterFunction;if(filters===null){return[];}
acFilters=Y.AutoCompleteFilters;getFilterFunction=function(filter){if(isFunction(filter)){return filter;}
if(isString(filter)&&acFilters&&isFunction(acFilters[filter])){return acFilters[filter];}
return false;};if(Lang.isArray(filters)){filters=YArray.map(filters,getFilterFunction);return YArray.every(filters,function(f){return!!f;})?filters:INVALID_VALUE;}else{filters=getFilterFunction(filters);return filters?[filters]:INVALID_VALUE;}},_setResultHighlighter:function(highlighter){var acHighlighters;if(this._functionValidator(highlighter)){return highlighter;}
acHighlighters=Y.AutoCompleteHighlighters;if(isString(highlighter)&&acHighlighters&&isFunction(acHighlighters[highlighter])){return acHighlighters[highlighter];}
return INVALID_VALUE;},_setSource:function(source){var sourcesNotLoaded='autocomplete-sources module not loaded';if((source&&isFunction(source.sendRequest))||source===null){return source;}
switch(Lang.type(source)){case'string':if(this._createStringSource){return this._createStringSource(source);}
Y.error(sourcesNotLoaded);return INVALID_VALUE;case'array':return this._createArraySource(source);case'function':return this._createFunctionSource(source);case'object':if(Y.JSONPRequest&&source instanceof Y.JSONPRequest){if(this._createJSONPSource){return this._createJSONPSource(source);}
Y.error(sourcesNotLoaded);return INVALID_VALUE;}
return this._createObjectSource(source);}
return INVALID_VALUE;},_sourceSuccess:function(data,request){request.callback.success({data:data,response:{results:data}});},_syncBrowserAutocomplete:function(){var inputNode=this.get(INPUT_NODE);if(inputNode.get('nodeName').toLowerCase()==='input'){inputNode.setAttribute('autocomplete',this.get(ALLOW_BROWSER_AC)?'on':'off');}},_updateValue:function(newVal){var delim=this.get(QUERY_DELIMITER),insertDelim,len,prevVal;newVal=Lang.trimLeft(newVal);if(delim){insertDelim=trim(delim);prevVal=YArray.map(trim(this.get(VALUE)).split(delim),trim);len=prevVal.length;if(len>1){prevVal[len-1]=newVal;newVal=prevVal.join(insertDelim+' ');}
newVal=newVal+insertDelim+' ';}
this.set(VALUE,newVal);},_afterValueChange:function(e){var delay,fire,minQueryLength,newVal=e.newVal,query,that;if(e.src!==AutoCompleteBase.UI_SRC){this._inputNode.set(VALUE,newVal);return;}
minQueryLength=this.get('minQueryLength');query=this._parseValue(newVal)||'';if(minQueryLength>=0&&query.length>=minQueryLength){delay=this.get('queryDelay');that=this;fire=function(){that.fire(EVT_QUERY,{inputValue:newVal,query:query});};if(delay){clearTimeout(this._delay);this._delay=setTimeout(fire,delay);}else{fire();}}else{clearTimeout(this._delay);this.fire(EVT_CLEAR,{prevVal:e.prevVal?this._parseValue(e.prevVal):null});}},_onInputBlur:function(e){var delim=this.get(QUERY_DELIMITER),delimPos,newVal,value;if(delim&&!this.get('allowTrailingDelimiter')){delim=Lang.trimRight(delim);value=newVal=this._inputNode.get(VALUE);if(delim){while((newVal=Lang.trimRight(newVal))&&(delimPos=newVal.length-delim.length)&&newVal.lastIndexOf(delim)===delimPos){newVal=newVal.substring(0,delimPos);}}else{newVal=Lang.trimRight(newVal);}
if(newVal!==value){this.set(VALUE,newVal);}}},_onInputValueChange:function(e){var newVal=e.newVal;if(newVal===this.get(VALUE)){return;}
this.set(VALUE,newVal,{src:AutoCompleteBase.UI_SRC});},_onResponse:function(query,e){if(query===this.get(QUERY)){this._parseResponse(query,e.response,e.data);}},_defClearFn:function(){this._set(QUERY,null);this._set(RESULTS,[]);},_defQueryFn:function(e){var query=e.query;this.sendRequest(query);},_defResultsFn:function(e){this._set(RESULTS,e[RESULTS]);}};Y.AutoCompleteBase=AutoCompleteBase;},'3.3.0',{optional:['autocomplete-sources'],requires:['array-extras','base-build','escape','event-valuechange','node-base']});YUI.add('autocomplete-sources',function(Y){var Lang=Y.Lang,_SOURCE_SUCCESS='_sourceSuccess',MAX_RESULTS='maxResults',REQUEST_TEMPLATE='requestTemplate',RESULT_LIST_LOCATOR='resultListLocator';function ACSources(){}
ACSources.prototype={_YQL_SOURCE_REGEX:/^(?:select|set|use)\s+/i,_createIOSource:function(source){var cache={},ioSource={},that=this,ioRequest,lastRequest,loading;ioSource.sendRequest=function(request){var _sendRequest=function(request){var query=request.request,maxResults,requestTemplate,url;if(cache[query]){that[_SOURCE_SUCCESS](cache[query],request);}else{maxResults=that.get(MAX_RESULTS);requestTemplate=that.get(REQUEST_TEMPLATE);url=source;if(requestTemplate){url+=requestTemplate(query);}
url=Lang.sub(url,{maxResults:maxResults>0?maxResults:1000,query:encodeURIComponent(query)});if(ioRequest&&ioRequest.isInProgress()){ioRequest.abort();}
ioRequest=Y.io(url,{on:{success:function(tid,response){var data;try{data=Y.JSON.parse(response.responseText);}catch(ex){Y.error('JSON parse error',ex);}
if(data){cache[query]=data;that[_SOURCE_SUCCESS](data,request);}}}});}};lastRequest=request;if(!loading){loading=true;Y.use('io-base','json-parse',function(){ioSource.sendRequest=_sendRequest;_sendRequest(lastRequest);});}};return ioSource;},_createJSONPSource:function(source){var cache={},jsonpSource={},that=this,lastRequest,loading;jsonpSource.sendRequest=function(request){var _sendRequest=function(request){var query=request.request;if(cache[query]){that[_SOURCE_SUCCESS](cache[query],request);}else{source._config.on.success=function(data){cache[query]=data;that[_SOURCE_SUCCESS](data,request);};source.send(query);}};lastRequest=request;if(!loading){loading=true;Y.use('jsonp',function(){if(!(source instanceof Y.JSONPRequest)){source=new Y.JSONPRequest(source,{format:Y.bind(that._jsonpFormatter,that)});}
jsonpSource.sendRequest=_sendRequest;_sendRequest(lastRequest);});}};return jsonpSource;},_createStringSource:function(source){if(this._YQL_SOURCE_REGEX.test(source)){return this._createYQLSource(source);}else if(source.indexOf('{callback}')!==-1){return this._createJSONPSource(source);}else{return this._createIOSource(source);}},_createYQLSource:function(source){var cache={},yqlSource={},that=this,lastRequest,loading;if(!this.get(RESULT_LIST_LOCATOR)){this.set(RESULT_LIST_LOCATOR,this._defaultYQLLocator);}
yqlSource.sendRequest=function(request){var yqlRequest,_sendRequest=function(request){var query=request.request,callback,env,maxResults,opts,yqlQuery;if(cache[query]){that[_SOURCE_SUCCESS](cache[query],request);}else{callback=function(data){cache[query]=data;that[_SOURCE_SUCCESS](data,request);};env=that.get('yqlEnv');maxResults=that.get(MAX_RESULTS);opts={proto:that.get('yqlProtocol')};yqlQuery=Lang.sub(source,{maxResults:maxResults>0?maxResults:1000,query:query});if(yqlRequest){yqlRequest._callback=callback;yqlRequest._opts=opts;yqlRequest._params.q=yqlQuery;if(env){yqlRequest._params.env=env;}}else{yqlRequest=new Y.YQLRequest(yqlQuery,{on:{success:callback},allowCache:false},env?{env:env}:null,opts);}
yqlRequest.send();}};lastRequest=request;if(!loading){loading=true;Y.use('yql',function(){yqlSource.sendRequest=_sendRequest;_sendRequest(lastRequest);});}};return yqlSource;},_defaultYQLLocator:function(response){var results=response&&response.query&&response.query.results,values;if(results&&Lang.isObject(results)){values=Y.Object.values(results)||[];results=values.length===1?values[0]:values;if(!Lang.isArray(results)){results=[results];}}else{results=[];}
return results;},_jsonpFormatter:function(url,proxy,query){var maxResults=this.get(MAX_RESULTS),requestTemplate=this.get(REQUEST_TEMPLATE);if(requestTemplate){url+=requestTemplate(query);}
return Lang.sub(url,{callback:proxy,maxResults:maxResults>0?maxResults:1000,query:encodeURIComponent(query)});}};ACSources.ATTRS={yqlEnv:{value:null},yqlProtocol:{value:'http'}};Y.Base.mix(Y.AutoCompleteBase,[ACSources]);},'3.3.0',{optional:['io-base','json-parse','jsonp','yql'],requires:['autocomplete-base']});YUI.add('autocomplete-list',function(Y){var Lang=Y.Lang,Node=Y.Node,YArray=Y.Array,KEY_TAB=9,_CLASS_ITEM='_CLASS_ITEM',_CLASS_ITEM_ACTIVE='_CLASS_ITEM_ACTIVE',_CLASS_ITEM_HOVER='_CLASS_ITEM_HOVER',_SELECTOR_ITEM='_SELECTOR_ITEM',ACTIVE_ITEM='activeItem',ALWAYS_SHOW_LIST='alwaysShowList',CIRCULAR='circular',HOVERED_ITEM='hoveredItem',ID='id',ITEM='item',LIST='list',RESULT='result',RESULTS='results',VISIBLE='visible',WIDTH='width',EVT_SELECT='select',List=Y.Base.create('autocompleteList',Y.Widget,[Y.AutoCompleteBase,Y.WidgetPosition,Y.WidgetPositionAlign,Y.WidgetStack],{ARIA_TEMPLATE:'<div/>',ITEM_TEMPLATE:'<li/>',LIST_TEMPLATE:'<ul/>',initializer:function(){var inputNode=this.get('inputNode');if(!inputNode){Y.error('No inputNode specified.');return;}
this._inputNode=inputNode;this._listEvents=[];this.DEF_PARENT_NODE=inputNode.get('parentNode');this[_CLASS_ITEM]=this.getClassName(ITEM);this[_CLASS_ITEM_ACTIVE]=this.getClassName(ITEM,'active');this[_CLASS_ITEM_HOVER]=this.getClassName(ITEM,'hover');this[_SELECTOR_ITEM]='.'+this[_CLASS_ITEM];this.publish(EVT_SELECT,{defaultFn:this._defSelectFn});},destructor:function(){while(this._listEvents.length){this._listEvents.pop().detach();}},bindUI:function(){this._bindInput();this._bindList();},renderUI:function(){var ariaNode=this._createAriaNode(),contentBox=this.get('contentBox'),inputNode=this._inputNode,listNode,parentNode=inputNode.get('parentNode');listNode=this._createListNode();this._set('listNode',listNode);contentBox.append(listNode);inputNode.addClass(this.getClassName('input')).setAttrs({'aria-autocomplete':LIST,'aria-expanded':false,'aria-owns':listNode.get('id'),role:'combobox'});parentNode.append(ariaNode);this._ariaNode=ariaNode;this._boundingBox=this.get('boundingBox');this._contentBox=contentBox;this._listNode=listNode;this._parentNode=parentNode;},syncUI:function(){this._syncResults();this._syncVisibility();},hide:function(){return this.get(ALWAYS_SHOW_LIST)?this:this.set(VISIBLE,false);},selectItem:function(itemNode){if(itemNode){if(!itemNode.hasClass(this[_CLASS_ITEM])){return this;}}else{itemNode=this.get(ACTIVE_ITEM);if(!itemNode){return this;}}
this.fire(EVT_SELECT,{itemNode:itemNode,result:itemNode.getData(RESULT)});return this;},_activateNextItem:function(){var item=this.get(ACTIVE_ITEM),nextItem;if(item){nextItem=item.next(this[_SELECTOR_ITEM])||(this.get(CIRCULAR)?null:item);}else{nextItem=this._getFirstItemNode();}
this.set(ACTIVE_ITEM,nextItem);return this;},_activatePrevItem:function(){var item=this.get(ACTIVE_ITEM),prevItem=item?item.previous(this[_SELECTOR_ITEM]):this.get(CIRCULAR)&&this._getLastItemNode();this.set(ACTIVE_ITEM,prevItem||null);return this;},_add:function(items){var itemNodes=[];YArray.each(Lang.isArray(items)?items:[items],function(item){itemNodes.push(this._createItemNode(item).setData(RESULT,item));},this);itemNodes=Y.all(itemNodes);this._listNode.append(itemNodes.toFrag());return itemNodes;},_ariaSay:function(stringId,subs){var message=this.get('strings.'+stringId);this._ariaNode.setContent(subs?Lang.sub(message,subs):message);},_bindInput:function(){var inputNode=this._inputNode,alignNode,alignWidth,tokenInput;if(this.get('align')===null){tokenInput=this.get('tokenInput');alignNode=(tokenInput&&tokenInput.get('boundingBox'))||inputNode;this.set('align',{node:alignNode,points:['tl','bl']});if(!this.get(WIDTH)&&(alignWidth=alignNode.get('offsetWidth'))){this.set(WIDTH,alignWidth);}}
this._listEvents.push(inputNode.on('blur',this._onListInputBlur,this));},_bindList:function(){this._listEvents.concat([this.after({mouseover:this._afterMouseOver,mouseout:this._afterMouseOut,activeItemChange:this._afterActiveItemChange,alwaysShowListChange:this._afterAlwaysShowListChange,hoveredItemChange:this._afterHoveredItemChange,resultsChange:this._afterResultsChange,visibleChange:this._afterVisibleChange}),this._listNode.delegate('click',this._onItemClick,this[_SELECTOR_ITEM],this)]);},_clear:function(){this.set(ACTIVE_ITEM,null);this._set(HOVERED_ITEM,null);this._listNode.get('children').remove(true);},_createAriaNode:function(){var ariaNode=Node.create(this.ARIA_TEMPLATE);return ariaNode.addClass(this.getClassName('aria')).setAttrs({'aria-live':'polite',role:'status'});},_createItemNode:function(result){var itemNode=Node.create(this.ITEM_TEMPLATE);return itemNode.addClass(this[_CLASS_ITEM]).setAttrs({id:Y.stamp(itemNode),role:'option'}).setAttribute('data-text',result.text).append(result.display);},_createListNode:function(){var listNode=Node.create(this.LIST_TEMPLATE);return listNode.addClass(this.getClassName(LIST)).setAttrs({id:Y.stamp(listNode),role:'listbox'});},_getFirstItemNode:function(){return this._listNode.one(this[_SELECTOR_ITEM]);},_getLastItemNode:function(){return this._listNode.one(this[_SELECTOR_ITEM]+':last-child');},_syncResults:function(results){var items;if(!results){results=this.get(RESULTS);}
this._clear();if(results.length){items=this._add(results);this._ariaSay('items_available');}
if(this.get('activateFirstItem')&&!this.get(ACTIVE_ITEM)){this.set(ACTIVE_ITEM,this._getFirstItemNode());}},_syncVisibility:function(visible){if(this.get(ALWAYS_SHOW_LIST)){visible=true;this.set(VISIBLE,visible);}
if(typeof visible==='undefined'){visible=this.get(VISIBLE);}
this._inputNode.set('aria-expanded',visible);this._boundingBox.set('aria-hidden',!visible);if(visible){this._syncUIPosAlign();}else{this.set(ACTIVE_ITEM,null);this._set(HOVERED_ITEM,null);this._boundingBox.get('offsetWidth');}},_afterActiveItemChange:function(e){var inputNode=this._inputNode,newVal=e.newVal,prevVal=e.prevVal;if(prevVal&&prevVal._node){prevVal.removeClass(this[_CLASS_ITEM_ACTIVE]);}
if(newVal){newVal.addClass(this[_CLASS_ITEM_ACTIVE]);inputNode.set('aria-activedescendant',newVal.get(ID));}else{inputNode.removeAttribute('aria-activedescendant');}
if(this.get('scrollIntoView')){(newVal||inputNode).scrollIntoView();}},_afterAlwaysShowListChange:function(e){this.set(VISIBLE,e.newVal||this.get(RESULTS).length>0);},_afterHoveredItemChange:function(e){var newVal=e.newVal,prevVal=e.prevVal;if(prevVal){prevVal.removeClass(this[_CLASS_ITEM_HOVER]);}
if(newVal){newVal.addClass(this[_CLASS_ITEM_HOVER]);}},_afterMouseOver:function(e){var itemNode=e.domEvent.target.ancestor(this[_SELECTOR_ITEM],true);this._mouseOverList=true;if(itemNode){this._set(HOVERED_ITEM,itemNode);}},_afterMouseOut:function(){this._mouseOverList=false;this._set(HOVERED_ITEM,null);},_afterResultsChange:function(e){this._syncResults(e.newVal);if(!this.get(ALWAYS_SHOW_LIST)){this.set(VISIBLE,!!e.newVal.length);}},_afterVisibleChange:function(e){this._syncVisibility(!!e.newVal);},_onListInputBlur:function(e){if(!this._mouseOverList||this._lastInputKey===KEY_TAB){this.hide();}},_onItemClick:function(e){var itemNode=e.currentTarget;this.set(ACTIVE_ITEM,itemNode);this.selectItem(itemNode);},_defSelectFn:function(e){var text=e.result.text;this._inputNode.focus();this._updateValue(text);this._ariaSay('item_selected',{item:text});this.hide();}},{ATTRS:{activateFirstItem:{value:false},activeItem:{setter:Y.one,value:null},alwaysShowList:{value:false},circular:{value:true},hoveredItem:{readOnly:true,value:null},listNode:{readOnly:true,value:null},scrollIntoView:{value:false},strings:{valueFn:function(){return Y.Intl.get('autocomplete-list');}},tabSelect:{value:true},visible:{value:false}},CSS_PREFIX:Y.ClassNameManager.getClassName('aclist')});Y.AutoCompleteList=List;Y.AutoComplete=List;},'3.3.0',{lang:['en'],requires:['autocomplete-base','selector-css3','widget','widget-position','widget-position-align','widget-stack'],after:['autocomplete-sources'],skinnable:true});YUI.add('autocomplete-plugin',function(Y){var Plugin=Y.Plugin;function ACListPlugin(config){config.inputNode=config.host;if(!config.render&&config.render!==false){config.render=true;}
ACListPlugin.superclass.constructor.apply(this,arguments);}
Y.extend(ACListPlugin,Y.AutoCompleteList,{},{NAME:'autocompleteListPlugin',NS:'ac',CSS_PREFIX:Y.ClassNameManager.getClassName('aclist')});Plugin.AutoComplete=ACListPlugin;Plugin.AutoCompleteList=ACListPlugin;},'3.3.0',{requires:['autocomplete-list','node-pluginhost']});YUI.add('autocomplete',function(Y){},'3.3.0',{use:['autocomplete-base','autocomplete-sources','autocomplete-list','autocomplete-plugin']});