<?php if (!empty($_SERVER['SCRIPT_FILENAME']) && 'comments.php' == basename($_SERVER['SCRIPT_FILENAME'])) { die ('Please do not load this page directly.'); } ?>
<?php if (post_password_required()) { ?>
	<p class="nocomments">This post is password protected. Enter the password to view comments.</p>
<?php return; ?>
<?php } ?>
<?php if (have_comments()) { ?>
	<div id="comments">
		<h2>User Comments - <?php print trimString(get_the_title(), 35, true); ?></h2>
		<?php foreach ($comments as $comment) { ?>
			<?php $comment_type = get_comment_type(); ?>
			<?php if($comment_type == 'comment') { ?>
				<div class="comment">
					<div class="comment-meta">Posted on <?php comment_date('jS F Y') ?> - <?php comment_time()?> by <?php comment_author()?></div>
					<?php if ($comment->comment_approved == '0') { ?>
						<div class="comment-moderation">Your comment is awaiting moderation.</div>
					<?php } ?>
					<div class="comment-text"><?php comment_text(); ?></div>
				</div>
			<?php } else { ?>
				<?php $trackback = true; ?>
			<?php } ?>
		<?php } ?>
	</div><!-- END #comments -->
	<?php if ($trackback == true) { ?>
		<div id="trackbacks">
			<h3>Trackbacks</h3>
			<ul>
			<?php foreach ($comments as $comment) { ?>
				<?php if(get_comment_type() != 'comment') { ?>
					<li><?php comment_author_link() ?></li>
				<?php } ?>
			<?php } ?>
			</ul>
		</div><!-- END #trackbacks -->
	<?php } ?>
<?php } ?>
<div id="reply">
	<?php if (comments_open()) { ?>
			<h3>Post a new Comment</h3>
			<?php if (get_option('comment_registration') && !is_user_logged_in()) { ?>
				<p>Sorry, but you must be <a href="<?php echo wp_login_url( get_permalink() ); ?>">logged in</a> to post a comment.</p>
			<?php } else { ?>
				<form action="<?php echo get_option('siteurl'); ?>/wp-comments-post.php" method="post">
					<?php if ( is_user_logged_in() ) { ?>
						<p>Logged in as <a href="<?php echo get_option('siteurl'); ?>/wp-admin/profile.php"><?php echo $user_identity; ?></a>. <a href="<?php echo wp_logout_url(get_permalink()); ?>" title="Log out of this account">Log out</a> &raquo;</p>
					<?php } else { ?>
						<div class="author input"><label>Name:<?php if ($req) { ?><span class="required">*</span><?php } ?></label><input type="text" name="author" value="<?php echo esc_attr($comment_author); ?>" /></div>
						<div class="email input"><label>Email:<?php if ($req) { ?><span class="required">*</span><?php } ?></label><input type="text" name="email" value="<?php echo esc_attr($comment_author_email); ?>" /></div>
						<div class="url input"><label>Website:</label><input type="text" name="url" value="<?php echo esc_attr($comment_author_url); ?>" /></div>
					<?php } ?>
						<div class="input"><textarea name="comment" rows="10"></textarea></div>
						<p>All comments are moderated for off-topic, explicit and offensive content.</p>
						<p><input name="submit" type="submit" class="form-submit" value="Submit Comment" /><?php comment_id_fields(); ?></p>
					<?php do_action('comment_form', $post->ID); ?>
				</form>
			<?php } ?>
	<?php } else { ?>
		<p class="nocomments">Comments are closed.</p>
	<?php } ?>
</div><!-- END #reply -->