<?php
	
	//Set up the theme name...
	$themeName = 'IK Design';
	
	//Set up the theme options...
	$themeOptions = array(
		array('name' => 'Show Blog Title', 'id' => 'il_show_title', 'type' => 'checkbox'),
		array('name' => 'Show Blog Tagline', 'id' => 'il_show_tagline', 'type' => 'checkbox'),
		array('name' => 'Custom Header Image', 'id' => 'il_custom_header', 'type' => 'checkbox'),
		array('name' => 'Home Heading (H1)', 'id' => 'il_home_heading', 'type' => 'text'),
		array('name' => 'Home Content (HTML - Inline Tags Only)', 'id' => 'il_home_content', 'type' => 'textarea'),
		array('name' => 'Enquiry Form Page ID', 'id' => 'il_enquiry_page', 'type' => 'text'),
		array('name' => 'Enquiry Form Recipient', 'id' => 'il_enquiry_email', 'type' => 'text'),
		array('name' => 'Google Ad Client', 'id' => 'il_google_client', 'type' => 'text'),
		array('name' => 'Google Ad Channel', 'id' => 'il_google_channel', 'type' => 'text'),
		array('name' => 'Twitter Screen Name', 'id' => 'il_twitter_screenname', 'type' => 'text'),
		array('name' => 'Twitter Tweet Count', 'id' => 'il_twitter_count', 'type' => 'text'),
		array('id' => 'il_footer_1_text_1'),
		array('id' => 'il_footer_1_url_1'),
		array('id' => 'il_footer_1_text_2'),
		array('id' => 'il_footer_1_url_2'),
		array('id' => 'il_footer_2_text_1'),
		array('id' => 'il_footer_2_url_1'),
		array('id' => 'il_footer_2_text_2'),
		array('id' => 'il_footer_2_url_2')
	);
	
	//Function to setup the theme admin...
	function ikdesign_add_admin() {
		global $themeName, $shortName, $themeOptions;
		if ($_GET['page'] == basename(__FILE__)) {
			if ($_REQUEST['action'] == 'save') {
				foreach ($themeOptions as $value) {
					update_option($value['id'], $_REQUEST[$value['id']]);
				}
				foreach ($themeOptions as $value) {
					if(isset($_REQUEST[$value['id']])) {
						update_option($value['id'], $_REQUEST[$value['id']]);
					} else {
						delete_option($value['id']);
					}
				}
				header("Location: themes.php?page=functions.php&saved=true");
				die;
			}
		}
		add_theme_page($themeName . ' Options', $themeName . ' Options', 'edit_themes', basename(__FILE__), 'ikdesign_admin');
	}
	
	//Function to write the options page...
	function ikdesign_admin() {
		global $themeName, $shortName, $themeOptions;
		if ($_REQUEST['saved']) { print '<div id="message" class="updated fade"><p><strong>' . $themeName . ' settings saved.</strong></p></div>'; }
		if ($_REQUEST['reset']) { print '<div id="message" class="updated fade"><p><strong>' . $themeName . ' settings reset.</strong></p></div>'; }
		$themeHtml = '<div><h2>' . $themeName . ' Settings</h2><form method="post">';
		foreach ($themeOptions as $option) {
			if ($option['type'] == 'text') {
				$themeHtml .= '<h3>' . $option['name'] . '</h3><p><input style="width: 700px;" name="' . $option['id'] . '" type="' . $option['type'] . '" value="' . stripslashes(get_option($option['id'])) . '" /></p>';
			} else if ($option['type'] == 'textarea') {
				$themeHtml .= '<h3>' . $option['name'] . '</h3><p><textarea style="width: 700px;" rows="10" name="' . $option['id'] . '">' . stripslashes(get_option($option['id'])) . '</textarea></p>';
			} else if ($option['type'] == 'checkbox') {
				$themeHtml .= '<p><input name="' . $option['id'] . '" type="' . $option['type'] . '" value="true" ' . (get_option($option['id']) ? 'checked="checked"' : '') . ' /> - ' . $option['name'] . '</p>';
			}
		}
		$themeHtml .= '<h3>Footer Link 1</h3>';
		$themeHtml .= '<p>Text:<input style="width: 200px;" name="il_footer_1_text_1" type="text" value="' . get_option('il_footer_1_text_1') . '" /> by <input style="width: 200px;" name="il_footer_1_text_2" type="text" value="' . get_option('il_footer_1_text_2') . '" />';
		$themeHtml .= '<p>URL:<input style="width: 200px;" name="il_footer_1_url_1" type="text" value="' . get_option('il_footer_1_url_1') . '" /> by <input style="width: 200px;" name="il_footer_1_url_2" type="text" value="' . get_option('il_footer_1_url_2') . '" />';
		$themeHtml .= '<h3>Footer Link 2</h3>';
		$themeHtml .= '<p>Text:<input style="width: 200px;" name="il_footer_2_text_1" type="text" value="' . get_option('il_footer_2_text_1') . '" /> by <input style="width: 200px;" name="il_footer_2_text_2" type="text" value="' . get_option('il_footer_2_text_2') . '" />';
		$themeHtml .= '<p>URL:<input style="width: 200px;" name="il_footer_2_url_1" type="text" value="' . get_option('il_footer_2_url_1') . '" /> by <input style="width: 200px;" name="il_footer_2_url_2" type="text" value="' . get_option('il_footer_2_url_2') . '" />';
		$themeHtml .= '<p class="submit"><input name="save" type="submit" value="Save changes" /><input type="hidden" name="action" value="save" /></p></form></div>';
		print $themeHtml;
	}
	
	//Add the admin options...
	add_action('admin_menu', 'ikdesign_add_admin');
	
	//Function to construct a Google Ad...
	function getGoogleAd($width = 468, $height = 60, $sidebar = false) {
		
		//If google adsense has been enabled...
		if (get_option('il_google_client') && get_option('il_google_channel')) {
			
			//Construct the adsense code...
			$adsense = '<div class="google-adsense"><script type="text/javascript">' ."\r\n";
			$adsense .= '<!--' ."\r\n";
			$adsense .= 'google_ad_client = "' . get_option('il_google_client') . '";' ."\r\n";
			$adsense .= 'google_ad_channel = "' . get_option('il_google_channel') .'";' ."\r\n";
			$adsense .= 'google_ad_width = ' . $width .';' ."\r\n";
			$adsense .= 'google_ad_height = ' . $height .';' ."\r\n";
			$adsense .= 'google_ad_format = "' . $width . 'x' . $height .'_as";' ."\r\n";
			$adsense .= 'google_ad_type= "text";' ."\r\n";
			$adsense .= '//-->' ."\r\n";
			$adsense .= '</script><script type="text/javascript" src="' . get_bloginfo('stylesheet_directory') . '/google' . ($sidebar ? '-sidebar' : '') . '.js"></script><script type="text/javascript" src="http://pagead2.googlesyndication.com/pagead/show_ads.js"></script></div>';
			
			//Add the adsense to the bottom of the content...
			return $adsense;
			
		//If no ads are enabled...
		} else {
			
			return false;
			
		}
		
	}
	
	//Function to trim a string...
	function trimString($string, $length, $ellipsis) {
		
		//Strip all html from the string...
		$newString = strip_tags($string);
		
		//If the supplied string is longer than the requested length...
		if (strlen($newString) > $length) {
			
			//Trim the string to the requested length...
			$newString = subStr($newString, 0, $length);
			
			//If an ellipsis was requested...
			if ($ellipsis == true) {
				
				//Add an ellipsis...
				$newString .= '...';
				
			}
			
		}
		
		//Return the trimmed string...
		return $newString;
		
	}
	
	//Function to fomat a string into paragraphs...
	function paragraphString($string, $allow_tags = false) {
		
		//Strip escaping slashes...
		$newString = stripslashes($string);
		
		//If there is allowed tags...
		if ($allow_tags) {
			
			//Trim spacing and allow tags...
			$newString = trim(strip_tags($newString, '<span> <a> <em> <strong> <i> <b>'));
			
		} else {
		
			//Strip all html and trim spacing and replace entities...
			$newString = trim(htmlentities(strip_tags($newString)));
		
		}
		
		//Special character replacements...
		$strReplace = array("'", "'", '"', '"', '-');
		
		//Special characters...
		$strSearch = array(chr(145), chr(146), chr(147), chr(148), chr(151)); 
		
		//Replace special characters...
		$newString = str_replace($strSearch, $strReplace, $newString);
		
		//Replace any double linebreaks with paragraphs...
		$newString = str_replace("\r\n\r\n", '</p><p>', $newString);
		
		//Replace any single linebreaks with paragraphs...
		$newString = str_replace("\r\n", '<br />', $newString);
		
		//Add the surrounding p tags...
		$newString = ('<p>' . $newString . '</p>');
		
		//Return the formatted string...
		return $newString;
		
	}
	
	//Function to get the content and replace placeholder tokens with blog variables...
	function get_post_content($teaser = false) {
		
		//Replace all blog name tokens with the blog name...
		$content = str_replace('%blogname%', get_bloginfo('name'), ($teaser ? get_the_excerpt() : get_the_content()));
		
		//Filter the content like 'the_content()' function...
		$content = apply_filters('the_content', $content);
		$content = str_replace(']]>', ']]&gt;', $content);
		
		//If it's only teaser text...
		if ($teaser) {
			
			//Strip out all line breaks...
			$content = str_replace('<br>', '', $content);
			$content = str_replace('<br/>', '', $content);
			$content = str_replace('<br />', '', $content);
			
			//Add a read more link...
			$content .= '<p class="more">Read more of <a href="' . get_permalink() . '">' . get_the_title() . '</a> &raquo;</p>';
			
		//If it's not teaser text...
		} else {
			
			//Add the adsense to the bottom of the content...
			$content .= getGoogleAd();
			
		}
		
		//Return the token-ed content...
		return $content;
		
	}
	
	//Function to see if navigation is required...
	function needNavigation() {
		
		//Get the page query...
		global $wp_query;
		
		//If more than one page...
		if ($wp_query->max_num_pages > 1) {
			
			//Navigation required...
			return true;
			
		//Otherwise...
		} else {
			
			//No navigation required...
			return false;
			
		}
		
	}
	
	//Register the sidebar...
	if (function_exists('register_sidebar')) {
		
		register_sidebar();
		
	}
	
?>