<?php
	
	//Include the browser detection file...
	require_once('includes/browser.php');
	
	//Define a new browser object...
	$browser = new Browser();
	
	//Get the browser version...
	$browserVersion = substr($browser->getVersion(), 0, strpos($browser->getVersion(), '.'));
	
	//Get the browser name...
	if($browser->getBrowser() == Browser::BROWSER_IE) {
		$browserName = 'IE';
	} else if($browser->getBrowser() == Browser::BROWSER_FIREFOX) {
		$browserName = 'FF';
	} else if($browser->getBrowser() == Browser::BROWSER_SAFARI) {
		$browserName = 'SF';
	} else if($browser->getBrowser() == Browser::BROWSER_CHROME) {
		$browserName = 'CH';
	}
	
	//Compile a new class string, and append it to the BODY tag classes...
	$browserInfo = ($browserName ? $browserName : 'X') . ($browserVersion ? ' ' . $browserName . $browserVersion : '');
	
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" <?php language_attributes(); ?>>
	<head>
		<meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php bloginfo('charset'); ?>" />
		<title><?php wp_title('-', true, 'right'); ?><?php bloginfo('name') ?></title>
		<link rel="stylesheet" href="<?php bloginfo('stylesheet_url'); ?>" type="text/css" media="screen" />
		<link rel="alternate" type="application/rss+xml" title="<?php bloginfo('name'); ?> RSS Feed" href="<?php bloginfo('rss2_url'); ?>" />
		<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />
		<?php wp_head(); ?>
		<link rel="stylesheet" href="<?php print get_bloginfo('template_url') . '/scripts/fancybox/jquery.fancybox-1.3.1.css'; ?>" type="text/css" media="screen" />
		<script type="text/javascript" src="<?php print get_bloginfo('template_url') . '/scripts/jquery-1.4.2.min.js'; ?>"></script>
		<script type="text/javascript" src="<?php print get_bloginfo('template_url') . '/scripts/jquery.cycle.min.js'; ?>"></script>
		<script type="text/javascript" src="<?php print get_bloginfo('template_url') . '/scripts/fancybox/jquery.fancybox-1.3.1.pack.js'; ?>"></script>
		<script type="text/javascript" src="<?php print get_bloginfo('template_url') . '/scripts/scripts.js'; ?>"></script>
	</head>
	<body class="<?php print $browserInfo; ?>">
		<div id="page">
			<div id="header"<?php print (get_option('il_custom_header') ? ' style="background-image: url(\'' . get_bloginfo('template_directory') . '/content/header.png\');"' : '') ?>>
				<div id="title">
					<?php if (get_option('il_show_title')) { ?>
						<div id="name"><a href="<?php print get_option('home'); ?>/" title="<?php bloginfo('description'); ?>"><?php bloginfo('name'); ?></a></div>
					<?php } ?>
					<?php if (get_option('il_show_tagline') && get_bloginfo('description')) { ?>
						<div id="description"><?php bloginfo('description'); ?></div>
					<?php } ?>
					<div class="clear"></div>
				</div><!-- END #title -->
				<div id="navigation">
					<?php wp_page_menu('show_home=1'); ?>
					<div class="clear"></div>
				</div><!-- END #navigation -->
			</div><!-- END #header -->
			<div id="wrapper">