<?php
	
	/*
	
	MailGate - (MODIFIED WP VERSION)
	
	*/
	
?>
<a name="enquiry"></a>
<?php
	
	//Function to strip slashes from data for user readability...
	function cleanSlashes($data) {
		
		//Strip the slashes...
		$data = stripslashes($data);
		
		//Return the tidy string...
		return $data;
		
	}
	
	//Function to clean out spaces from a string...
	function cleanSpaces($string) {
		
		//Strip the spaces...
		$string = str_replace(' ','-',$string);
		
		//Return the dashed string...
		return $string;
		
	}
	
	//Function to check a string for spam characteristics...
	function checkSpam($name, $string) {
		
		//Make a control variable...
		$strOriginal = $string . ' ';
		
		//Make a check variable...
		$strCheck = $string . ' ';
		
		//Strip html tags...
		$strCheck = strip_tags($strCheck);
		
		//If the string contains html, mark it as spam...
		$strHTML = ($strOriginal == $strCheck ? false : true);
		
		//The banned protocol list...
		$arrProtocol = array('http://', 'https://', 'ftp://', 'ftps://', 'www.');
		
		//Check banned protocol occurances...
		foreach ($arrProtocol as $protocol) {
			
			//If a banned protocol was found, mark the string as spam...
			$strProtocol = (substr_count(strtolower($strOriginal), strtolower($protocol)) >= 1 ? true : false);
			
			//If a banned protocol was found, exit the loop...
			if ($strProtocol) { break; }
			
		}
		
		//The banned word list...
		$arrBanned = array('4r5e', '5h1t', '5hit', 'a55', 'anal', 'ar5e', 'arrse', 'arse', 'ass', 'ass-fucker', 'assfucker', 'assfukka', 'asshole', 'asswhole', 'b!tch', 'b00bs', 'b17ch', 'b1tch', 'ballbag', 'balls', 'ballsack', 'bastard', 'beastiality', 'bi+ch', 'bitch', 'bloody', 'blowjob', 'boiolas', 'boobs', 'booobs', 'boooobs', 'booooobs', 'booooooobs', 'breasts', 'buceta', 'bunny fucker', 'buttmuch', 'c0ck', 'c0cksucker', 'cawk', 'chink', 'cialis', 'cipa', 'cl1t', 'clit', 'clit', 'clits', 'cnut', 'cock', 'cock-sucker', 'cockface', 'cockhead', 'cockmunch', 'cockmuncher', 'cocksucker', 'cocksuka', 'cocksukka', 'cok', 'cokmuncher', 'coksucka', 'cox', 'cum', 'cunt', 'cyalis', 'd1ck', 'dick', 'dickhead', 'dildo', 'dirsa', 'dlck', 'dog-fucker', 'doggin', 'dogging', 'donkeyribber', 'doosh', 'duche', 'ejakulate', 'f u c k e r', 'f4nny', 'fag', 'faggitt', 'faggot', 'fanny', 'fannyflaps', 'fannyfucker', 'fanyy', 'fatass', 'fcuk', 'fcuker', 'fcuking', 'feck', 'fecker', 'fook', 'fooker', 'fuck', 'fucka', 'fucker', 'fuckhead', 'fuckin', 'fucking', 'fuckingshitmotherfucker', 'fuckwhit', 'fuckwit', 'fuk', 'fuker', 'fukker', 'fukkin', 'fukwhit', 'fukwit', 'fux', 'fux0r', 'gaylord', 'goatse', 'heshe', 'hoare', 'hoer', 'hore', 'incest', 'jackoff', 'jism', 'kawk', 'knob', 'knobead', 'knobed', 'knobhead', 'knobjocky', 'knobjokey', 'l3i+ch', 'l3itch', 'm0f0', 'm0fo', 'm45terbate', 'ma5terb8', 'ma5terbate', 'master-bate', 'masterb8', 'masterbat*', 'masterbat3', 'masterbation', 'masterbations', 'masturbate', 'mo-fo', 'mof0', 'mofo', 'motherfucker', 'motherfuckka', 'mutha', 'muthafecker', 'muthafuckker', 'muther', 'mutherfucker', 'n1gga', 'n1gger', 'nazi', 'nigg3r', 'nigg4h', 'nigga', 'niggah', 'niggas', 'niggaz', 'nigger', 'nob', 'nob jokey', 'nobhead', 'nobjocky', 'nobjokey', 'numbnuts', 'nutsack', 'p0rn', 'pawn', 'penis', 'penisfucker', 'pharmacy', 'phuck', 'pigfucker', 'pimpis', 'piss', 'pissflaps', 'porn', 'prick', 'pron', 'pusse', 'pussi', 'pussy', 'rimjaw', 'rimming', 's.o.b.', 'schlong', 'scroat', 'scrote', 'scrotum', 'sh!+', 'sh!t', 'sh1t', 'shag', 'shagger', 'shaggin', 'shagging', 'shemale', 'shi+', 'shit', 'shitdick', 'shite', 'shited', 'shitey', 'shitfuck', 'shithead', 'shitter', 'slut', 'smut', 'snatch', 'spac', 't1tt1e5', 't1tties', 'teets', 'teez', 'testical', 'testicle', 'titfuck', 'tits', 'titt', 'tittie5', 'tittiefucker', 'titties', 'tittyfuck', 'tittywank', 'titwank', 'tw4t', 'twat', 'twathead', 'twatty', 'twunt', 'twunter', 'v14gra', 'v1gra', 'viagra', 'w00se', 'wang', 'wank', 'wanker', 'wanky', 'whoar', 'whore', 'willies', 'willy', 'xanax');
		
		//Check banned word occurances...
		foreach ($arrBanned as $banned) {
			
			//If a banned word was found, mark the string as spam...
			$strBanned = (substr_count(strtolower($strOriginal), (' ' . strtolower($banned) . ' ')) >= 1 ? true : false);
			
			//If a banned word was found, exit the loop...
			if ($strBanned) { break; }
			
		}
		
		//Calculate the number of non-alphanumerics characters...
		$strAlpha = (strlen($strOriginal) - strlen(preg_replace('/[^a-zA-Z0-9.!?\s]/', '', $strCheck)));
		
		//Create an array of status messages...
		$arrStatus = array();
		
		//If html was found...
		if ($strHTML) {
			
			//Add the error message to the status array...
			array_push($arrStatus, ('<span class="error-name">' . $name . '</span> must not contain HTML code.'));
			
		}
		
		//If a protocol was found...
		if ($strProtocol) {
			
			//Add the error message to the status array...
			array_push($arrStatus, ('<span class="error-name">' . $name . '</span> must not contain URLs.'));
			
		}
		
		//If a banned word was found...
		if ($strBanned) {
			
			//Add the error message to the status array...
			array_push($arrStatus, ('<span class="error-name">' . $name . '</span> must not contain potentially offensive content.'));
			
		}
		
		//Return the status messages...
		return $arrStatus;
		
	}
	
	//Function to validate a string...
	function checkValid($name, $type, $required, $string) {
		
		//Create an array of status messages...
		$arrStatus = array();
		
		//If the string is required, and is empty...
		if ($required == true && trim($string) == '') {
			
			//Add the error message to the status array...
			array_push($arrStatus, ('<span class="error-name">' . $name . '</span> is required.'));
			
		//Otherwise, if the string is not empty...
		} else if (trim($string) != '') {
		
			//If the string is an email...
			if ($type == 'email') {
				
				//Check it has an 'at' symbol...
				$strAt = (substr_count($string, '@') == 1 ? true : false);
				
				//Check it has at least one full stop...
				$strStop = (substr_count($string, '.') >= 1 ? true : false);
				
				//If either check was no good...
				if ($strAt == false || $strStop == false) {
					
					//Add the error message to the status array...
					array_push($arrStatus, ('<span class="error-name">' . $name . '</span> requires a valid email address.' . $strStop));
					
				}
				
			}
			
			//If the string is an text box and the string is a common spam phone number value...
			if ($type == 'text' && $string == '123456') {
				
				//Add the error message to the status array...
				array_push($arrStatus, ('<span class="error-name">' . $name . '</span> contains an invalid value.' . $strStop));
				
			}
			
			//Add other field type checks and validation here (phone, fax, select box, etc)...
			
		}
		
		//Return the status messages...
		return $arrStatus;
		
	}
	
	//Function to process checking and sending mail...
	function mailGate(
		$site,
		$recipient,
		$redirect = null,
		$fields = array(
			array('name' => 'Name', 'type' => 'text', 'required' => true),
			array('name' => 'Phone', 'type' => 'text', 'required' => true),
			array('name' => 'Email', 'type' => 'email', 'required' => true),
			array('name' => 'Message', 'type' => 'textarea', 'required' => true)
		)
	) {
		
		//If the form was submitted...
		if ($_POST['Send']) {
			
			//Create an error message...
			$errors = '';
			
			//For every field...
			foreach ($fields as $field) {
				
				//Get an array of spam errors...
				$spams = checkSpam($field['name'], $_POST[cleanSpaces($field['name'])]);
				
				//If there was spam errors...
				if ($spams) {
					
					//Flag the message as spam...
					$isSpam = true;
					
				}
				
				//For every spam error...
				foreach ($spams as $spam) {
					
					//Add to the error message...
					$errors .= ('<br />&nbsp;&nbsp;- ' . $spam);
					
				}
				
				//Get an array of validation errors...
				$valids = checkValid($field['name'], $field['type'], $field['required'], $_POST[cleanSpaces($field['name'])]);
				
				//For every validation error...
				foreach ($valids as $valid) {
					
					//Add to the error message...
					$errors .= ('<br />&nbsp;&nbsp;- ' . $valid);
					
				}
				
			}
			
			//If the number of post variables doesn't match the total variables of the form (plus one for the submit button)...
			if (count($_POST) != (count($fields) + 1)) {
				
				//Flag the message as spam...
				$isSpam = true;
				
				//Add to the error message...
				$errors .= ('<br />&nbsp;&nbsp;- Possible SPAM message.');
				
			}
			
			//Create mail recipient...
			$mailTo = $recipient;
			
			//Create mail subject...
			$mailSubject = $site . ' - Website Enquiry';
			
			//Create mail headers...
			$mailHeaders = 'From: ' . $_POST['Email'] . "\r\n";
			$mailHeaders .= 'MIME-Version: 1.0' . "\r\n";
			$mailHeaders .= 'Content-Type: text/plain; charset="iso-8859-1"' . "\r\n";
			$mailHeaders .= 'Content-Transfer-Encoding: 7bit' . "\r\n";
			$mailHeaders .= "\r\n";
			
			//Construct the message body...
			$mailMessage = 'The following enquiry has been received from the ' . $site . ' website.' . "\r\n\r\n";
			
			//Mark the message as safe...
			$mailSpam = false;
			
			//For every posted variable...
			foreach ($_POST as $name => $value) {
				
				//If it's not the send variable...
				if ($name != 'Send') {
					
					//Add the name and value to the message body...
					$mailMessage .= $name . ': ' . cleanSlashes(trim($value)) . "\r\n\r\n";
					
				}
				
			}
			
			//Add the footer...
			$mailMessage .= '---------------------------------------' . "\r\n\r\n";
			$mailMessage .= 'This enquiry form is protected by InfoLinkIT MailGate 2.0. If this message appears to be SPAM, please feel free to forward it to spambox@websitepromotion.net.au for analysis and to further improve this service.' . "\r\n\r\n";
			$mailMessage .= '---------------------------------------' . "\r\n\r\n";
			
			//If the message is spam...
			if ($isSpam) {
				
				//Send the mail to the spam box...
				$mailSend = mail('spambox@websitepromotion.net.au', $mailSubject, $mailMessage, $mailHeaders);			
				
			//Otherwise, if it's not spam and there was no errors...
			} else if (!$errors) {
				
				//Send the mail to the recipient...
				$mailSend = mail($mailTo, $mailSubject, $mailMessage, $mailHeaders);
				
				//If a redirect was requested...
				if ($redirect) {
					
					//Redirect to the requested location using Javascript, because headers have already been sent by the page containing the form...
					echo '<script type="text/javascript">location.href="' . $redirect . '";</script>';
					
				//Otherwise...
				} else {
					
					//Output a message...
					echo '<div class="sent"><p>Your message has been sent successfully.<br /><span class="sent-footnote">One of our friendly team will contact you as soon as possible.</span></p></div>';
					
				}
				
			}
			
			//If spam and validation errors were found...
			if ($errors) {
				
				//Output a message...
				echo '<div class="error"><p><span class="error-header">Sorry, the following problems were found:</span>' . $errors . '<br /><span class="error-footnote">Please correct these errors, and try sending your message again. If this error persists, please contact us via telephone and inform us of the problem.</span></p></div>';
				
			}
			
		}
	
?>
<form method="post" action="#enquiry">
	<?php foreach ($fields as $index => $field) { ?>
		<?php if ($field['type'] == 'text' || $field['type'] == 'email') { ?>
			<div class="input">
				<label><?php echo $field['name']; ?>:<?php if ($field['required'] == true) { ?><span class="required">*</span><?php } ?></label>
				<input type="text" name="<?php echo cleanSpaces($field['name']); ?>" value="<?php echo (($errors) ? cleanSlashes($_POST[cleanSpaces($field['name'])]) : ''); ?>" />
			</div>
		<?php } else if ($field['type'] == 'textarea') { ?>
			<div class="input">
				<textarea name="<?php echo cleanSpaces($field['name']); ?>" rows="10"><?php echo (($errors) ? cleanSlashes($_POST[cleanSpaces($field['name'])]) : ''); ?></textarea>
			</div>
		<?php } ?>
	<?php } ?>
	<p><input type="submit" name="Send" class="form-submit" value="Send" /></p>
</form>
<?php } ?>