<?php
	
	add_action( 'init', 'create_post_type' );
	function create_post_type() {		
		register_post_type( 'site_content',
			array(
				'labels' => array(
					'name' => __( 'Site Content' ),
					'singular_name' => __( 'Content' )
				),
			'public' => false,
			'has_archive' => false,
			'show_ui' => true,
			'supports' => array ( 'title', 'editor', 'custom-fields' )
			)
		);
	}
	
	function truncate_title($number = ''){
		// Change to the number of characters you want to display
									
		$text = get_the_title();
		$chars_limit = $number;                                            
		$chars_text = strlen($text);                                            
		$text = $text." ";                                            
		$text = substr($text,0,$chars_limit);                                            
		$text = substr($text,0,strrpos($text,' '));
		
		// If the text has more characters that your limit,
		//add ... so the user knows the text is actually longer
		
		if ($chars_text > $chars_limit){                                            
			$text = $text."...";                                            
		} 
		
		echo $text;
	}
	
	function truncate_content($number = ''){
		// Change to the number of characters you want to display
									
		$text = get_the_content();
		$chars_limit = $number;                                            
		$chars_text = strlen($text);                                            
		$text = $text." ";                                            
		$text = substr($text,0,$chars_limit);                                            
		$text = substr($text,0,strrpos($text,' '));
		
		// If the text has more characters that your limit,
		//add ... so the user knows the text is actually longer
		
		if ($chars_text > $chars_limit){                                            
			$text = $text."...";                                            
		} 
		
		echo $text;
	}
	
	/* Disable the Admin Bar for everyone. */
	show_admin_bar(false);
	
	add_theme_support('post-thumbnails');
	add_image_size('article-image', 160, 160, true);
	
	function insert_page($atts){
		extract(shortcode_atts(array(
			'pagename' => 'test',
		), $atts));
		
		ob_start();
		$return_string = include(''.$pagename.'');
		$result = ob_get_contents();
		ob_end_clean();		
		
		return $result;
	}
	add_shortcode('insert-page', 'insert_page');
	
	function short_text($before = '', $after = '', $echo = true, $length = false, $content) {
		$title = $content;
		$title = strip_tags($title);
		if ( $length && is_numeric($length) ) {
			$title = substr( $title, 0, $length );
		}
		
		if ( strlen($title)> 0 ) {
			$title = apply_filters('short_title', $before . $title . $after, $before, $after);
			if ( $echo )
			echo $title;
			else
			return $title;
		}
	}
	
?>