<?php
	
	//Include the browser detection file...
	require_once('includes/browser.php');
	
	//Define a new browser object...
	$browser = new Browser();
	
	//Get the browser version...
	$browserVersion = substr($browser->getVersion(), 0, strpos($browser->getVersion(), '.'));
	
	//Get the browser name...
	if($browser->getBrowser() == Browser::BROWSER_IE) {
		$browserName = 'IE';
	} else if($browser->getBrowser() == Browser::BROWSER_FIREFOX) {
		$browserName = 'FF';
	} else if($browser->getBrowser() == Browser::BROWSER_SAFARI) {
		$browserName = 'SF';
	} else if($browser->getBrowser() == Browser::BROWSER_CHROME) {
		$browserName = 'CH';
	}
	
	//Compile a new class string, and append it to the BODY tag classes...
	$browserInfo = ($browserName ? $browserName : 'X') . ($browserVersion ? ' ' . $browserName . $browserVersion : '');
	
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" <?php language_attributes(); ?>>
	<head>
		<meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php bloginfo('charset'); ?>" />
		<title><?php wp_title('-', true, 'right'); ?><?php bloginfo('name') ?></title>
        
		<link rel="stylesheet" href="<?php bloginfo('stylesheet_url'); ?>" type="text/css" media="screen" />
        <link rel="stylesheet" href="<?php print bloginfo('stylesheet_directory') . '/colorbox.css'; ?>" type="text/css" media="screen" />
		<link rel="shortcut icon" href="<?php print bloginfo('stylesheet_directory'); ?>/images/favicon.png" />

		<link rel="alternate" type="application/rss+xml" title="<?php bloginfo('name'); ?> RSS Feed" href="<?php bloginfo('rss2_url'); ?>" />
		<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />
        
		<?php wp_head(); ?>
        
        <script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jquery/1.6.1/jquery.min.js"></script>
        <script type="text/javascript" src="<?php print bloginfo('stylesheet_directory') . '/scripts/jcarousel.js'; ?>"></script>
		<script type="text/javascript" src="<?php print bloginfo('stylesheet_directory') . '/scripts/jquery.cycle.min.js'; ?>"></script>
        <script type="text/javascript" src="<?php print bloginfo('stylesheet_directory') . '/scripts/jquery.colorbox-min.js'; ?>"></script>
		<script type="text/javascript" src="<?php print bloginfo('stylesheet_directory') . '/scripts/scripts.js'; ?>"></script>
		
		<script>
		  (function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){
		  (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
		  m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)
		  })(window,document,'script','//www.google-analytics.com/analytics.js','ga'); 
		  ga('create', 'UA-40795427-1', 'onplatinum.net.au');
		  ga('send', 'pageview'); 
		</script>
	</head>
	<body class="<?php print $browserInfo; ?>">
		<div id="header-container">
        	<div id="header-bg">
            	<div id="header-constrain">
                	<a href="<?php print bloginfo('url'); ?>" title="onPlatinum ICT" id="logo"></a>
                    <div id="phone"><span>Call us:</span> 1300 428 667</div>
                    <div id="header-shadow"></div>
                    
                    <div id="navigation">
						<?php wp_page_menu('show_home=1'); ?>
                        <div class="clear"></div>
                    </div><!-- END #navigation -->
                    
                    <a href="http://www.facebook.com/pages/onPlatinum-ICT/268058323325251" class="social-button facebook" target="_blank"></a>
                    <a href="https://twitter.com/onplatinumict" class="social-button twitter" target="_blank"></a>
                    <a href="http://www.linkedin.com/company/2932962" class="social-button linkedin" target="_blank"></a>
                </div><!-- END #header-constrain -->
            </div><!-- END #header-bg -->
        </div><!-- END #header-container -->
        
        <div id="cta-container">
        	<div id="cta-bg">
            	<div id="slideshow-holder">
					
					<?php
					if(is_home()){ ?>
					
					<div id="slideshow">
                    	<ul>
                        	<li><img src="<?php print bloginfo('stylesheet_directory'); ?>/images/slide-2.jpg" alt="Slide 2"  height="255" width="980"/></li>
							<li><a href="<?php print bloginfo('url'); ?>/services/copiers-printers"><img src="<?php print bloginfo('stylesheet_directory'); ?>/images/slide-3.jpg" alt="Slide 3"  height="255" width="980" /></a></li>
                            <li><img src="<?php print bloginfo('stylesheet_directory'); ?>/images/slide-1.jpg" alt="Slide 1"  height="255" width="980"/></li>
                            <li><a href="<?php print bloginfo('url'); ?>/services/telephone-systems"><img src="<?php print bloginfo('stylesheet_directory'); ?>/images/slide-4.jpg" alt="Slide 4"  height="255" width="980" /></a></li>
                            <li><a href="<?php print bloginfo('url'); ?>/services/specials"><img src="<?php print bloginfo('stylesheet_directory'); ?>/images/slide-5.jpg" alt="Slide 5"  height="255" width="980"/></a></li>
                        </ul>
                    </div>
					
					<?php
					} else if(is_page('copiers-printers')) { ?>
					
					<div id="slideshow">
                    	<ul>
							<li><a href="<?php print bloginfo('url'); ?>/services/copiers-printers"><img src="<?php print bloginfo('stylesheet_directory'); ?>/images/slide-3.jpg" alt="Slide 3"  height="255" width="980" /></a></li>
                        	<li><img src="<?php print bloginfo('stylesheet_directory'); ?>/images/slide-2.jpg" alt="Slide 2"  height="255" width="980" /></li>	
							<li><a href="<?php print bloginfo('url'); ?>/services/telephone-systems"><img src="<?php print bloginfo('stylesheet_directory'); ?>/images/slide-4.jpg" alt="Slide 4"  height="255" width="980"/></a></li>
                            <li><img src="<?php print bloginfo('stylesheet_directory'); ?>/images/slide-1.jpg" alt="Slide 1"  height="255" width="980" /></li>                            
                            <li><a href="<?php print bloginfo('url'); ?>/services/specials"><img src="<?php print bloginfo('stylesheet_directory'); ?>/images/slide-5.jpg" alt="Slide 5"  height="255" width="980"/></a></li>
                        </ul>
                    </div>
					
					<?php
					} else if(is_page('telephone-systems')) { ?>
					
					<div id="slideshow">
                    	<ul>
							<li><a href="<?php print bloginfo('url'); ?>/services/telephone-systems"><img src="<?php print bloginfo('stylesheet_directory'); ?>/images/slide-4.jpg" alt="Slide 4"  height="255" width="980" /></a></li>
                        	<li><img src="<?php print bloginfo('stylesheet_directory'); ?>/images/slide-2.jpg" alt="Slide 2"  height="255" width="980"/></li>	
							<li><a href="<?php print bloginfo('url'); ?>/services/copiers-printers"><img src="<?php print bloginfo('stylesheet_directory'); ?>/images/slide-3.jpg" alt="Slide 3"  height="255" width="980" /></a></li>
                            <li><img src="<?php print bloginfo('stylesheet_directory'); ?>/images/slide-1.jpg" alt="Slide 1"  height="255" width="980"/></li>                            
                            <li><a href="<?php print bloginfo('url'); ?>/services/specials"><img src="<?php print bloginfo('stylesheet_directory'); ?>/images/slide-5.jpg" alt="Slide 5"  height="255" width="980"/></a></li>
                        </ul>
                    </div>
					
					<?php
					} else { ?>
					
                	<div id="slideshow">
                    	<ul>
                        	<li><img src="<?php print bloginfo('stylesheet_directory'); ?>/images/slide-2.jpg" alt="Slide 2"  height="255" width="980" /></li>
							<li><a href="<?php print bloginfo('url'); ?>/services/copiers-printers"><img src="<?php print bloginfo('stylesheet_directory'); ?>/images/slide-3.jpg" alt="Slide 3"  height="255" width="980" /></a></li>
                            <li><img src="<?php print bloginfo('stylesheet_directory'); ?>/images/slide-1.jpg" alt="Slide 1"  height="255" width="980"/></li>
                            <li><a href="<?php print bloginfo('url'); ?>/services/telephone-systems"><img src="<?php print bloginfo('stylesheet_directory'); ?>/images/slide-4.jpg" alt="Slide 4"  height="255" width="980"/></a></li>
                            <li><a href="<?php print bloginfo('url'); ?>/services/specials"><img src="<?php print bloginfo('stylesheet_directory'); ?>/images/slide-5.jpg" alt="Slide 5"  height="255" width="980"/></a></li>
                        </ul>
                    </div>
					
					<?php
					} ?>
                    
                    <div id="slide-changer">
                    	<a href="#"></a>
                        <a href="#"></a>
                        <a href="#"></a>
                        <a href="#"></a>
                        <a href="#" style="margin-right:0;"></a>
               		</div><!-- END #slide-changer -->
                    
                    <div id="slideshow-shadow"></div>
                </div><!-- END #slideshow-holder -->                
            </div><!-- END #cta-bg -->
        </div><!-- END #cta-container -->